/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime;

import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.rm.RmException;
import com.sun.xml.ws.rm.RmRuntimeException;
import com.sun.xml.ws.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.policy.Configuration;
import com.sun.xml.ws.rm.runtime.PacketAdapter;
import com.sun.xml.ws.rm.runtime.PeriodicFiberResumeTask;
import com.sun.xml.ws.rm.runtime.ProtocolCommunicator;
import com.sun.xml.ws.rm.runtime.Rm10ClientSession;
import com.sun.xml.ws.rm.runtime.Rm11ClientSession;
import com.sun.xml.ws.rm.runtime.ScheduledTaskManager;
import com.sun.xml.ws.rm.runtime.Utilities;
import com.sun.xml.ws.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rm.runtime.sequence.SequenceManager;
import com.sun.xml.ws.rm.runtime.sequence.SequenceManagerFactory;
import com.sun.xml.ws.rm.runtime.sequence.UnknownSequenceException;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

abstract class ClientSession {
    private static final RmLogger LOGGER = RmLogger.getLogger(ClientSession.class);
    private static final int MAX_INITIATE_SESSION_ATTEMPTS = 3;
    String inboundSequenceId = null;
    String outboundSequenceId = null;
    final Configuration configuration;
    final SequenceManager sequenceManager;
    final ProtocolCommunicator communicator;
    private final Lock initLock;
    private final ScheduledTaskManager scheduledTaskManager;
    private final AtomicLong lastAckRequestedTime = new AtomicLong(0L);
    private final PeriodicFiberResumeTask resendTask;

    static ClientSession create(Configuration configuration, ProtocolCommunicator communicator) {
        switch (configuration.getRmVersion()) {
            case WSRM10: {
                return new Rm10ClientSession(configuration, communicator);
            }
            case WSRM11: {
                return new Rm11ClientSession(configuration, communicator);
            }
        }
        throw new IllegalStateException(LocalizationMessages.WSRM_1104_RM_VERSION_NOT_SUPPORTED(configuration.getRmVersion().namespaceUri));
    }

    ClientSession(Configuration configuration, ProtocolCommunicator communicator) {
        this.initLock = new ReentrantLock();
        this.configuration = configuration;
        this.sequenceManager = SequenceManagerFactory.INSTANCE.getClientSequenceManager();
        this.communicator = communicator;
        this.scheduledTaskManager = new ScheduledTaskManager();
        this.resendTask = new PeriodicFiberResumeTask(configuration.getMessageRetransmissionInterval());
    }

    abstract void openRmSession(String var1, SecurityTokenReferenceType var2) throws RmRuntimeException;

    abstract void closeOutboundSequence() throws RmException;

    abstract void terminateOutboundSequence() throws RmException;

    final void processInboundMessageHeaders(PacketAdapter responseAdapter, boolean expectSequenceHeader) throws RmRuntimeException {
        String ackRequestedSequenceId;
        if (expectSequenceHeader) {
            String sequenceId = responseAdapter.getSequenceId();
            if (sequenceId != null) {
                Utilities.assertSequenceId(this.inboundSequenceId, sequenceId);
                this.sequenceManager.getSequence(sequenceId).acknowledgeMessageId(responseAdapter.getMessageNumber());
            } else {
                throw new RmRuntimeException(LocalizationMessages.WSRM_1118_MANDATORY_HEADER_NOT_PRESENT("wsrm:Sequence"));
            }
        }
        if ((ackRequestedSequenceId = responseAdapter.getAckRequestedHeaderSequenceId()) != null) {
            Utilities.assertSequenceId(this.inboundSequenceId, ackRequestedSequenceId);
            this.sequenceManager.getSequence(ackRequestedSequenceId).setAckRequestedFlag();
        }
        responseAdapter.processAcknowledgements(this.sequenceManager, this.outboundSequenceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void requestAcknowledgement() throws RmException {
        PacketAdapter responseAdapter = null;
        try {
            PacketAdapter requestAdapter = PacketAdapter.getInstance(this.configuration, this.communicator.createEmptyRequestPacket());
            requestAdapter.setEmptyRequestMessage(this.configuration.getRmVersion().ackRequestedAction).appendAckRequestedHeader(this.outboundSequenceId);
            responseAdapter = PacketAdapter.getInstance(this.configuration, this.communicator.send(requestAdapter.getPacket()));
            if (!responseAdapter.containsMessage()) {
                throw new RmException(LocalizationMessages.WSRM_1108_NULL_RESPONSE_FOR_ACK_REQUEST());
            }
            this.processInboundMessageHeaders(responseAdapter, false);
            if (responseAdapter.isFault()) {
                throw new RmException(LocalizationMessages.WSRM_1109_SOAP_FAULT_RESPONSE_FOR_ACK_REQUEST(), responseAdapter.message);
            }
        }
        finally {
            if (responseAdapter != null) {
                responseAdapter.consume();
            }
        }
    }

    final Packet processOutgoingPacket(Packet requestPacket) {
        Sequence inboundSequence;
        PacketAdapter requestAdapter = PacketAdapter.getInstance(this.configuration, requestPacket);
        this.initializeIfNecessary(requestAdapter);
        requestAdapter.appendSequenceHeader(this.outboundSequenceId, this.sequenceManager.getSequence(this.outboundSequenceId).generateNextMessageId());
        if (this.isPendingAckRequest()) {
            requestAdapter.appendAckRequestedHeader(this.outboundSequenceId);
            this.lastAckRequestedTime.set(System.currentTimeMillis());
        }
        if (this.inboundSequenceId != null && (inboundSequence = this.sequenceManager.getSequence(this.inboundSequenceId)).getLastMessageId() > 0L) {
            requestAdapter.appendSequenceAcknowledgementHeader(this.sequenceManager.getSequence(this.inboundSequenceId));
        }
        return requestAdapter.getPacket();
    }

    final Packet processIncommingPacket(Packet responsePacket, boolean responseToOneWayRequest) throws RmRuntimeException {
        PacketAdapter responseAdapter = PacketAdapter.getInstance(this.configuration, responsePacket);
        if (responseAdapter.containsMessage()) {
            this.processInboundMessageHeaders(responseAdapter, !responseToOneWayRequest && !responseAdapter.isProtocolMessage());
        }
        return responseAdapter.getPacket();
    }

    final boolean registerForResend(Fiber fiber, Packet packet) {
        return this.resendTask.registerForResume(fiber, packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void close() {
        try {
            try {
                this.closeOutboundSequence();
            }
            catch (RmException ex) {
                LOGGER.logException(ex, Level.WARNING);
            }
            finally {
                try {
                    this.sequenceManager.closeSequence(this.outboundSequenceId);
                }
                catch (UnknownSequenceException ex) {
                    LOGGER.logException(ex, Level.WARNING);
                }
            }
            try {
                this.waitUntilAllRequestsAckedOrTimeout();
                this.terminateOutboundSequence();
            }
            catch (RmException ex) {
                LOGGER.logException(ex, Level.WARNING);
            }
            finally {
                try {
                    this.sequenceManager.terminateSequence(this.outboundSequenceId);
                }
                catch (UnknownSequenceException ex) {
                    LOGGER.logException(ex, Level.WARNING);
                }
            }
            if (this.inboundSequenceId != null && this.sequenceManager.isValid(this.inboundSequenceId)) {
                try {
                    if (!this.sequenceManager.getSequence(this.inboundSequenceId).isClosed()) {
                        this.sequenceManager.closeSequence(this.inboundSequenceId);
                    }
                    this.sequenceManager.terminateSequence(this.inboundSequenceId);
                }
                catch (UnknownSequenceException ex) {
                    LOGGER.logException(ex, Level.WARNING);
                }
            }
        }
        finally {
            this.scheduledTaskManager.stopAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeIfNecessary(PacketAdapter request) throws RmRuntimeException {
        this.initLock.lock();
        try {
            if (!this.isInitialized()) {
                this.communicator.registerMusterRequestPacket(request.copyPacket(false));
                int numberOfInitiateSessionAttempts = 0;
                while (true) {
                    try {
                        this.openRmSession(this.configuration.requestResponseOperationsDetected() ? this.sequenceManager.generateSequenceUID() : null, this.communicator.tryStartSecureConversation());
                    }
                    catch (Exception ex) {
                        LOGGER.warning(LocalizationMessages.WSRM_1106_RM_SESSION_INIT_ATTEMPT_FAILED(), ex);
                    }
                    finally {
                        if (++numberOfInitiateSessionAttempts <= 3) continue;
                        throw LOGGER.logSevereException(new RmRuntimeException(LocalizationMessages.WSRM_1107_MAX_RM_SESSION_INIT_ATTEMPTS_REACHED()));
                    }
                    break;
                }
                this.scheduledTaskManager.startTasks(this.resendTask, this.createAckRequesterTask());
            }
        }
        finally {
            this.initLock.unlock();
        }
    }

    private boolean isInitialized() {
        return this.outboundSequenceId != null;
    }

    private Runnable createAckRequesterTask() {
        return new Runnable(){

            public void run() {
                try {
                    if (ClientSession.this.isPendingAckRequest()) {
                        ClientSession.this.requestAcknowledgement();
                        ClientSession.this.lastAckRequestedTime.set(System.currentTimeMillis());
                    }
                }
                catch (RmException ex) {
                    LOGGER.warning(LocalizationMessages.WSRM_1110_ACK_REQUEST_FAILED(), ex);
                }
            }
        };
    }

    private boolean isPendingAckRequest() throws RmRuntimeException {
        return this.lastAckRequestedTime.get() - System.currentTimeMillis() > this.configuration.getAcknowledgementRequestInterval() && this.sequenceManager.getSequence(this.outboundSequenceId).hasPendingAcknowledgements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilAllRequestsAckedOrTimeout() {
        final CountDownLatch doneSignal = new CountDownLatch(1);
        ScheduledFuture<?> taskHandle = this.scheduledTaskManager.startTask(new Runnable(){

            public void run() {
                try {
                    if (!ClientSession.this.sequenceManager.getSequence(ClientSession.this.outboundSequenceId).hasPendingAcknowledgements()) {
                        doneSignal.countDown();
                    }
                }
                catch (UnknownSequenceException ex) {
                    LOGGER.severe(LocalizationMessages.WSRM_1111_UNEXPECTED_EXCEPTION_WHILE_WAITING_FOR_SEQ_ACKS(), (Throwable)((Object)ex));
                    doneSignal.countDown();
                }
            }
        });
        try {
            if (this.configuration.getCloseSequenceOperationTimeout() > 0L) {
                boolean waitResult = doneSignal.await(this.configuration.getCloseSequenceOperationTimeout(), TimeUnit.MILLISECONDS);
                if (!waitResult) {
                    LOGGER.info(LocalizationMessages.WSRM_1112_CLOSE_OUTBOUND_SEQUENCE_TIMED_OUT(this.outboundSequenceId));
                }
            } else {
                doneSignal.await();
            }
        }
        catch (InterruptedException ex) {
            LOGGER.fine(LocalizationMessages.WSRM_1113_CLOSE_OUTBOUND_SEQUENCE_INTERRUPTED(this.outboundSequenceId), ex);
        }
        finally {
            taskHandle.cancel(true);
        }
    }
}

