/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime;

import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.rm.runtime.PacketAdapter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum FlowControledFibers {
    INSTANCE;

    private final Map<String, Queue<FiberRegistration>> repository = new HashMap<String, Queue<FiberRegistration>>();
    private final ReadWriteLock repositoryLock = new ReentrantReadWriteLock();
    private final Comparator<FiberRegistration> registrationComparator = new Comparator<FiberRegistration>(){

        @Override
        public int compare(FiberRegistration r1, FiberRegistration r2) {
            return r1.packetAdapter.getMessageNumber() < r2.packetAdapter.getMessageNumber() ? -1 : (r1.packetAdapter.getMessageNumber() == r2.packetAdapter.getMessageNumber() ? 0 : 1);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerForResume(Fiber fiber, PacketAdapter packetAdapter) {
        FiberRegistration registration = new FiberRegistration(fiber, packetAdapter);
        String sequenceId = packetAdapter.getSequenceId();
        try {
            Queue<FiberRegistration> sequenceFibers;
            this.repositoryLock.writeLock().lock();
            if (!this.repository.containsKey(sequenceId)) {
                sequenceFibers = new PriorityQueue<FiberRegistration>(10, this.registrationComparator);
                this.repository.put(sequenceId, sequenceFibers);
            } else {
                sequenceFibers = this.repository.get(sequenceId);
            }
            sequenceFibers.offer(registration);
        }
        finally {
            this.repositoryLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean tryResume(String sequenceId, long messageId) {
        FiberRegistration registration;
        Queue<FiberRegistration> sequenceBuffer = this.getSequenceBuffer(sequenceId);
        if (sequenceBuffer == null) {
            return false;
        }
        try {
            this.repositoryLock.writeLock().lock();
            if (sequenceBuffer.peek().packetAdapter.getMessageNumber() != messageId) {
                boolean bl = false;
                return bl;
            }
            registration = sequenceBuffer.poll();
        }
        finally {
            this.repositoryLock.writeLock().lock();
        }
        registration.fiber.resume(registration.packetAdapter.getPacket());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getUsedBufferSize(String sequenceId) {
        Queue<FiberRegistration> sequenceBuffer = this.getSequenceBuffer(sequenceId);
        if (sequenceBuffer == null) {
            return 0;
        }
        try {
            this.repositoryLock.readLock().lock();
            int n = sequenceBuffer.size();
            return n;
        }
        finally {
            this.repositoryLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Queue<FiberRegistration> getSequenceBuffer(String sequenceId) {
        try {
            this.repositoryLock.readLock().lock();
            Queue<FiberRegistration> queue = this.repository.get(sequenceId);
            return queue;
        }
        finally {
            this.repositoryLock.readLock().unlock();
        }
    }

    private static class FiberRegistration {
        PacketAdapter packetAdapter;
        Fiber fiber;

        FiberRegistration(Fiber fiber, PacketAdapter packetAdapter) {
            this.fiber = fiber;
            this.packetAdapter = packetAdapter;
        }
    }
}

