/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.dsig;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLDSigSecurity;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;

public abstract class TransformService
implements Transform {
    private String algorithm;
    private String mechanism;
    private Provider provider;

    protected TransformService() {
    }

    public static TransformService getInstance(String string, String string2) throws NoSuchAlgorithmException {
        if (string2 == null || string == null) {
            throw new NullPointerException();
        }
        return TransformService.findInstance(string, string2, null);
    }

    public static TransformService getInstance(String string, String string2, Provider provider) throws NoSuchAlgorithmException {
        if (string2 == null || string == null || provider == null) {
            throw new NullPointerException();
        }
        return TransformService.findInstance(string, string2, provider);
    }

    public static TransformService getInstance(String string, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null || string == null || string3 == null) {
            throw new NullPointerException();
        }
        Provider provider = Security.getProvider(string3);
        if (provider == null) {
            throw new NoSuchProviderException("cannot find provider named " + string3);
        }
        return TransformService.findInstance(string, string2, provider);
    }

    private static TransformService findInstance(String string, String string2, Provider provider) throws NoSuchAlgorithmException {
        Object[] objectArray = XMLDSigSecurity.getImpl(string, new MechanismMapEntry(string, string2), "TransformService", provider);
        TransformService transformService = (TransformService)objectArray[0];
        transformService.mechanism = string2;
        transformService.algorithm = string;
        transformService.provider = (Provider)objectArray[1];
        return transformService;
    }

    public final String getMechanismType() {
        return this.mechanism;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public abstract void init(TransformParameterSpec var1) throws InvalidAlgorithmParameterException;

    public abstract void marshalParams(XMLStructure var1, XMLCryptoContext var2) throws MarshalException;

    public abstract void init(XMLStructure var1, XMLCryptoContext var2) throws InvalidAlgorithmParameterException;

    private static class MechanismMapEntry
    implements Map.Entry {
        private final String mechanism;
        private final String algorithm;
        private final String key;

        MechanismMapEntry(String string, String string2) {
            this.algorithm = string;
            this.mechanism = string2;
            this.key = "TransformService." + string + " MechanismType";
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return (this.getKey() == null ? entry.getKey() == null : this.getKey().equals(entry.getKey())) && (this.getValue() == null ? entry.getValue() == null : this.getValue().equals(entry.getValue()));
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.mechanism;
        }

        public Object setValue(Object object) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }
    }
}

