/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.spec.DigestMethodParameterSpec;
import org.jcp.xml.dsig.internal.dom.DOMSHADigestMethod;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class DOMDigestMethod
extends DOMStructure
implements DigestMethod {
    private DigestMethodParameterSpec params;

    protected DOMDigestMethod(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null && !(algorithmParameterSpec instanceof DigestMethodParameterSpec)) {
            throw new InvalidAlgorithmParameterException("params must be of type DigestMethodParameterSpec");
        }
        this.checkParams((DigestMethodParameterSpec)algorithmParameterSpec);
        this.params = (DigestMethodParameterSpec)algorithmParameterSpec;
    }

    protected DOMDigestMethod(Element element) throws MarshalException {
        Element element2 = DOMUtils.getFirstChildElement(element);
        if (element2 != null) {
            this.params = this.unmarshalParams(element2);
        }
        try {
            this.checkParams(this.params);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new MarshalException(invalidAlgorithmParameterException);
        }
    }

    static DigestMethod unmarshal(Element element) throws MarshalException {
        String string = DOMUtils.getAttributeValue(element, "Algorithm");
        if (string.equals("http://www.w3.org/2000/09/xmldsig#sha1")) {
            return DOMSHADigestMethod.SHA1(element);
        }
        if (string.equals("http://www.w3.org/2001/04/xmlenc#sha256")) {
            return DOMSHADigestMethod.SHA256(element);
        }
        if (string.equals("http://www.w3.org/2001/04/xmlenc#sha512")) {
            return DOMSHADigestMethod.SHA512(element);
        }
        throw new MarshalException("unsupported digest algorithm: " + string);
    }

    protected abstract void checkParams(DigestMethodParameterSpec var1) throws InvalidAlgorithmParameterException;

    public final AlgorithmParameterSpec getParameterSpec() {
        return this.params;
    }

    protected abstract DigestMethodParameterSpec unmarshalParams(Element var1) throws MarshalException;

    public void marshal(Node node, String string, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Document document = DOMUtils.getOwnerDocument(node);
        Element element = DOMUtils.createElement(document, "DigestMethod", "http://www.w3.org/2000/09/xmldsig#", string);
        DOMUtils.setAttribute(element, "Algorithm", this.getAlgorithm());
        if (this.params != null) {
            this.marshalParams(element, string);
        }
        node.appendChild(element);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DigestMethod)) {
            return false;
        }
        DigestMethod digestMethod = (DigestMethod)object;
        boolean bl = this.params == null ? digestMethod.getParameterSpec() == null : this.params.equals(digestMethod.getParameterSpec());
        return this.getAlgorithm().equals(digestMethod.getAlgorithm()) && bl;
    }

    public int hashCode() {
        return 51;
    }

    protected abstract void marshalParams(Element var1, String var2) throws MarshalException;

    abstract String getMessageDigestAlgorithm();
}

