/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.misc;

import com.sun.xml.ws.security.impl.kerberos.KerberosContext;
import com.sun.xml.ws.security.impl.kerberos.KerberosLogin;
import com.sun.xml.ws.security.opt.impl.util.SOAPUtil;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.RealmAuthenticationAdapter;
import com.sun.xml.wss.SecurityEnvironment;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.Timestamp;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.WssSoapFaultException;
import com.sun.xml.wss.impl.callback.CertificateValidationCallback;
import com.sun.xml.wss.impl.callback.DecryptionKeyCallback;
import com.sun.xml.wss.impl.callback.DynamicPolicyCallback;
import com.sun.xml.wss.impl.callback.EncryptionKeyCallback;
import com.sun.xml.wss.impl.callback.PasswordCallback;
import com.sun.xml.wss.impl.callback.PasswordValidationCallback;
import com.sun.xml.wss.impl.callback.SignatureKeyCallback;
import com.sun.xml.wss.impl.callback.SignatureVerificationKeyCallback;
import com.sun.xml.wss.impl.callback.TimestampValidationCallback;
import com.sun.xml.wss.impl.callback.UsernameCallback;
import com.sun.xml.wss.impl.configuration.DynamicApplicationContext;
import com.sun.xml.wss.impl.misc.Base64;
import com.sun.xml.wss.impl.misc.DefaultCallbackHandler;
import com.sun.xml.wss.impl.misc.NonceCache;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.saml.Assertion;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.x500.X500Principal;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultSecurityEnvironmentImpl
implements SecurityEnvironment {
    static final boolean USE_DAEMON_THREAD = true;
    static final Timer nonceCleanupTimer = new Timer(true);
    private static final long offset;
    private NonceCache nonceCache = null;
    protected static final Logger log;
    private final SimpleDateFormat calendarFormatter1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final SimpleDateFormat calendarFormatter2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'");
    private CallbackHandler callbackHandler = null;
    private boolean isDefaultHandler = false;
    private X509Certificate selfCertificate = null;
    private Properties configAssertions = null;

    public DefaultSecurityEnvironmentImpl(CallbackHandler cHandler) {
        this.callbackHandler = cHandler;
        if (this.callbackHandler instanceof DefaultCallbackHandler) {
            this.isDefaultHandler = true;
        }
        if (this.callbackHandler != null && this.callbackHandler instanceof DefaultCallbackHandler) {
            try {
                Object defaultCert = null;
                SignatureKeyCallback.DefaultPrivKeyCertRequest privKeyRequest = new SignatureKeyCallback.DefaultPrivKeyCertRequest();
                SignatureKeyCallback sigKeyCallback = new SignatureKeyCallback(privKeyRequest);
                Callback[] callbacks = new Callback[]{sigKeyCallback};
                this.callbackHandler.handle(callbacks);
                this.selfCertificate = privKeyRequest.getX509Certificate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public DefaultSecurityEnvironmentImpl(CallbackHandler cHandler, Properties confAssertions) {
        this.configAssertions = confAssertions;
        this.callbackHandler = cHandler;
        if (this.callbackHandler instanceof DefaultCallbackHandler) {
            this.isDefaultHandler = true;
        }
        String myAlias = this.configAssertions.getProperty("my.alias");
        if (this.callbackHandler != null && myAlias != null && this.callbackHandler instanceof DefaultCallbackHandler) {
            try {
                Object defaultCert = null;
                SignatureKeyCallback.DefaultPrivKeyCertRequest privKeyRequest = new SignatureKeyCallback.DefaultPrivKeyCertRequest();
                SignatureKeyCallback sigKeyCallback = new SignatureKeyCallback(privKeyRequest);
                Callback[] callbacks = new Callback[]{sigKeyCallback};
                this.callbackHandler.handle(callbacks);
                this.selfCertificate = privKeyRequest.getX509Certificate();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public X509Certificate getDefaultCertificate(Map context) throws XWSSecurityException {
        X509Certificate defaultCert = null;
        SignatureKeyCallback.DefaultPrivKeyCertRequest privKeyRequest = new SignatureKeyCallback.DefaultPrivKeyCertRequest();
        SignatureKeyCallback sigKeyCallback = new SignatureKeyCallback(privKeyRequest);
        if (context != null) {
            ProcessingContext.copy(sigKeyCallback.getRuntimeProperties(), context);
        }
        Callback[] callbacks = new Callback[]{sigKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"SignatureKeyCallback.DefaultPrivKeyCertRequest"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        defaultCert = privKeyRequest.getX509Certificate();
        if (defaultCert == null) {
            log.log(Level.SEVERE, "WSS0218.cannot.locate.default.cert");
            throw new XWSSecurityException("Unable to locate a default certificate");
        }
        return defaultCert;
    }

    public SignatureKeyCallback.PrivKeyCertRequest getDefaultPrivKeyCertRequest(Map context) throws XWSSecurityException {
        SignatureKeyCallback.DefaultPrivKeyCertRequest privKeyRequest = new SignatureKeyCallback.DefaultPrivKeyCertRequest();
        SignatureKeyCallback sigKeyCallback = new SignatureKeyCallback(privKeyRequest);
        if (context != null) {
            ProcessingContext.copy(sigKeyCallback.getRuntimeProperties(), context);
        }
        Callback[] callbacks = new Callback[]{sigKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"SignatureKeyCallback.DefaultPrivKeyCertRequest"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        return privKeyRequest;
    }

    public SignatureKeyCallback.AliasPrivKeyCertRequest getAliasPrivKeyCertRequest(String certIdentifier) throws XWSSecurityException {
        SignatureKeyCallback.AliasPrivKeyCertRequest request = new SignatureKeyCallback.AliasPrivKeyCertRequest(certIdentifier);
        SignatureKeyCallback sigCallback = new SignatureKeyCallback(request);
        Callback[] callback = new Callback[]{sigCallback};
        try {
            this.callbackHandler.handle(callback);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"SignatureKeyCallback.AliasPrivKeyCertRequest"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        return request;
    }

    public PrivateKey getDefaultPrivateKey(Map context) throws XWSSecurityException {
        PrivateKey defaultPrivKey = null;
        SignatureKeyCallback.DefaultPrivKeyCertRequest privKeyRequest = new SignatureKeyCallback.DefaultPrivKeyCertRequest();
        SignatureKeyCallback sigKeyCallback = new SignatureKeyCallback(privKeyRequest);
        if (context != null) {
            ProcessingContext.copy(sigKeyCallback.getRuntimeProperties(), context);
        }
        Callback[] callbacks = new Callback[]{sigKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"SignatureKeyCallback.DefaultPrivKeyCertRequest"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        defaultPrivKey = privKeyRequest.getPrivateKey();
        if (defaultPrivKey == null) {
            log.log(Level.SEVERE, "WSS0219.cannot.locate.default.privkey");
            throw new XWSSecurityException("Unable to locate a default certificate");
        }
        return defaultPrivKey;
    }

    public SecretKey getSecretKey(Map context, String alias, boolean encryptMode) throws XWSSecurityException {
        SecretKey symmetricKey = null;
        if (encryptMode) {
            EncryptionKeyCallback.AliasSymmetricKeyRequest symmKeyRequest = new EncryptionKeyCallback.AliasSymmetricKeyRequest(alias);
            EncryptionKeyCallback encKeyCallback = new EncryptionKeyCallback(symmKeyRequest);
            if (!this.isDefaultHandler) {
                ProcessingContext.copy(encKeyCallback.getRuntimeProperties(), context);
            }
            Callback[] callbacks = new Callback[]{encKeyCallback};
            try {
                this.callbackHandler.handle(callbacks);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"EncryptionKeyCallback.AliasSymmetricKeyRequest"});
                log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
                throw new XWSSecurityException(e);
            }
            symmetricKey = symmKeyRequest.getSymmetricKey();
        } else {
            DecryptionKeyCallback.AliasSymmetricKeyRequest symmKeyRequest = new DecryptionKeyCallback.AliasSymmetricKeyRequest(alias);
            DecryptionKeyCallback decryptKeyCallback = new DecryptionKeyCallback(symmKeyRequest);
            if (!this.isDefaultHandler) {
                ProcessingContext.copy(decryptKeyCallback.getRuntimeProperties(), context);
            }
            Callback[] callbacks = new Callback[]{decryptKeyCallback};
            try {
                this.callbackHandler.handle(callbacks);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"DecryptionKeyCallback.AliasSymmetricKeyRequest"});
                log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
                throw new XWSSecurityException(e);
            }
            symmetricKey = symmKeyRequest.getSymmetricKey();
        }
        if (symmetricKey == null) {
            log.log(Level.SEVERE, "WSS0220.cannot.locate.symmetrickey.for.decrypt");
            throw new XWSSecurityException("Could not locate the symmetric key for alias '" + alias + "'");
        }
        return symmetricKey;
    }

    public X509Certificate getCertificate(Map context, String alias, boolean forSigning) throws XWSSecurityException {
        Object certRequest;
        X509Certificate cert = null;
        if (alias == null || "".equals(alias) && forSigning) {
            return this.getDefaultCertificate(context);
        }
        if (forSigning) {
            certRequest = new SignatureKeyCallback.AliasPrivKeyCertRequest(alias);
            SignatureKeyCallback sigKeyCallback = new SignatureKeyCallback((SignatureKeyCallback.Request)certRequest);
            if (!this.isDefaultHandler) {
                ProcessingContext.copy(sigKeyCallback.getRuntimeProperties(), context);
            }
            Callback[] callbacks = new Callback[]{sigKeyCallback};
            try {
                this.callbackHandler.handle(callbacks);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"SignatureKeyCallback.AliasPrivKeyCertRequest"});
                log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
                throw new XWSSecurityException(e);
            }
            cert = ((SignatureKeyCallback.PrivKeyCertRequest)certRequest).getX509Certificate();
        } else {
            certRequest = new EncryptionKeyCallback.AliasX509CertificateRequest(alias);
            EncryptionKeyCallback encKeyCallback = new EncryptionKeyCallback((EncryptionKeyCallback.Request)certRequest);
            ProcessingContext.copy(encKeyCallback.getRuntimeProperties(), context);
            Callback[] callbacks = new Callback[]{encKeyCallback};
            try {
                this.callbackHandler.handle(callbacks);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"EncryptionKeyCallback.AliasX509CertificateRequest"});
                log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
                throw new XWSSecurityException(e);
            }
            cert = ((EncryptionKeyCallback.X509CertificateRequest)certRequest).getX509Certificate();
        }
        if (cert == null) {
            String val = forSigning ? "Signature" : "Key Encryption";
            log.log(Level.SEVERE, "WSS0221.cannot.locate.cert", new Object[]{val});
            throw new XWSSecurityException("Unable to locate certificate for the alias '" + alias + "'");
        }
        return cert;
    }

    public X509Certificate getCertificate(Map context, PublicKey publicKey, boolean forSign) throws XWSSecurityException {
        if (forSign) {
            SignatureVerificationKeyCallback.PublicKeyBasedRequest pubKeyReq = new SignatureVerificationKeyCallback.PublicKeyBasedRequest(publicKey);
            SignatureVerificationKeyCallback verifyKeyCallback = new SignatureVerificationKeyCallback(pubKeyReq);
            if (!this.isDefaultHandler) {
                ProcessingContext.copy(verifyKeyCallback.getRuntimeProperties(), context);
            }
            Callback[] callbacks = new Callback[]{verifyKeyCallback};
            try {
                this.callbackHandler.handle(callbacks);
            }
            catch (UnsupportedCallbackException e1) {
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"SignatureVerificationKeyCallback.PublicKeyBasedRequest"});
                log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
                throw new XWSSecurityException(e);
            }
            return pubKeyReq.getX509Certificate();
        }
        EncryptionKeyCallback.PublicKeyBasedRequest pubKeyReq = new EncryptionKeyCallback.PublicKeyBasedRequest(publicKey);
        EncryptionKeyCallback encCallback = new EncryptionKeyCallback(pubKeyReq);
        if (!this.isDefaultHandler) {
            ProcessingContext.copy(encCallback.getRuntimeProperties(), context);
        }
        Callback[] callbacks = new Callback[]{encCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (UnsupportedCallbackException e1) {
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"EncryptionKeyCallback.PublicKeyBasedRequest"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        return pubKeyReq.getX509Certificate();
    }

    public PrivateKey getPrivateKey(Map context, String alias) throws XWSSecurityException {
        PrivateKey privKey = null;
        if (alias == null) {
            return this.getDefaultPrivateKey(context);
        }
        SignatureKeyCallback.AliasPrivKeyCertRequest privKeyRequest = new SignatureKeyCallback.AliasPrivKeyCertRequest(alias);
        SignatureKeyCallback sigKeyCallback = new SignatureKeyCallback(privKeyRequest);
        if (!this.isDefaultHandler) {
            ProcessingContext.copy(sigKeyCallback.getRuntimeProperties(), context);
        }
        Callback[] callbacks = new Callback[]{sigKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"SignatureKeyCallback.AliasPrivKeyCertRequest"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        privKey = privKeyRequest.getPrivateKey();
        if (privKey == null) {
            log.log(Level.SEVERE, "WSS0222.cannot.locate.privkey", new Object[]{alias});
            throw new XWSSecurityException("Unable to locate private key for the alias " + alias);
        }
        return privKey;
    }

    public PrivateKey getPrivateKey(Map context, byte[] identifier, String valueType) throws XWSSecurityException {
        if ("Identifier".equals(valueType)) {
            return this.getPrivateKey(context, identifier);
        }
        PrivateKey privateKey = null;
        DecryptionKeyCallback.ThumbprintBasedRequest privKeyRequest = new DecryptionKeyCallback.ThumbprintBasedRequest(identifier);
        DecryptionKeyCallback decryptKeyCallback = new DecryptionKeyCallback(privKeyRequest);
        if (!this.isDefaultHandler) {
            ProcessingContext.copy(decryptKeyCallback.getRuntimeProperties(), context);
        }
        Callback[] callbacks = new Callback[]{decryptKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"DecryptionKeyCallback.ThumbprintBasedRequest"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        privateKey = privKeyRequest.getPrivateKey();
        if (privateKey == null) {
            log.log(Level.SEVERE, "WSS0222.cannot.locate.privkey", new Object[]{identifier});
            throw new XWSSecurityException("No Matching private key for " + Base64.encode(identifier) + " thumb print identifier found");
        }
        return privateKey;
    }

    public PrivateKey getPrivateKey(Map context, byte[] keyIdentifier) throws XWSSecurityException {
        PrivateKey privateKey = null;
        DecryptionKeyCallback.X509SubjectKeyIdentifierBasedRequest privKeyRequest = new DecryptionKeyCallback.X509SubjectKeyIdentifierBasedRequest(keyIdentifier);
        DecryptionKeyCallback decryptKeyCallback = new DecryptionKeyCallback(privKeyRequest);
        if (!this.isDefaultHandler) {
            ProcessingContext.copy(decryptKeyCallback.getRuntimeProperties(), context);
        }
        Callback[] callbacks = new Callback[]{decryptKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"DecryptionKeyCallback.X509SubjectKeyIdentifierBasedRequest"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        privateKey = privKeyRequest.getPrivateKey();
        if (privateKey == null) {
            log.log(Level.SEVERE, "WSS0222.cannot.locate.privkey", new Object[]{keyIdentifier});
            throw new XWSSecurityException("No Matching private key for " + Base64.encode(keyIdentifier) + " subject key identifier found");
        }
        return privateKey;
    }

    public PrivateKey getPrivateKey(Map context, BigInteger serialNumber, String issuerName) throws XWSSecurityException {
        PrivateKey privateKey = null;
        DecryptionKeyCallback.X509IssuerSerialBasedRequest privKeyRequest = new DecryptionKeyCallback.X509IssuerSerialBasedRequest(issuerName, serialNumber);
        DecryptionKeyCallback decryptKeyCallback = new DecryptionKeyCallback(privKeyRequest);
        if (!this.isDefaultHandler) {
            ProcessingContext.copy(decryptKeyCallback.getRuntimeProperties(), context);
        }
        Callback[] callbacks = new Callback[]{decryptKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"DecryptionKeyCallback.X509IssuerSerialBasedRequest"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        privateKey = privKeyRequest.getPrivateKey();
        if (privateKey == null) {
            log.log(Level.SEVERE, "WSS0222.cannot.locate.privkey", new Object[]{serialNumber + ":" + issuerName});
            throw new XWSSecurityException("No Matching private key for serial number " + serialNumber + " and issuer name " + issuerName + " found");
        }
        return privateKey;
    }

    public PublicKey getPublicKey(Map context, byte[] identifier, String valueType) throws XWSSecurityException {
        return this.getCertificate(context, identifier, valueType).getPublicKey();
    }

    public PublicKey getPublicKey(Map context, byte[] keyIdentifier) throws XWSSecurityException {
        return this.getCertificate(context, keyIdentifier).getPublicKey();
    }

    public X509Certificate getCertificate(Map context, byte[] identifier, String valueType) throws XWSSecurityException {
        if ("Identifier".equals(valueType)) {
            return this.getCertificate(context, identifier);
        }
        X509Certificate cert = null;
        SignatureVerificationKeyCallback.ThumbprintBasedRequest certRequest = new SignatureVerificationKeyCallback.ThumbprintBasedRequest(identifier);
        SignatureVerificationKeyCallback verifyKeyCallback = new SignatureVerificationKeyCallback(certRequest);
        if (!this.isDefaultHandler) {
            ProcessingContext.copy(verifyKeyCallback.getRuntimeProperties(), context);
        }
        Callback[] callbacks = new Callback[]{verifyKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"SignatureVerificationKeyCallback.ThumbprintBasedRequest"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        cert = certRequest.getX509Certificate();
        if (cert == null) {
            log.log(Level.SEVERE, "WSS0221.cannot.locate.cert", new Object[]{identifier});
            throw new XWSSecurityException("No Matching public key for " + Base64.encode(identifier) + " thumb print identifier found");
        }
        return cert;
    }

    public X509Certificate getCertificate(Map context, byte[] keyIdentifier) throws XWSSecurityException {
        X509Certificate cert = null;
        SignatureVerificationKeyCallback.X509SubjectKeyIdentifierBasedRequest certRequest = new SignatureVerificationKeyCallback.X509SubjectKeyIdentifierBasedRequest(keyIdentifier);
        SignatureVerificationKeyCallback verifyKeyCallback = new SignatureVerificationKeyCallback(certRequest);
        if (!this.isDefaultHandler) {
            ProcessingContext.copy(verifyKeyCallback.getRuntimeProperties(), context);
        }
        Callback[] callbacks = new Callback[]{verifyKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"SignatureVerificationKeyCallback.X509SubjectKeyIdentifierBasedRequest"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        cert = certRequest.getX509Certificate();
        if (cert == null) {
            log.log(Level.SEVERE, "WSS0221.cannot.locate.cert", new Object[]{keyIdentifier});
            throw new XWSSecurityException("No Matching public key for " + Base64.encode(keyIdentifier) + " subject key identifier found");
        }
        return cert;
    }

    public PublicKey getPublicKey(Map context, BigInteger serialNumber, String issuerName) throws XWSSecurityException {
        return this.getCertificate(context, serialNumber, issuerName).getPublicKey();
    }

    public X509Certificate getCertificate(Map context, BigInteger serialNumber, String issuerName) throws XWSSecurityException {
        X509Certificate cert = null;
        SignatureVerificationKeyCallback.X509IssuerSerialBasedRequest certRequest = new SignatureVerificationKeyCallback.X509IssuerSerialBasedRequest(issuerName, serialNumber);
        SignatureVerificationKeyCallback verifyKeyCallback = new SignatureVerificationKeyCallback(certRequest);
        if (!this.isDefaultHandler) {
            ProcessingContext.copy(verifyKeyCallback.getRuntimeProperties(), context);
        }
        Callback[] callbacks = new Callback[]{verifyKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"SignatureVerificationKeyCallback.X509IssuerSerialBasedRequest"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        cert = certRequest.getX509Certificate();
        if (cert == null) {
            log.log(Level.SEVERE, "WSS0221.cannot.locate.cert", new Object[]{serialNumber + ":" + issuerName});
            throw new XWSSecurityException("No Matching public key for serial number " + serialNumber + " and issuer name " + issuerName + " found");
        }
        return cert;
    }

    public boolean validateCertificate(X509Certificate cert) throws XWSSecurityException {
        CertificateValidationCallback certValCallback = new CertificateValidationCallback(cert);
        Callback[] callbacks = new Callback[]{certValCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0223.failed.certificate.validation");
            throw DefaultSecurityEnvironmentImpl.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "Certificate validation failed", e);
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Certificate Validation called on certificate " + cert.getSubjectDN());
        }
        return certValCallback.getResult();
    }

    public void updateOtherPartySubject(Subject subject, String username, String password) {
    }

    private void updateUsernameInSubject(final Subject subject, final String username, final String password) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String x500Name = "CN=" + username;
                X500Principal principal = new X500Principal(x500Name);
                subject.getPrincipals().add(principal);
                if (password != null) {
                    subject.getPrivateCredentials().add(password);
                }
                return null;
            }
        });
    }

    public void updateOtherPartySubject(final Subject subject, final X509Certificate cert) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                X500Principal principal = cert.getSubjectX500Principal();
                subject.getPrincipals().add(principal);
                subject.getPublicCredentials().add(cert);
                return null;
            }
        });
    }

    public void updateOtherPartySubject(final Subject subject, final Assertion assertion) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                subject.getPublicCredentials().add(assertion);
                return null;
            }
        });
    }

    public void updateOtherPartySubject(final Subject subject, final Key secretKey) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                subject.getPublicCredentials().add(secretKey);
                return null;
            }
        });
    }

    public void updateOtherPartySubject(final Subject subject, final String ek) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String encryptedKey = "EK" + ek;
                subject.getPublicCredentials().add(encryptedKey);
                return null;
            }
        });
    }

    public static Subject getSubject(final Map context) {
        Subject otherPartySubject = (Subject)context.get("javax.security.auth.Subject");
        if (otherPartySubject != null) {
            return otherPartySubject;
        }
        otherPartySubject = (Subject)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Subject otherPartySubj = new Subject();
                context.put("javax.security.auth.Subject", otherPartySubj);
                return otherPartySubj;
            }
        });
        return otherPartySubject;
    }

    public static Subject getSubject(final FilterProcessingContext context) {
        Subject otherPartySubject = (Subject)context.getExtraneousProperty("javax.security.auth.Subject");
        if (otherPartySubject != null) {
            return otherPartySubject;
        }
        otherPartySubject = (Subject)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Subject otherPartySubj = new Subject();
                context.setExtraneousProperty("javax.security.auth.Subject", otherPartySubj);
                return otherPartySubj;
            }
        });
        return otherPartySubject;
    }

    public PrivateKey getPrivateKey(Map context, X509Certificate cert) throws XWSSecurityException {
        PrivateKey privateKey = null;
        DecryptionKeyCallback.X509CertificateBasedRequest privateKeyRequest = new DecryptionKeyCallback.X509CertificateBasedRequest(cert);
        DecryptionKeyCallback decryptKeyCallback = new DecryptionKeyCallback(privateKeyRequest);
        if (!this.isDefaultHandler) {
            ProcessingContext.copy(decryptKeyCallback.getRuntimeProperties(), context);
        }
        Callback[] callbacks = new Callback[]{decryptKeyCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"DecryptionKeyCallback.X509CertificateBasedRequest"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        privateKey = privateKeyRequest.getPrivateKey();
        if (privateKey == null) {
            log.log(Level.SEVERE, "WSS0222.cannot.locate.privkey", new Object[]{"given certificate"});
            throw new XWSSecurityException("Could not retrieve private Key matching the given certificate");
        }
        return privateKey;
    }

    public PrivateKey getPrivateKey(Map context, PublicKey publicKey, boolean forSign) throws XWSSecurityException {
        if (forSign) {
            SignatureKeyCallback.PublicKeyBasedPrivKeyCertRequest req = new SignatureKeyCallback.PublicKeyBasedPrivKeyCertRequest(publicKey);
            SignatureKeyCallback skc = new SignatureKeyCallback(req);
            if (!this.isDefaultHandler) {
                ProcessingContext.copy(skc.getRuntimeProperties(), context);
            }
            Callback[] callbacks = new Callback[]{skc};
            try {
                this.callbackHandler.handle(callbacks);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"SignatureKeyCallback.PublicKeyBasedPrivKeyCertRequest"});
                log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
                throw new XWSSecurityException(e);
            }
            return req.getPrivateKey();
        }
        DecryptionKeyCallback.PublicKeyBasedPrivKeyRequest req = new DecryptionKeyCallback.PublicKeyBasedPrivKeyRequest(publicKey);
        DecryptionKeyCallback dkc = new DecryptionKeyCallback(req);
        if (!this.isDefaultHandler) {
            ProcessingContext.copy(dkc.getRuntimeProperties(), context);
        }
        Callback[] callbacks = new Callback[]{dkc};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"DecryptionKeyCallback.PublicKeyBasedPrivKeyRequest"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        return req.getPrivateKey();
    }

    public Subject getSubject() {
        log.log(Level.SEVERE, "WSS0224.unsupported.AssociatedSubject");
        throw new UnsupportedOperationException("This environment does not have an associated Subject");
    }

    public boolean authenticateUser(Map context, String username, String passwordDigest, String nonce, String created) throws XWSSecurityException {
        PasswordValidationCallback.DigestPasswordRequest request = new PasswordValidationCallback.DigestPasswordRequest(username, passwordDigest, nonce, created);
        PasswordValidationCallback passwordValidationCallback = new PasswordValidationCallback(request);
        if (!this.isDefaultHandler) {
            ProcessingContext.copy(passwordValidationCallback.getRuntimeProperties(), context);
        }
        Callback[] callbacks = new Callback[]{passwordValidationCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0225.error.PasswordValidationCallback", e);
            throw new XWSSecurityException(e);
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Username Authentication done for " + username);
        }
        return passwordValidationCallback.getResult();
    }

    public boolean authenticateUser(Map context, String username, String password) throws XWSSecurityException {
        boolean result;
        block5: {
            PasswordValidationCallback.PlainTextPasswordRequest request = new PasswordValidationCallback.PlainTextPasswordRequest(username, password);
            PasswordValidationCallback passwordValidationCallback = new PasswordValidationCallback(request);
            if (!this.isDefaultHandler) {
                ProcessingContext.copy(passwordValidationCallback.getRuntimeProperties(), context);
            }
            Callback[] callbacks = new Callback[]{passwordValidationCallback};
            result = false;
            try {
                this.callbackHandler.handle(callbacks);
                RealmAuthenticationAdapter adapter = passwordValidationCallback.getRealmAuthenticationAdapter();
                if (passwordValidationCallback.getValidator() != null) {
                    result = passwordValidationCallback.getResult();
                    this.updateUsernameInSubject(DefaultSecurityEnvironmentImpl.getSubject(context), username, password);
                    break block5;
                }
                if (adapter != null) {
                    result = adapter.authenticate(DefaultSecurityEnvironmentImpl.getSubject(context), username, password);
                    break block5;
                }
                log.log(Level.SEVERE, "WSS0295.password.val.not.config.username.val");
                throw new XWSSecurityException("Error: No PasswordValidator Configured for UsernameToken Validation");
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "WSS0225.error.PasswordValidationCallback", e);
                throw new XWSSecurityException(e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defaultValidateCreationTime(String creationTime, long maxClockSkew, long timestampFreshnessLimit) throws XWSSecurityException {
        Date created = null;
        try {
            SimpleDateFormat simpleDateFormat = this.calendarFormatter1;
            synchronized (simpleDateFormat) {
                created = this.calendarFormatter1.parse(creationTime);
            }
        }
        catch (ParseException e) {
            SimpleDateFormat simpleDateFormat = this.calendarFormatter2;
            synchronized (simpleDateFormat) {
                try {
                    created = this.calendarFormatter2.parse(creationTime);
                }
                catch (ParseException ex) {
                    log.log(Level.SEVERE, "WSS0226.failed.Validating.DefaultCreationTime", ex);
                    throw new XWSSecurityException(ex);
                }
            }
        }
        Date current = DefaultSecurityEnvironmentImpl.getFreshnessAndSkewAdjustedDate(maxClockSkew, timestampFreshnessLimit);
        if (created.before(current)) {
            log.log(Level.SEVERE, "WSS0227.invalid.older.CreationTime");
            throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "The creation time is older than  currenttime - timestamp-freshness-limit - max-clock-skew", null);
        }
        Date currentTime = DefaultSecurityEnvironmentImpl.getGMTDateWithSkewAdjusted(new GregorianCalendar(), maxClockSkew, true);
        if (currentTime.before(created)) {
            log.log(Level.SEVERE, "WSS0228.invalid.ahead.CreationTime");
            throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "The creation time is ahead of the current time.", null);
        }
    }

    public void validateCreationTime(Map context, String creationTime, long maxClockSkew, long timestampFreshnessLimit) throws XWSSecurityException {
        TimestampValidationCallback.UTCTimestampRequest request = new TimestampValidationCallback.UTCTimestampRequest(creationTime, null, maxClockSkew, timestampFreshnessLimit);
        request.isUsernameToken(true);
        TimestampValidationCallback timestampValidationCallback = new TimestampValidationCallback(request);
        if (!this.isDefaultHandler) {
            ProcessingContext.copy(timestampValidationCallback.getRuntimeProperties(), context);
        }
        Callback[] callbacks = new Callback[]{timestampValidationCallback};
        boolean unSupported = false;
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (UnsupportedCallbackException e) {
            unSupported = true;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0226.failed.Validating.DefaultCreationTime");
            throw new XWSSecurityException(e);
        }
        if (unSupported) {
            this.defaultValidateCreationTime(creationTime, maxClockSkew, timestampFreshnessLimit);
            return;
        }
        try {
            timestampValidationCallback.getResult();
        }
        catch (TimestampValidationCallback.TimestampValidationException e) {
            log.log(Level.SEVERE, "WSS0229.failed.Validating.TimeStamp", e);
            throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, e.getMessage(), e);
        }
    }

    public boolean validateSamlIssuer(String issuer) {
        log.log(Level.SEVERE, "WSS0230.unsupported.Validating.SAMLIssuer");
        throw new UnsupportedOperationException("SAML Issuer Validation not yet supported");
    }

    public boolean validateSamlUser(String user, String domain, String format) {
        log.log(Level.SEVERE, "WSS0231.unsupported.Validating.SAMLUser");
        throw new UnsupportedOperationException("SAML User Validation not yet supported");
    }

    public String getUsername(Map context) throws XWSSecurityException {
        UsernameCallback usernameCallback = new UsernameCallback();
        ProcessingContext.copy(usernameCallback.getRuntimeProperties(), context);
        Callback[] callbacks = new Callback[]{usernameCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0216.callbackhandler.handle.exception", new Object[]{"UsernameCallback"});
            log.log(Level.SEVERE, "WSS0217.callbackhandler.handle.exception.log", e);
            throw new XWSSecurityException(e);
        }
        return usernameCallback.getUsername();
    }

    public String getPassword(Map context) throws XWSSecurityException {
        PasswordCallback passwordCallback = new PasswordCallback();
        ProcessingContext.copy(passwordCallback.getRuntimeProperties(), context);
        Callback[] callbacks = new Callback[]{passwordCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0225.failed.PasswordValidationCallback", e);
            throw new XWSSecurityException(e.getMessage(), e);
        }
        return passwordCallback.getPassword();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defaultValidateExpirationTime(String expirationTime, long maxClockSkew, long timestampFreshnessLimit) throws XWSSecurityException {
        if (expirationTime != null) {
            Date expires = null;
            try {
                SimpleDateFormat simpleDateFormat = this.calendarFormatter1;
                synchronized (simpleDateFormat) {
                    expires = this.calendarFormatter1.parse(expirationTime);
                }
            }
            catch (ParseException pe) {
                SimpleDateFormat simpleDateFormat = this.calendarFormatter2;
                synchronized (simpleDateFormat) {
                    try {
                        expires = this.calendarFormatter2.parse(expirationTime);
                    }
                    catch (ParseException e) {
                        log.log(Level.SEVERE, "WSS0394.error.parsing.expirationtime");
                        throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, e.getMessage(), e);
                    }
                }
            }
            Date currentTime = DefaultSecurityEnvironmentImpl.getGMTDateWithSkewAdjusted(new GregorianCalendar(), maxClockSkew, false);
            if (expires.before(currentTime)) {
                log.log(Level.SEVERE, "WSS0393.current.ahead.of.expires");
                throw SOAPUtil.newSOAPFaultException(MessageConstants.WSU_MESSAGE_EXPIRED, "The current time is ahead of the expiration time in Timestamp", null);
            }
        }
    }

    public void validateTimestamp(Map context, Timestamp timestamp, long maxClockSkew, long freshnessLimit) throws XWSSecurityException {
        this.validateTimestamp(context, timestamp.getCreated(), timestamp.getExpires(), maxClockSkew, freshnessLimit);
    }

    public void validateTimestamp(Map context, String created, String expires, long maxClockSkew, long freshnessLimit) throws XWSSecurityException {
        if (this.expiresBeforeCreated(created, expires)) {
            XWSSecurityException xwsse = new XWSSecurityException("Message expired!");
            log.log(Level.SEVERE, "WSS0232.expired.Message");
            throw DefaultSecurityEnvironmentImpl.newSOAPFaultException(MessageConstants.WSU_MESSAGE_EXPIRED, "Message expired!", xwsse);
        }
        TimestampValidationCallback.UTCTimestampRequest request = new TimestampValidationCallback.UTCTimestampRequest(created, expires, maxClockSkew, freshnessLimit);
        TimestampValidationCallback timestampValidationCallback = new TimestampValidationCallback(request);
        if (!this.isDefaultHandler) {
            ProcessingContext.copy(timestampValidationCallback.getRuntimeProperties(), context);
        }
        Callback[] callbacks = new Callback[]{timestampValidationCallback};
        boolean unSupported = false;
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (UnsupportedCallbackException e) {
            unSupported = true;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0229.failed.Validating.TimeStamp", e);
            throw new XWSSecurityException(e);
        }
        if (unSupported) {
            this.defaultValidateCreationTime(created, maxClockSkew, freshnessLimit);
            this.defaultValidateExpirationTime(expires, maxClockSkew, freshnessLimit);
            return;
        }
        try {
            timestampValidationCallback.getResult();
        }
        catch (TimestampValidationCallback.TimestampValidationException e) {
            log.log(Level.SEVERE, "WSS0229.failed.Validating.TimeStamp", e);
            throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, e.getMessage(), e);
        }
    }

    public static WssSoapFaultException newSOAPFaultException(QName faultCode, String faultstring, Throwable th) {
        WssSoapFaultException sfe = new WssSoapFaultException(faultCode, faultstring, null, null);
        sfe.initCause(th);
        return sfe;
    }

    private static Date getGMTDateWithSkewAdjusted(Calendar c, long maxClockSkew, boolean addSkew) {
        long beforeTime = c.getTimeInMillis();
        long currentTime = beforeTime - offset;
        currentTime = addSkew ? (currentTime += maxClockSkew) : (currentTime -= maxClockSkew);
        c.setTimeInMillis(currentTime);
        return c.getTime();
    }

    private static Date getFreshnessAndSkewAdjustedDate(long maxClockSkew, long timestampFreshnessLimit) {
        GregorianCalendar c = new GregorianCalendar();
        long beforeTime = c.getTimeInMillis();
        long currentTime = beforeTime - offset;
        long adjustedTime = currentTime - maxClockSkew - timestampFreshnessLimit;
        c.setTimeInMillis(adjustedTime);
        return c.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean expiresBeforeCreated(String creationTime, String expirationTime) throws XWSSecurityException {
        Date created = null;
        Date expires = null;
        try {
            SimpleDateFormat simpleDateFormat = this.calendarFormatter1;
            synchronized (simpleDateFormat) {
                created = this.calendarFormatter1.parse(creationTime);
                if (expirationTime != null) {
                    expires = this.calendarFormatter1.parse(expirationTime);
                }
            }
        }
        catch (ParseException pe) {
            SimpleDateFormat simpleDateFormat = this.calendarFormatter2;
            synchronized (simpleDateFormat) {
                try {
                    created = this.calendarFormatter2.parse(creationTime);
                    if (expirationTime != null) {
                        expires = this.calendarFormatter2.parse(expirationTime);
                    }
                }
                catch (ParseException xpe) {
                    log.log(Level.SEVERE, "WSS0233.invalid.expire.before.creation", xpe);
                    throw new XWSSecurityException(xpe.getMessage());
                }
            }
        }
        if (expires != null && expires.equals(created)) {
            return true;
        }
        return expires != null && expires.before(created);
    }

    public boolean validateAndCacheNonce(String nonce, String created, long maxNonceAge) throws XWSSecurityException {
        if (this.nonceCache == null || this.nonceCache != null && this.nonceCache.wasCanceled()) {
            this.initNonceCache(maxNonceAge);
        }
        if (!this.nonceCache.isScheduled()) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "About to Store a new Nonce, but Reclaimer not Scheduled, so scheduling one" + this.nonceCache);
            }
            this.setNonceCacheCleanup();
        }
        return this.nonceCache.validateAndCacheNonce(nonce, created);
    }

    public void validateSAMLAssertion(Map context, Element assertion) throws XWSSecurityException {
        AuthenticationTokenPolicy authPolicy = new AuthenticationTokenPolicy();
        AuthenticationTokenPolicy.SAMLAssertionBinding samlPolicy = (AuthenticationTokenPolicy.SAMLAssertionBinding)authPolicy.newSAMLAssertionFeatureBinding();
        samlPolicy.setAssertion(assertion);
        DynamicPolicyCallback dynamicCallback = new DynamicPolicyCallback(samlPolicy, null);
        if (!this.isDefaultHandler) {
            ProcessingContext.copy(dynamicCallback.getRuntimeProperties(), context);
        } else {
            dynamicCallback.getRuntimeProperties().put("javax.security.auth.Subject", context.get("javax.security.auth.Subject"));
        }
        try {
            Callback[] callbacks = new Callback[]{dynamicCallback};
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0234.failed.Validate.SAMLAssertion", e);
            throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_FAILED_AUTHENTICATION, "Validation failed for SAML Assertion ", e);
        }
    }

    public Element locateSAMLAssertion(Map context, Element binding, String assertionId, Document ownerDoc) throws XWSSecurityException {
        AuthenticationTokenPolicy authPolicy = new AuthenticationTokenPolicy();
        AuthenticationTokenPolicy.SAMLAssertionBinding samlPolicy = (AuthenticationTokenPolicy.SAMLAssertionBinding)authPolicy.newSAMLAssertionFeatureBinding();
        samlPolicy.setAuthorityBinding(binding);
        samlPolicy.setAssertionId(assertionId);
        DynamicPolicyCallback dynamicCallback = new DynamicPolicyCallback(samlPolicy, null);
        if (!this.isDefaultHandler) {
            ProcessingContext.copy(dynamicCallback.getRuntimeProperties(), context);
        }
        try {
            Callback[] callbacks = new Callback[]{dynamicCallback};
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0235.failed.locate.SAMLAssertion", e);
            throw new XWSSecurityException(e);
        }
        Element assertion = samlPolicy.getAssertion();
        if (assertion == null) {
            log.log(Level.SEVERE, "WSS0236.null.SAMLAssertion");
            throw new XWSSecurityException("SAML Assertion not set into Policy by CallbackHandler");
        }
        return assertion;
    }

    public AuthenticationTokenPolicy.SAMLAssertionBinding populateSAMLPolicy(Map fpcontext, AuthenticationTokenPolicy.SAMLAssertionBinding policy, DynamicApplicationContext context) throws XWSSecurityException {
        DynamicPolicyCallback dynamicCallback = new DynamicPolicyCallback(policy, context);
        if (context != null) {
            ProcessingContext.copy(dynamicCallback.getRuntimeProperties(), fpcontext);
        }
        try {
            Callback[] callbacks = new Callback[]{dynamicCallback};
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0237.failed.DynamicPolicyCallback", e);
            throw new XWSSecurityException(e);
        }
        return (AuthenticationTokenPolicy.SAMLAssertionBinding)dynamicCallback.getSecurityPolicy();
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    private synchronized void initNonceCache(long maxNonceAge) {
        if (this.nonceCache == null) {
            this.nonceCache = maxNonceAge == 0L ? new NonceCache() : new NonceCache(maxNonceAge);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Creating NonceCache for first time....." + this.nonceCache);
            }
        } else if (this.nonceCache.wasCanceled()) {
            this.nonceCache = maxNonceAge == 0L ? new NonceCache() : new NonceCache(maxNonceAge);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Re-creating NonceCache because it was canceled....." + this.nonceCache);
            }
        }
    }

    private synchronized void setNonceCacheCleanup() {
        if (!this.nonceCache.isScheduled()) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Scheduling Nonce Reclaimer task...... for " + this + ":" + this.nonceCache);
            }
            nonceCleanupTimer.schedule((TimerTask)this.nonceCache, this.nonceCache.getMaxNonceAge(), this.nonceCache.getMaxNonceAge());
            this.nonceCache.scheduled(true);
        }
    }

    private void validateSamlVersion(Assertion assertion) {
        BigInteger major = assertion.getMajorVersion();
        BigInteger minor = assertion.getMinorVersion();
        if (major.intValue() != 1) {
            log.log(Level.SEVERE, "WSS0404.saml.invalid.version");
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "Major version is not 1 for SAML Assertion:" + assertion.getAssertionID(), new Exception("Major version is not 1 for SAML Assertion"));
        }
        if (minor.intValue() != 0 && minor.intValue() != 1) {
            log.log(Level.SEVERE, "WSS0404.saml.invalid.version");
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "Minor version is not 0/1 for SAML Assertion:" + assertion.getAssertionID(), new Exception("Minor version is not 0/1 for SAML Assertion"));
        }
    }

    private void validateIssuer(SecurableSoapMessage secMessage, Assertion assertion) {
    }

    private void validateSamlUser(SecurableSoapMessage secMessage, Assertion assertion) {
        Object user = null;
    }

    public void validateSAMLAssertion(Map context, XMLStreamReader assertion) throws XWSSecurityException {
        AuthenticationTokenPolicy authPolicy = new AuthenticationTokenPolicy();
        AuthenticationTokenPolicy.SAMLAssertionBinding samlPolicy = (AuthenticationTokenPolicy.SAMLAssertionBinding)authPolicy.newSAMLAssertionFeatureBinding();
        samlPolicy.setAssertion(assertion);
        DynamicPolicyCallback dynamicCallback = new DynamicPolicyCallback(samlPolicy, null);
        if (!this.isDefaultHandler) {
            ProcessingContext.copy(dynamicCallback.getRuntimeProperties(), context);
        } else {
            dynamicCallback.getRuntimeProperties().put("javax.security.auth.Subject", DefaultSecurityEnvironmentImpl.getSubject(context));
        }
        try {
            Callback[] callbacks = new Callback[]{dynamicCallback};
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0234.failed.Validate.SAMLAssertion", e);
            throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_FAILED_AUTHENTICATION, "Validation failed for SAML Assertion ", e);
        }
    }

    public void updateOtherPartySubject(final Subject subject, final XMLStreamReader assertion) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                subject.getPublicCredentials().add(assertion);
                return null;
            }
        });
    }

    public boolean isSelfCertificate(X509Certificate cert) {
        return this.selfCertificate != null && this.selfCertificate.equals(cert);
    }

    public void updateOtherPartySubject(Subject subject, Subject bootStrapSubject) {
        SecurityUtil.copySubject(subject, bootStrapSubject);
    }

    public KerberosContext doKerberosLogin() throws XWSSecurityException {
        String loginModule = this.configAssertions.getProperty("krb5.login.module");
        String servicePrincipal = this.configAssertions.getProperty("krb5.service.principal");
        if (loginModule == null || loginModule.equals("")) {
            throw new XWSSecurityException("Login Module for Kerberos login is not set or could not be obtained");
        }
        if (servicePrincipal == null || servicePrincipal.equals("")) {
            throw new XWSSecurityException("Kerberos Service Principal is not set or could not be obtained");
        }
        return new KerberosLogin().login(loginModule, servicePrincipal);
    }

    public KerberosContext doKerberosLogin(byte[] tokenValue) throws XWSSecurityException {
        String loginModule = this.configAssertions.getProperty("krb5.login.module");
        return new KerberosLogin().login(loginModule, tokenValue);
    }

    static {
        GregorianCalendar c = new GregorianCalendar();
        long calculatedOffset = c.get(15);
        if (((Calendar)c).getTimeZone().inDaylightTime(c.getTime())) {
            calculatedOffset += (long)((Calendar)c).getTimeZone().getDSTSavings();
        }
        offset = calculatedOffset;
        log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");
    }
}

