/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.policy.mls;

import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import java.text.SimpleDateFormat;

public class TimestampPolicy
extends WSSPolicy {
    private String creationTime = MessageConstants._EMPTY;
    private String expirationTime = MessageConstants._EMPTY;
    private long timeout = 0L;
    private long maxClockSkew = 0L;
    private long timestampFreshness = 0L;
    static SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    static SimpleDateFormat formatter1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'");

    public TimestampPolicy() {
        this.setPolicyIdentifier("TimestampPolicy");
    }

    public void setCreationTime(String creationTime) {
        this.creationTime = creationTime;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setMaxClockSkew(long maxClockSkew) {
        this.maxClockSkew = maxClockSkew;
    }

    public void setTimestampFreshness(long timestampFreshness) {
        this.timestampFreshness = timestampFreshness;
    }

    public String getCreationTime() {
        return this.creationTime;
    }

    public long getTimeout() {
        return this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExpirationTime() throws Exception {
        if (this.expirationTime.equals("") && this.timeout != 0L && !this.creationTime.equals("")) {
            try {
                SimpleDateFormat simpleDateFormat = formatter;
                synchronized (simpleDateFormat) {
                    this.expirationTime = new Long(formatter.parse(this.creationTime).getTime() + this.timeout).toString();
                }
            }
            catch (Exception e) {
                SimpleDateFormat simpleDateFormat = formatter1;
                synchronized (simpleDateFormat) {
                    this.expirationTime = new Long(formatter1.parse(this.creationTime).getTime() + this.timeout).toString();
                }
            }
        }
        return this.expirationTime;
    }

    public void setExpirationTime(String expirationTime) {
        this.expirationTime = expirationTime;
    }

    public long getMaxClockSkew() {
        return this.maxClockSkew;
    }

    public long getTimestampFreshness() {
        return this.timestampFreshness;
    }

    public boolean equals(WSSPolicy policy) {
        boolean assrt = false;
        try {
            TimestampPolicy tPolicy = (TimestampPolicy)policy;
            boolean b1 = this.creationTime.equals("") ? true : this.creationTime.equalsIgnoreCase(tPolicy.getCreationTime());
            boolean b2 = this.getExpirationTime().equals("") ? true : this.getExpirationTime().equalsIgnoreCase(tPolicy.getExpirationTime());
            assrt = b1 && b2;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return assrt;
    }

    public boolean equalsIgnoreTargets(WSSPolicy policy) {
        return this.equals(policy);
    }

    public Object clone() {
        TimestampPolicy tPolicy = new TimestampPolicy();
        try {
            tPolicy.setTimeout(this.timeout);
            tPolicy.setCreationTime(this.creationTime);
            tPolicy.setExpirationTime(this.expirationTime);
            tPolicy.setMaxClockSkew(this.maxClockSkew);
            tPolicy.setTimestampFreshness(this.timestampFreshness);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tPolicy;
    }

    public String getType() {
        return "TimestampPolicy";
    }
}

