/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.xwss;

import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.WSService;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.ClientPipeAssemblerContext;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.PipelineAssembler;
import com.sun.xml.ws.api.pipe.PipelineAssemblerFactory;
import com.sun.xml.ws.api.pipe.ServerPipeAssemblerContext;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.xwss.XWSSClientPipe;
import com.sun.xml.xwss.XWSSServerPipe;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;

public class XWSSPipelineAssemblerFactory
extends PipelineAssemblerFactory {
    private static final String SERVLET_CONTEXT_CLASSNAME = "javax.servlet.ServletContext";
    private BindingID bindingId;
    private static final String addrVersionClass = "com.sun.xml.ws.api.addressing.AddressingVersion";

    public PipelineAssembler doCreate(BindingID bindingID) {
        return new XWSSPipelineAssembler(bindingID);
    }

    private static class XWSSPipelineAssembler
    implements PipelineAssembler {
        private BindingID bindingId;

        public XWSSPipelineAssembler(BindingID bindingId) {
            this.bindingId = bindingId;
        }

        public Pipe createClient(ClientPipeAssemblerContext context) {
            Pipe p = context.createTransportPipe();
            if (XWSSPipelineAssembler.isSecurityConfigPresent(context)) {
                p = XWSSPipelineAssembler.initializeXWSSClientPipe(context.getWsdlModel(), context.getService(), context.getBinding(), p);
            }
            p = context.createClientMUPipe(p);
            p = context.createHandlerPipe(p);
            if (this.isAddressingEnabled(context.getWsdlModel(), context.getBinding())) {
                p = context.createWsaPipe(p);
            }
            return p;
        }

        public Pipe createServer(ServerPipeAssemblerContext context) {
            Pipe p = context.getTerminalPipe();
            p = context.createHandlerPipe(p);
            p = context.createServerMUPipe(p);
            p = context.createMonitoringPipe(p);
            if (this.isAddressingEnabled(context.getWsdlModel(), context.getEndpoint().getBinding())) {
                p = context.createWsaPipe(p);
            }
            if (XWSSPipelineAssembler.isSecurityConfigPresent(context)) {
                p = XWSSPipelineAssembler.initializeXWSSServerPipe(context.getEndpoint(), context.getWsdlModel(), p);
            }
            return p;
        }

        private boolean isAddressingEnabled(WSDLPort port, WSBinding binding) {
            Class<?> clazz = null;
            try {
                clazz = Thread.currentThread().getContextClassLoader().loadClass(XWSSPipelineAssemblerFactory.addrVersionClass);
            }
            catch (ClassNotFoundException ex) {
                return false;
            }
            if (clazz != null) {
                try {
                    Method meth = clazz.getMethod("isEnabled", WSBinding.class);
                    Object result = meth.invoke(null, binding);
                    if (result instanceof Boolean) {
                        boolean ret = (Boolean)result;
                        return ret;
                    }
                }
                catch (IllegalAccessException ex) {
                    throw new WebServiceException((Throwable)ex);
                }
                catch (IllegalArgumentException ex) {
                    throw new WebServiceException((Throwable)ex);
                }
                catch (InvocationTargetException ex) {
                    throw new WebServiceException((Throwable)ex);
                }
                catch (NoSuchMethodException ex) {
                    throw new WebServiceException((Throwable)ex);
                }
                catch (SecurityException ex) {
                    throw new WebServiceException((Throwable)ex);
                }
            }
            return false;
        }

        private static boolean isSecurityConfigPresent(ClientPipeAssemblerContext context) {
            return true;
        }

        private static boolean isSecurityConfigPresent(ServerPipeAssemblerContext context) {
            QName serviceQName = context.getEndpoint().getServiceName();
            String serviceLocalName = serviceQName.getLocalPart();
            Container container = context.getEndpoint().getContainer();
            Object ctxt = null;
            if (container != null) {
                try {
                    Class<?> contextClass = Class.forName(XWSSPipelineAssemblerFactory.SERVLET_CONTEXT_CLASSNAME);
                    ctxt = container.getSPI(contextClass);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            String serverName = "server";
            if (ctxt != null) {
                String serverConfig = "/WEB-INF/" + serverName + "_" + "security_config.xml";
                URL url = SecurityUtil.loadFromContext(serverConfig, ctxt);
                if (url == null) {
                    serverConfig = "/WEB-INF/" + serviceLocalName + "_" + "security_config.xml";
                    url = SecurityUtil.loadFromContext(serverConfig, ctxt);
                }
                if (url != null) {
                    return true;
                }
            } else {
                String serverConfig = "META-INF/" + serverName + "_" + "security_config.xml";
                URL url = SecurityUtil.loadFromClasspath(serverConfig);
                if (url == null) {
                    serverConfig = "META-INF/" + serviceLocalName + "_" + "security_config.xml";
                    url = SecurityUtil.loadFromClasspath(serverConfig);
                }
                if (url != null) {
                    return true;
                }
            }
            return false;
        }

        private static Pipe initializeXWSSClientPipe(WSDLPort prt, WSService svc, WSBinding bnd, Pipe nextP) {
            XWSSClientPipe ret = new XWSSClientPipe(prt, svc, bnd, nextP);
            return ret;
        }

        private static Pipe initializeXWSSServerPipe(WSEndpoint epoint, WSDLPort prt, Pipe nextP) {
            XWSSServerPipe ret = new XWSSServerPipe(epoint, prt, nextP);
            return ret;
        }
    }
}

