/*
 * Decompiled with CFR 0.152.
 */
package com.sunmilib.Interceptor;

import com.sunmilib.listener.ProgressChangedCallback;
import com.sunmilib.util.LogSunmi;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;

public class SunmiDownloadResponseBody
extends ResponseBody {
    private final String TAG = "DownloadResponseBody";
    protected ResponseBody responseBody;
    protected ProgressChangedCallback mSunmiDownloadProgressListener;
    protected BufferedSource bufferedSource;
    private long mStart = 0L;

    public SunmiDownloadResponseBody(ResponseBody responseBody, ProgressChangedCallback listener, long start) {
        this.responseBody = responseBody;
        this.mSunmiDownloadProgressListener = listener;
        this.mStart = start;
        LogSunmi.d("DownloadResponseBody", "SunmiDownloadResponseBody: ----------->" + this.mStart);
    }

    public MediaType contentType() {
        return this.responseBody.contentType();
    }

    public long contentLength() {
        return this.responseBody.contentLength();
    }

    public BufferedSource source() {
        if (this.bufferedSource == null) {
            this.bufferedSource = Okio.buffer((Source)this.source((Source)this.responseBody.source()));
        }
        return this.bufferedSource;
    }

    private Source source(final Source source) {
        return new ForwardingSource(source){
            long totalBytesRead;
            {
                super(arg0);
                this.totalBytesRead = SunmiDownloadResponseBody.this.mStart;
            }

            public long read(Buffer sink, long byteCount) throws IOException {
                long bytesRead = super.read(sink, byteCount);
                this.totalBytesRead += bytesRead != -1L ? bytesRead : 0L;
                if (bytesRead == -1L) {
                    LogSunmi.d("DownloadResponseBody", "bytesRead: ------->" + bytesRead + "  " + source.getClass().getSimpleName());
                    LogSunmi.d("DownloadResponseBody", "bytesRead: ------->" + this.totalBytesRead + "  " + (SunmiDownloadResponseBody.this.mStart + SunmiDownloadResponseBody.this.responseBody.contentLength()));
                }
                if (null != SunmiDownloadResponseBody.this.mSunmiDownloadProgressListener) {
                    SunmiDownloadResponseBody.this.mSunmiDownloadProgressListener.onProgressChanged(this.totalBytesRead, SunmiDownloadResponseBody.this.mStart + SunmiDownloadResponseBody.this.responseBody.contentLength(), bytesRead == -1L);
                }
                return bytesRead;
            }
        };
    }
}

