/*
 * Decompiled with CFR 0.152.
 */
package com.sunmilib.Interceptor;

import com.sunmilib.listener.ProgressChangedCallback;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;

public class SunmiUploadRequestBody
extends RequestBody {
    private RequestBody mRequestBody;
    private ProgressChangedCallback mSunmiUploadProgressListener;
    private CountingSink mCountingSink;

    public SunmiUploadRequestBody(RequestBody requestBody, ProgressChangedCallback listener) {
        this.mRequestBody = requestBody;
        this.mSunmiUploadProgressListener = listener;
    }

    public MediaType contentType() {
        return this.mRequestBody.contentType();
    }

    public long contentLength() throws IOException {
        try {
            return this.mRequestBody.contentLength();
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public void writeTo(BufferedSink sink) throws IOException {
        this.mCountingSink = new CountingSink((Sink)sink);
        BufferedSink bufferedSink = Okio.buffer((Sink)this.mCountingSink);
        this.mRequestBody.writeTo(bufferedSink);
        bufferedSink.flush();
    }

    class CountingSink
    extends ForwardingSink {
        private long bytesWritten;

        public CountingSink(Sink delegate) {
            super(delegate);
            this.bytesWritten = 0L;
        }

        public void write(Buffer source, long byteCount) throws IOException {
            super.write(source, byteCount);
            this.bytesWritten += byteCount;
            SunmiUploadRequestBody.this.mSunmiUploadProgressListener.onProgressChanged(this.bytesWritten, SunmiUploadRequestBody.this.contentLength(), this.bytesWritten == SunmiUploadRequestBody.this.contentLength());
        }
    }
}

