/*
 * Decompiled with CFR 0.152.
 */
package com.sunmilib.certificatetransparency;

import com.appmattus.certificatetransparency.BasicAndroidCTLogger;
import com.appmattus.certificatetransparency.CTInterceptorBuilder;
import com.appmattus.certificatetransparency.CTLogger;
import com.appmattus.certificatetransparency.cache.AndroidDiskCache;
import com.appmattus.certificatetransparency.cache.DiskCache;
import com.sunmilib.certificatetransparency.CTInterceptorFactory;
import com.sunmilib.service.HttpConfig;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Interceptor;

public class DefaultCTInterceptorFactory
implements CTInterceptorFactory {
    private boolean failOnError = true;
    private List<String> hosts = new ArrayList<String>();

    private DefaultCTInterceptorFactory() {
    }

    private DefaultCTInterceptorFactory(Builder builder) {
        this.failOnError = builder.failOnError;
        this.hosts = builder.hosts;
    }

    @Override
    public Interceptor getCTInterceptor() {
        CTInterceptorBuilder builder = new CTInterceptorBuilder().setFailOnError(this.failOnError).setLogger((CTLogger)new BasicAndroidCTLogger(HttpConfig.getInstance().isDebug())).setDiskCache((DiskCache)new AndroidDiskCache(HttpConfig.getInstance().getAppContext()));
        if (this.hosts != null && !this.hosts.isEmpty()) {
            for (String host : this.hosts) {
                builder.includeHost(host);
            }
        }
        return builder.build();
    }

    public static class Builder {
        boolean failOnError = true;
        List<String> hosts = new ArrayList<String>();

        public Builder failOnError(boolean failOnError) {
            this.failOnError = failOnError;
            return this;
        }

        public Builder includeHost(String host) {
            this.hosts.add(host);
            return this;
        }

        public CTInterceptorFactory build() {
            return new DefaultCTInterceptorFactory(this);
        }
    }
}

