/*
 * Decompiled with CFR 0.152.
 */
package com.sunmilib.http;

import io.reactivex.annotations.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;

public class PartUploadRequestBody
extends RequestBody {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private MediaType contentType;
    private File uploadFile;
    private long fileLength;
    private long contentLength;
    private long startBytes;
    private long endBytes;
    private int mEachBufferSize = 4096;
    private long uploadBytes;
    private int readBytes = 0;

    public PartUploadRequestBody(@Nullable MediaType contentType, File file, long startBytes, long endBytes) {
        this.contentType = contentType;
        if (null == file || !file.exists()) {
            return;
        }
        this.uploadFile = file;
        this.fileLength = file.length();
        this.startBytes = startBytes;
        this.endBytes = endBytes;
        if (startBytes < 0L) {
            startBytes = 0L;
        }
        this.contentLength = startBytes >= this.fileLength ? 0L : (endBytes <= 0L || endBytes >= this.fileLength ? file.length() - startBytes : endBytes - startBytes);
        if (this.contentLength < (long)this.mEachBufferSize) {
            this.mEachBufferSize = (int)this.contentLength;
        }
    }

    public MediaType contentType() {
        return this.contentType;
    }

    public long contentLength() {
        return this.contentLength;
    }

    public void writeTo(BufferedSink sink) throws IOException {
        if (this.contentLength <= 0L) {
            throw new IOException("upload byte length error!");
        }
        byte[] buffer = new byte[this.mEachBufferSize];
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.uploadFile, "r");
        randomAccessFile.seek(this.startBytes);
        while ((this.readBytes = randomAccessFile.read(buffer, 0, this.mEachBufferSize)) != -1 && this.uploadBytes < this.contentLength) {
            sink.write(buffer, 0, this.readBytes);
            this.uploadBytes += (long)this.readBytes;
            if (this.contentLength - (long)this.readBytes >= (long)this.mEachBufferSize) continue;
            this.mEachBufferSize = (int)(this.contentLength - (long)this.readBytes);
        }
        randomAccessFile.close();
    }
}

