/*
 * Decompiled with CFR 0.152.
 */
package com.sunmilib.http;

import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.sunmilib.Interceptor.SunmiUploadProgressInterceptor;
import com.sunmilib.http.BaseResponse;
import com.sunmilib.http.GsonBean;
import com.sunmilib.http.Method;
import com.sunmilib.http.ResponseParser;
import com.sunmilib.listener.HttpCallback;
import com.sunmilib.listener.OriginResponseCallback;
import com.sunmilib.listener.ProgressChangedCallback;
import com.sunmilib.listener.ResponseCallback;
import com.sunmilib.listener.UploadListener;
import com.sunmilib.observer.ResponseSingleObserver;
import com.sunmilib.observer.UpLoadSingleObserver;
import com.sunmilib.retrofit.RetrofitFactory;
import com.sunmilib.service.AbsBaseHelper;
import com.sunmilib.service.HttpConfig;
import com.sunmilib.service.HttpService;
import com.sunmilib.service.HttpServiceHelperFactory;
import com.sunmilib.util.LogSunmi;
import com.sunmilib.util.ParseErrorCodeUtil;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.reactivestreams.Publisher;
import retrofit2.Call;

public final class Request {
    private static final String TAG = "Request";
    private Object mParam;
    private String mUrl;
    private Disposable mDisposable;
    private UploadListener mUploadListener;
    private HttpConfig mConfig;
    private HttpService mHttpService;
    private HttpCallback<? extends ResponseCallback.RESPONSE> mHttpCallback;
    private Method method;
    private Type responseType;
    private Function<? super Flowable<Throwable>, ? extends Publisher<?>> mRetryHandler;

    private Request(String url, Method method, Object param, HttpCallback<? extends ResponseCallback.RESPONSE> mHttpCallback, UploadListener uploadListener, HttpConfig config, Function<? super Flowable<Throwable>, ? extends Publisher<?>> retryHandler) {
        this.mUrl = url;
        this.mParam = param;
        this.method = method;
        this.mUploadListener = uploadListener;
        config = config == null ? HttpConfig.getInstance() : config;
        this.mConfig = config.newBuilder().build();
        this.mHttpCallback = mHttpCallback;
        this.mRetryHandler = retryHandler;
        this.parseCallbackResponseType();
    }

    private void parseCallbackResponseType() {
        if (this.mHttpCallback == null) {
            return;
        }
        Class<?> cls = this.mHttpCallback.getClass();
        Type[] types = cls.getGenericInterfaces();
        this.responseType = ((ParameterizedType)types[0]).getActualTypeArguments()[0];
    }

    public void asyncHttpByCallback() {
        this.asyncSingle().subscribeOn(Schedulers.io()).observeOn(Schedulers.io()).map(new BasicResponseMapFunction(this.responseType)).observeOn(AndroidSchedulers.mainThread()).subscribe((SingleObserver)new ResponseSingleObserver(this.mHttpCallback){

            @Override
            public void onSubscribe(Disposable d) {
                Request.this.mDisposable = d;
            }
        });
    }

    public void asyncHttpByCallback(final OriginResponseCallback callback) {
        if (callback == null) {
            LogSunmi.e("SunmiHttp", "callback is null");
            return;
        }
        this.asyncSingle().subscribeOn(Schedulers.io()).observeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((SingleObserver)new SingleObserver<String>(){

            public void onSubscribe(Disposable d) {
                Request.this.mDisposable = d;
            }

            public void onSuccess(String s) {
                callback.onSuccess(s);
            }

            public void onError(Throwable e) {
                callback.onFail(e);
            }
        });
    }

    public <T> Single<BaseResponse<T>> asynHttpToSingle(Class<?> clz) {
        return this.asyncSingle().map(new BasicResponseMapFunction(clz));
    }

    public <T> BaseResponse<T> synExecute(Class clz) throws Exception {
        try {
            String body = ((ResponseBody)this.synSingle().execute().body()).string();
            if (TextUtils.isEmpty((CharSequence)body)) {
                return new BaseResponse(1007, "respone body is null!", null);
            }
            return new BasicResponseMapFunction(true, clz).apply(body);
        }
        catch (Exception e) {
            return new BaseResponse(ParseErrorCodeUtil.parseErrorCode(e), e.getMessage(), null);
        }
    }

    public <T> BaseResponse<T> synExecute(Type type) throws Exception {
        try {
            String body = ((ResponseBody)this.synSingle().execute().body()).string();
            if (TextUtils.isEmpty((CharSequence)body)) {
                return new BaseResponse(1007, "respone body is null!", null);
            }
            return new BasicResponseMapFunction(true, type).apply(body);
        }
        catch (Exception e) {
            return new BaseResponse(ParseErrorCodeUtil.parseErrorCode(e), e.getMessage(), null);
        }
    }

    private synchronized AbsBaseHelper preConfigHttpService(boolean forceCloseLogInterceptor, Interceptor ... interceptors) throws Exception {
        AbsBaseHelper helper;
        HttpConfig.Builder builder = this.mConfig.newBuilder();
        if (interceptors.length > 0) {
            for (int i = 0; i < interceptors.length; ++i) {
                builder.interceptor(interceptors[i]);
            }
        }
        if (forceCloseLogInterceptor) {
            builder.log(false);
        }
        if ((helper = HttpServiceHelperFactory.get(builder)) == null) {
            throw new Exception("init absBaseHelper fail");
        }
        helper.initParam(this.mParam, builder);
        if (null != helper.headInterceptor()) {
            builder.interceptor(helper.headInterceptor());
        }
        HttpConfig httpConfig = builder.build();
        this.mHttpService = RetrofitFactory.getInstance().create(HttpService.class, this.mUrl, httpConfig);
        if (!forceCloseLogInterceptor && httpConfig.isShowLogInterceptor()) {
            LogSunmi.d("SunmiHttp", "request param " + (this.mParam != null ? JSON.toJSONString((Object)this.mParam) : null));
            LogSunmi.d("SunmiHttp", " request map " + helper.getFieldMap().toString());
        }
        return helper;
    }

    private Single<String> asyncSingle() {
        return Single.create(emitter -> {
            AbsBaseHelper helper = this.preConfigHttpService(false, new Interceptor[0]);
            emitter.onSuccess((Object)helper);
        }).flatMap(absBaseHelper -> {
            if (this.method == Method.GET) {
                return this.mHttpService.getRequest(this.mUrl, absBaseHelper.getFieldMap());
            }
            if (this.method == Method.PUT) {
                return this.mHttpService.putRequest(this.mUrl, absBaseHelper.getFieldMap());
            }
            if (this.method == Method.DELETE) {
                return this.mHttpService.deleteRequest(this.mUrl, absBaseHelper.getFieldMap());
            }
            if (this.mParam instanceof GsonBean) {
                RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)absBaseHelper.getFieldMap().get("params"));
                return this.mHttpService.postRequest(this.mUrl, body);
            }
            return this.mHttpService.postRequest(this.mUrl, absBaseHelper.getFieldMap());
        });
    }

    private Call<ResponseBody> synSingle() throws Exception {
        AbsBaseHelper helper = this.preConfigHttpService(false, new Interceptor[0]);
        if (this.method == Method.GET) {
            return this.mHttpService.synGetHttp(this.mUrl, helper.getFieldMap());
        }
        if (this.method == Method.PUT) {
            return this.mHttpService.synPutHttp(this.mUrl, helper.getFieldMap());
        }
        if (this.method == Method.DELETE) {
            return this.mHttpService.synDeleteHttp(this.mUrl, helper.getFieldMap());
        }
        if (this.mParam instanceof GsonBean) {
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)helper.getFieldMap().get("params"));
            return this.mHttpService.synPostHttp(this.mUrl, body);
        }
        return this.mHttpService.synPostHttp(this.mUrl, helper.getFieldMap());
    }

    public void uploadFile(Class<?> clz, String ... files) {
        this.uploadFile(AndroidSchedulers.mainThread(), clz, files);
    }

    public <T> BaseResponse<T> synuploadFile(Class<?> clz, String ... files) {
        AbsBaseHelper helper;
        ArrayList<String> list = new ArrayList<String>();
        for (String f : files) {
            list.add(f);
        }
        ArrayList<Interceptor> interceptorList = new ArrayList<Interceptor>(1);
        if (null != this.mUploadListener) {
            interceptorList.add(this.uploadInterceptor());
        }
        Interceptor[] interceptors = new Interceptor[interceptorList.size()];
        interceptors = interceptorList.toArray(interceptors);
        try {
            helper = this.preConfigHttpService(true, interceptors);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new BaseResponse(10006, e.getMessage(), null);
        }
        try {
            String body = ((ResponseBody)this.mHttpService.synuploadFile(this.mUrl, helper.getRequestBody(list, "")).execute().body()).string();
            if (TextUtils.isEmpty((CharSequence)body)) {
                return new BaseResponse(1007, "respone body is null!", null);
            }
            return new BasicResponseMapFunction(false, clz).apply(body);
        }
        catch (Exception e) {
            return new BaseResponse(ParseErrorCodeUtil.parseErrorCode(e), e.getMessage(), null);
        }
    }

    public void uploadFile(Scheduler observeScheduler, Class<?> clz, final String ... files) {
        AbsBaseHelper helper;
        ArrayList<String> list = new ArrayList<String>();
        for (String f : files) {
            list.add(f);
        }
        ArrayList<Interceptor> interceptorList = new ArrayList<Interceptor>(1);
        if (null != this.mUploadListener) {
            interceptorList.add(this.uploadInterceptor());
        }
        Interceptor[] interceptors = new Interceptor[interceptorList.size()];
        interceptors = interceptorList.toArray(interceptors);
        try {
            helper = this.preConfigHttpService(true, interceptors);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (null != this.mUploadListener) {
                this.mUploadListener.onError(this.mUrl, 10006, e.getMessage());
            }
            return;
        }
        Single single = this.mHttpService.uploadFile(this.mUrl, helper.getRequestBody(list, "")).subscribeOn(Schedulers.io()).observeOn(Schedulers.io()).map(new BasicResponseMapFunction(clz)).observeOn(observeScheduler);
        if (this.mRetryHandler != null) {
            single.retryWhen(this.mRetryHandler);
        }
        single.subscribe((SingleObserver)new UpLoadSingleObserver(this.mUrl, this.mUploadListener){

            @Override
            public void onSubscribe(Disposable d) {
                Request.this.mDisposable = d;
                if (null != Request.this.mUploadListener) {
                    Request.this.mUploadListener.start(files[0]);
                }
            }
        });
    }

    public void uploadFile(Scheduler observeScheduler, Class<?> clz, final String file, long startUploadByte, long endUploadByte) {
        AbsBaseHelper helper;
        ArrayList<Interceptor> interceptorList = new ArrayList<Interceptor>(1);
        if (null != this.mUploadListener) {
            interceptorList.add(this.uploadInterceptor());
        }
        Interceptor[] interceptors = new Interceptor[interceptorList.size()];
        interceptors = interceptorList.toArray(interceptors);
        try {
            helper = this.preConfigHttpService(true, interceptors);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (null != this.mUploadListener) {
                this.mUploadListener.onError(this.mUrl, 10006, e.getMessage());
            }
            return;
        }
        this.mHttpService.uploadFile(this.mUrl, helper.getRequestBody(file, startUploadByte, endUploadByte)).subscribeOn(Schedulers.io()).observeOn(Schedulers.io()).map(new BasicResponseMapFunction(clz)).observeOn(observeScheduler).subscribe((SingleObserver)new UpLoadSingleObserver(this.mUrl, this.mUploadListener){

            @Override
            public void onSubscribe(Disposable d) {
                Request.this.mDisposable = d;
                if (null != Request.this.mUploadListener) {
                    Request.this.mUploadListener.start(file);
                }
            }
        });
    }

    private Interceptor uploadInterceptor() {
        return new SunmiUploadProgressInterceptor(new ProgressChangedCallback(){

            @Override
            public void onProgressChanged(long bytesWritten, long contentLength, boolean isComplete) {
                Observable.just((Object)1).observeOn(AndroidSchedulers.mainThread()).subscribe(integer -> {
                    if (Request.this.mUploadListener != null) {
                        Request.this.mUploadListener.onProgressChanged(bytesWritten, contentLength, isComplete);
                    }
                });
            }
        });
    }

    public void cancel() {
        if (null != this.mDisposable && !this.mDisposable.isDisposed()) {
            LogSunmi.d(TAG, "pause: ------------->");
            this.mDisposable.dispose();
            if (null != this.mUploadListener) {
                this.mUploadListener.cancel(this.mUrl);
            }
        }
    }

    public Disposable getDisposable() {
        return this.mDisposable;
    }

    private static final class BasicResponseMapFunction<T>
    implements Function<String, BaseResponse<T>> {
        private Type responseType;
        private boolean isSync = false;

        BasicResponseMapFunction(Type responseType) {
            this.responseType = responseType;
        }

        BasicResponseMapFunction(boolean isSync, Type responseType) {
            this.responseType = responseType;
            this.isSync = isSync;
        }

        public BaseResponse apply(String s) throws Exception {
            return ResponseParser.parseToBaseResponse(this.isSync, s, this.responseType);
        }
    }

    public static final class Build {
        private UploadListener mUploadListener;
        private HttpCallback<? extends ResponseCallback.RESPONSE> mHttpCallback;
        private Object mParam = null;
        private String mUrl = "";
        private HttpConfig mHttpConfig;
        private Method method = Method.POST;
        private Function<? super Flowable<Throwable>, ? extends Publisher<?>> mRetryHandler;

        Build() {
        }

        public Build httpConfig(HttpConfig config) {
            this.mHttpConfig = config;
            return this;
        }

        public Build uploadListener(UploadListener uploadListener) {
            this.mUploadListener = uploadListener;
            return this;
        }

        public Build httpCallback(HttpCallback<? extends ResponseCallback.RESPONSE> httpCallback) {
            this.mHttpCallback = httpCallback;
            return this;
        }

        public Build params(Object param) {
            this.mParam = param;
            return this;
        }

        public Build url(String url) {
            this.mUrl = url;
            return this;
        }

        public Build get() {
            this.method = Method.GET;
            return this;
        }

        public Build put() {
            this.method = Method.PUT;
            return this;
        }

        public Build delete() {
            this.method = Method.DELETE;
            return this;
        }

        public Build retryHandler(Function<? super Flowable<Throwable>, ? extends Publisher<?>> retryHandler) {
            this.mRetryHandler = retryHandler;
            return this;
        }

        public Request build() {
            if (TextUtils.isEmpty((CharSequence)this.mUrl)) {
                throw new IllegalStateException("url required.");
            }
            return new Request(this.mUrl, this.method, this.mParam, this.mHttpCallback, this.mUploadListener, this.mHttpConfig, this.mRetryHandler);
        }
    }
}

