/*
 * Decompiled with CFR 0.152.
 */
package com.sunmilib.http;

import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.sunmilib.exception.DataParseException;
import com.sunmilib.http.BaseResponse;
import com.sunmilib.listener.ResponseCallback;
import com.sunmilib.test.MockTestHttpResponse;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.json.JSONObject;

class ResponseParser {
    private static final String NULL = "null";
    private static final String STRING_ARRAY = "[]";
    private static final String STRING_OBJECT = "{}";

    ResponseParser() {
    }

    private static <T> T parseArrayResponse(ParameterizedType parameterizedType, String originResponseData) throws Exception {
        List resultList;
        Type actualTypeComponentType = parameterizedType.getActualTypeArguments()[0];
        if (!(actualTypeComponentType instanceof Class)) {
            throw new RuntimeException("nested too deep");
        }
        if (actualTypeComponentType == Object.class) {
            throw new RuntimeException("need a clear type");
        }
        if (actualTypeComponentType == MockTestHttpResponse.class) {
            originResponseData = MockTestHttpResponse.mockObjectJsonArrayResponse();
        }
        Class userComponentClass = (Class)actualTypeComponentType;
        try {
            resultList = JSON.parseArray((String)originResponseData, (Class)userComponentClass);
        }
        catch (Throwable t) {
            throw new DataParseException("ResponseMapFunction2 exception ;type= ResponseCallback.ArrayResponse<" + userComponentClass.getSimpleName() + "> ;originData =" + originResponseData);
        }
        int size = resultList.size();
        Object responseArray = Array.newInstance(userComponentClass, size);
        for (int index = 0; index < size; ++index) {
            Array.set(responseArray, index, resultList.get(index));
        }
        return (T)new ResponseCallback.ArrayResponse(responseArray);
    }

    private static <T> T parseObject(String json, Type responseType) throws Exception {
        if (TextUtils.isEmpty((CharSequence)json) || NULL.equals(json) || STRING_ARRAY.equals(json) || STRING_OBJECT.equals(json)) {
            return null;
        }
        if (responseType == null || responseType == ResponseCallback.StringResponse.class) {
            ResponseCallback.StringResponse response = new ResponseCallback.StringResponse();
            response.response = json;
            return (T)response;
        }
        if (responseType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)responseType;
            Type rawType = parameterizedType.getRawType();
            if (rawType == ResponseCallback.ArrayResponse.class) {
                return ResponseParser.parseArrayResponse(parameterizedType, json);
            }
            throw new RuntimeException("Generics are not supported");
        }
        try {
            if (json.startsWith("[") && json.endsWith("]")) {
                return (T)JSON.parseArray((String)json, (Class)((Class)responseType));
            }
            if (responseType == String.class) {
                return (T)json;
            }
            return (T)JSON.parseObject((String)json, (Type)responseType, (Feature[])new Feature[0]);
        }
        catch (Throwable t) {
            throw new DataParseException("ResponseMapFunction2 exception ;type=" + responseType.getClass().getSimpleName() + ";source=" + json);
        }
    }

    public static ResponseBean parseToResponseBean(boolean isSync, String originResponse) throws Exception {
        ResponseBean response = new ResponseBean();
        JSONObject jsonObject = new JSONObject(originResponse);
        response.code = jsonObject.getInt("code");
        response.msg = jsonObject.getString("msg");
        response.data = jsonObject.opt("data");
        if (null == response) {
            throw new DataParseException("BasicResponseMapFunction exception ;source= " + originResponse);
        }
        return response;
    }

    public static BaseResponse parseToBaseResponse(boolean isSync, String originResponse, Type responseType) throws Exception {
        ResponseBean response = ResponseParser.parseToResponseBean(isSync, originResponse);
        Object obj = response.data == null ? null : ResponseParser.parseObject(response.data.toString(), responseType);
        return new BaseResponse(response.code, response.msg, obj);
    }

    static final class ResponseBean {
        public int code;
        public String msg = "";
        public Object data = "";

        private ResponseBean() {
        }
    }
}

