/*
 * Decompiled with CFR 0.152.
 */
package com.sunmilib.manager;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.alibaba.fastjson.JSON;
import com.sunmilib.Interceptor.SunmiProgressDownloadInterceptor;
import com.sunmilib.bean.DownInfo;
import com.sunmilib.exception.IOException416;
import com.sunmilib.listener.DownLoadListener;
import com.sunmilib.listener.FileListener;
import com.sunmilib.listener.ProgressChangedCallback;
import com.sunmilib.retrofit.RetrofitFactory;
import com.sunmilib.service.AbsBaseHelper;
import com.sunmilib.service.HttpConfig;
import com.sunmilib.service.HttpService;
import com.sunmilib.service.HttpServiceHelperFactory;
import com.sunmilib.util.FileUtils;
import com.sunmilib.util.LogSunmi;
import com.sunmilib.util.ParseErrorCodeUtil;
import io.reactivex.Observable;
import io.reactivex.SingleObserver;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.lang.ref.WeakReference;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class DownLoadManager {
    private final String TAG = "DownLoadManagerNew";
    private String url;
    private String localPath;
    private long sectionLength;
    private DownInfo mDownInfo;
    private Object mParam;
    private String md5;
    private List<String> md5s;
    private MessageDigest messageDigest;
    private int position;
    private long start = 0L;
    private boolean isSection = false;
    private long update_bytes;
    private int md5retryCount = 0;
    private int retryCount = 0;
    private DownLoadListener mDownLoadListener;
    private Disposable mDisposable;
    private HttpConfig mHttpConfig;
    private HttpService mHttpService;
    private MyHandler myHandler;
    int tempProgress = 0;

    public DownLoadManager(DownInfo downInfo, Object param, DownLoadListener downLoadListener) {
        this.mDownInfo = downInfo;
        this.url = downInfo.getUrl();
        this.localPath = downInfo.getLocalPath();
        this.mParam = param;
        this.md5 = downInfo.getMd5();
        if (downInfo.getMd5s() != null) {
            this.md5s = Arrays.asList(downInfo.getMd5s());
        }
        this.sectionLength = downInfo.getSectionLength();
        this.mDownLoadListener = downLoadListener;
        this.mHttpConfig = HttpConfig.getInstance();
        boolean bl = this.isSection = this.sectionLength != -1L && this.sectionLength != 0L && this.md5s != null && this.md5s.size() != 0;
        if (this.isSection) {
            try {
                this.messageDigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        this.myHandler = new MyHandler(this);
    }

    public DownLoadManager(DownInfo downInfo, Object param, DownLoadListener downLoadListener, HttpConfig httpConfig) {
        this.mDownInfo = downInfo;
        this.url = downInfo.getUrl();
        this.localPath = downInfo.getLocalPath();
        this.mParam = param;
        this.md5 = downInfo.getMd5();
        if (downInfo.getMd5s() != null) {
            this.md5s = Arrays.asList(downInfo.getMd5s());
        }
        this.sectionLength = downInfo.getSectionLength();
        this.mDownLoadListener = downLoadListener;
        this.mHttpConfig = httpConfig;
        boolean bl = this.isSection = this.sectionLength != -1L && this.sectionLength != 0L && this.md5s != null && this.md5s.size() != 0;
        if (this.isSection) {
            try {
                this.messageDigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        this.myHandler = new MyHandler(this);
    }

    public DownLoadListener getDownLoadListener() {
        return this.mDownLoadListener;
    }

    public void setDownLoadListener(DownLoadListener downLoadListener) {
        this.mDownLoadListener = downLoadListener;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void downloadFile() {
        File file;
        block9: {
            block11: {
                block12: {
                    block10: {
                        file = new File(this.localPath);
                        if (file.exists()) break block10;
                        file.getParentFile().mkdirs();
                        break block9;
                    }
                    if (!this.isSection) break block11;
                    if (this.messageDigest == null) break block12;
                    this.position = FileUtils.checkSliceMD5(this.messageDigest, file, (int)this.sectionLength, this.md5s);
                    LogSunmi.e("DownLoadManagerNew", "position: --------------->" + this.position);
                    if (file.length() - (long)this.position * this.sectionLength < this.sectionLength) {
                        if (this.position == this.md5s.size() - 1) {
                            this.start = (long)this.position * this.sectionLength;
                            this.update_bytes = 0L;
                            break block9;
                        } else {
                            this.start = file.length();
                            this.update_bytes = file.length() - (long)this.position * this.sectionLength;
                        }
                        break block9;
                    } else {
                        this.start = (long)this.position * this.sectionLength;
                        this.update_bytes = 0L;
                    }
                    break block9;
                }
                if (null != this.mDownLoadListener) {
                    this.mDownInfo.setErrorCode(10005);
                    this.mDownInfo.setErrorMsg("messageDigest\u521d\u59cb\u5316\u9519\u8bef");
                    this.mDownLoadListener.onDownError(this.mDownInfo);
                }
                return;
            }
            this.start = file.length();
        }
        LogSunmi.d("DownLoadManagerNew", "start: --------------->" + this.start);
        ArrayList<Interceptor> interceptorList = new ArrayList<Interceptor>(2);
        if (null != this.mDownLoadListener) {
            interceptorList.add(this.downloadInterceptor(this.start));
        }
        interceptorList.add(this.responseCode416());
        Interceptor[] interceptors = new Interceptor[interceptorList.size()];
        interceptors = interceptorList.toArray(interceptors);
        try {
            this.preConfigHttpService(true, interceptors);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (null != this.mDownLoadListener) {
                this.mDownInfo.setErrorCode(10006);
                this.mDownInfo.setErrorMsg(e.getMessage());
                this.mDownLoadListener.onDownError(this.mDownInfo);
            }
            return;
        }
        this.mHttpService.downLoadFile(this.url, "bytes=" + this.start + "-").subscribeOn(Schedulers.io()).observeOn(Schedulers.io()).map((Function)new Function<ResponseBody, String>(){

            public String apply(ResponseBody responseBody) throws Exception {
                DownLoadManager.this.retryCount = 0;
                return FileUtils.writeToFile(responseBody, file, DownLoadManager.this.start, new FileCallback(DownLoadManager.this.isSection));
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe((SingleObserver)new SingleObserver<String>(){

            public void onSubscribe(Disposable d) {
                DownLoadManager.this.mDisposable = d;
                if (null != DownLoadManager.this.mDownLoadListener) {
                    DownLoadManager.this.mDownLoadListener.onDownStart(DownLoadManager.this.mDownInfo);
                }
            }

            public void onSuccess(String s) {
                if (DownLoadManager.this.mDownLoadListener != null) {
                    DownLoadManager.this.mDownLoadListener.onDownSpeed(DownLoadManager.this.mDownInfo, 0L);
                }
                if (s.equals("complete")) {
                    DownLoadManager.this.onCompleteFile();
                } else if (DownLoadManager.this.md5retryCount >= 3) {
                    DownLoadManager.this.md5retryCount = 0;
                    if (null != DownLoadManager.this.mDownLoadListener) {
                        DownLoadManager.this.mDownInfo.setErrorCode(10003);
                        DownLoadManager.this.mDownInfo.setErrorMsg("  md5\u5931\u8d25 " + DownLoadManager.this.position);
                        DownLoadManager.this.mDownLoadListener.onDownError(DownLoadManager.this.mDownInfo);
                    }
                } else {
                    LogSunmi.e("DownLoadManagerNew", "md5\u91cd\u8bd5" + DownLoadManager.this.md5retryCount);
                    DownLoadManager.this.md5retryCount++;
                    DownLoadManager.this.downloadFile();
                }
            }

            public void onError(Throwable e) {
                LogSunmi.d("DownLoadManagerNew", "onError: --------------->");
                e.printStackTrace();
                if (DownLoadManager.this.mDownLoadListener != null) {
                    DownLoadManager.this.mDownLoadListener.onDownSpeed(DownLoadManager.this.mDownInfo, 0L);
                }
                if (e instanceof IOException416) {
                    LogSunmi.d("DownLoadManagerNew", "onFinished: --------------->" + e.getMessage());
                    DownLoadManager.this.onCompleteFile();
                    return;
                }
                if (DownLoadManager.this.mDisposable != null && !DownLoadManager.this.mDisposable.isDisposed()) {
                    if (DownLoadManager.this.retryCount >= DownLoadManager.this.mHttpConfig.getRetryCount()) {
                        DownLoadManager.this.retryCount = 0;
                        if (null != DownLoadManager.this.mDownLoadListener) {
                            DownLoadManager.this.mDownInfo.setErrorCode(ParseErrorCodeUtil.parseErrorCode(e));
                            DownLoadManager.this.mDownInfo.setErrorMsg(e.getMessage());
                            DownLoadManager.this.mDownLoadListener.onDownError(DownLoadManager.this.mDownInfo);
                        }
                    } else {
                        LogSunmi.e("DownLoadManagerNew", "\u7f51\u7edc\u5931\u8d25\u91cd\u8bd5" + DownLoadManager.this.retryCount);
                        DownLoadManager.this.retryCount++;
                        DownLoadManager.this.myHandler.sendEmptyMessageDelayed(0, 5000L);
                    }
                }
            }
        });
    }

    public void onCompleteFile() {
        LogSunmi.e("DownLoadManagerNew", "\u7ed3\u675f");
        if (!this.md5.equals("-1")) {
            if (this.mDownLoadListener != null) {
                this.mDownLoadListener.onMd5Verify(this.mDownInfo);
            }
            FileUtils.md5sum(this.localPath, (Consumer<String>)((Consumer)s -> {
                if (this.md5.equals(s)) {
                    if (this.mDownLoadListener != null) {
                        this.mDownLoadListener.onDownComplete(this.mDownInfo);
                    }
                } else if (null != this.mDownLoadListener) {
                    this.mDownInfo.setErrorCode(10003);
                    this.mDownInfo.setErrorMsg("MD5\u9519\u8bef");
                    this.mDownLoadListener.onDownError(this.mDownInfo);
                    FileUtils.deleteFile(new File(this.localPath));
                }
            }));
        } else if (this.mDownLoadListener != null) {
            this.mDownLoadListener.onDownComplete(this.mDownInfo);
        }
    }

    private Interceptor downloadInterceptor(long start) {
        return new SunmiProgressDownloadInterceptor(new ProgressChangedCallback(){

            @Override
            public void onProgressChanged(long progress, long total, boolean isComplete) {
                if (total <= 0L) {
                    return;
                }
                Observable.just((Object)1).observeOn(AndroidSchedulers.mainThread()).subscribe(integer -> {
                    int tempProgressf = (int)(100L * progress / total);
                    if (tempProgressf > DownLoadManager.this.tempProgress) {
                        LogSunmi.e("DownLoadManagerNew", "progressf=" + progress + "   tempProgressf=" + tempProgressf + "  fileLength=" + total);
                        DownLoadManager.this.tempProgress = tempProgressf;
                        if (DownLoadManager.this.mDownLoadListener != null) {
                            DownLoadManager.this.mDownLoadListener.onDownProgress(DownLoadManager.this.mDownInfo, progress, total, progress == total);
                        }
                    }
                });
            }
        }, start);
    }

    private Interceptor responseCode416() {
        return chain -> {
            Response response = chain.proceed(chain.request());
            if (response.code() == 416) {
                throw new IOException416("response code is 416");
            }
            return response;
        };
    }

    private synchronized AbsBaseHelper preConfigHttpService(boolean forceCloseLogInterceptor, Interceptor ... interceptors) throws Exception {
        AbsBaseHelper helper;
        HttpConfig.Builder builder = this.mHttpConfig.newBuilder();
        if (interceptors.length > 0) {
            for (int i = 0; i < interceptors.length; ++i) {
                builder.interceptor(interceptors[i]);
            }
        }
        if (forceCloseLogInterceptor) {
            builder.log(false);
        }
        if ((helper = HttpServiceHelperFactory.get(builder)) == null) {
            throw new Exception("init absBaseHelper fail");
        }
        helper.initParam(this.mParam, builder);
        if (null != helper.headInterceptor()) {
            builder.interceptor(helper.headInterceptor());
        }
        HttpConfig httpConfig = builder.build();
        this.mHttpService = RetrofitFactory.getInstance().create(HttpService.class, this.url, httpConfig);
        if (!forceCloseLogInterceptor && httpConfig.isShowLogInterceptor()) {
            LogSunmi.d("SunmiHttp", "request param " + (this.mParam != null ? JSON.toJSONString((Object)this.mParam) : null));
            LogSunmi.d("SunmiHttp", " request map " + helper.getFieldMap().toString());
        }
        return helper;
    }

    public void cancel() {
        this.pause();
    }

    public void pause() {
        if (this.mDownLoadListener != null) {
            this.mDownLoadListener.onDownSpeed(this.mDownInfo, 0L);
        }
        this.myHandler.removeMessages(0);
        if (this.mDisposable != null && !this.mDisposable.isDisposed()) {
            this.mDisposable.dispose();
        }
    }

    public class FileCallback
    implements FileListener {
        boolean isSection;

        public FileCallback(boolean isSection) {
            this.isSection = isSection;
        }

        @Override
        public long getByte() {
            if (this.isSection) {
                return DownLoadManager.this.sectionLength;
            }
            return -1L;
        }

        @Override
        public boolean fileWhile(byte[] buf, int len) {
            if (this.isSection) {
                DownLoadManager.this.update_bytes = DownLoadManager.this.update_bytes + (long)len;
                if (DownLoadManager.this.update_bytes >= DownLoadManager.this.sectionLength) {
                    DownLoadManager.this.messageDigest.update(buf, 0, (int)((long)len - (DownLoadManager.this.update_bytes - DownLoadManager.this.sectionLength)));
                    if (!FileUtils.toHexString(DownLoadManager.this.messageDigest.digest()).equalsIgnoreCase((String)DownLoadManager.this.md5s.get(DownLoadManager.this.position))) {
                        return true;
                    }
                    DownLoadManager.this.position++;
                    LogSunmi.e("DownLoadManagerNew", "\u4e0b\u8f7d\u5b8c\u6210\u5206\u7247\uff1a" + DownLoadManager.this.position);
                    if (DownLoadManager.this.update_bytes - DownLoadManager.this.sectionLength != 0L) {
                        DownLoadManager.this.messageDigest.update(buf, (int)((long)len - (DownLoadManager.this.update_bytes - DownLoadManager.this.sectionLength)), (int)(DownLoadManager.this.update_bytes - DownLoadManager.this.sectionLength));
                        DownLoadManager.this.update_bytes = DownLoadManager.this.update_bytes - DownLoadManager.this.sectionLength;
                    } else {
                        DownLoadManager.this.update_bytes = 0L;
                    }
                } else {
                    DownLoadManager.this.messageDigest.update(buf, 0, len);
                }
            }
            return false;
        }

        @Override
        public boolean fileEnd() {
            if (this.isSection && DownLoadManager.this.update_bytes != 0L) {
                String md5e = FileUtils.toHexString(DownLoadManager.this.messageDigest.digest());
                LogSunmi.e("DownLoadManagerNew", "\u4e0b\u8f7d\u5b8c\u6210\u6700\u540e\u4e00\u7247\uff1a" + DownLoadManager.this.position + "  update_bytes=" + DownLoadManager.this.update_bytes + "   " + md5e);
                if (!md5e.equalsIgnoreCase((String)DownLoadManager.this.md5s.get(DownLoadManager.this.position))) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void speed(long speed) {
            LogSunmi.e("DownLoadManagerNew", "\u56de\u8c03\u901f\u5ea6\uff1a" + speed);
            if (DownLoadManager.this.mDownLoadListener != null) {
                DownLoadManager.this.mDownLoadListener.onDownSpeed(DownLoadManager.this.mDownInfo, speed);
            }
        }
    }

    private static class MyHandler
    extends Handler {
        private WeakReference<DownLoadManager> weakReference;

        public MyHandler(DownLoadManager downLoadManager) {
            super(Looper.getMainLooper());
            this.weakReference = new WeakReference<DownLoadManager>(downLoadManager);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            DownLoadManager downLoadManager = (DownLoadManager)this.weakReference.get();
            if (downLoadManager == null) {
                return;
            }
            LogSunmi.e("DownLoadManagerNew", "\u7f51\u7edc\u5931\u8d25\u91cd\u8bd5Delay" + downLoadManager.retryCount);
            downLoadManager.downloadFile();
        }
    }
}

