/*
 * Decompiled with CFR 0.152.
 */
package com.sunmilib.manager;

import com.sunmilib.bean.DownInfo;
import com.sunmilib.bean.DownloadState;
import com.sunmilib.listener.DownLoadListener;
import com.sunmilib.manager.DownLoadManager;
import com.sunmilib.service.HttpConfig;
import com.sunmilib.util.DaoUtils;
import com.sunmilib.util.LogSunmi;
import com.sunmilib.util.MD5Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DownLoadManagerMaster {
    private final String TAG = "DownLoadManagerMaster";
    private static DownLoadManagerMaster managerMaster = null;
    private int maxDownloadNum = 3;
    private Map<String, DownLoadManager> mRunnings;
    private List<DownInfo> mWaitings;
    private Map<String, DownLoadListener> mListeners;
    private MasterDownLoadListener mMasterDownLoadListener = new MasterDownLoadListener();
    private HashMap<String, Long> hashMap = new HashMap();

    private DownLoadManagerMaster() {
        this.mRunnings = new ConcurrentHashMap<String, DownLoadManager>(this.maxDownloadNum);
        this.mWaitings = new ArrayList<DownInfo>();
        this.mListeners = new ConcurrentHashMap<String, DownLoadListener>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DownLoadManagerMaster getInstance() {
        if (null != managerMaster) return managerMaster;
        Class<DownLoadManagerMaster> clazz = DownLoadManagerMaster.class;
        synchronized (DownLoadManagerMaster.class) {
            managerMaster = new DownLoadManagerMaster();
            // ** MonitorExit[var0] (shouldn't be in output)
            return managerMaster;
        }
    }

    public void addTask(String url, String localpath, Object param) {
        this.addTask(url, localpath, param, null);
    }

    public void addTask(String url, String localpath, Object param, DownLoadListener loadListener) {
        this.addTask(url, localpath, "-1", param, loadListener);
    }

    public void addTask(String url, String localpath, Object param, DownLoadListener loadListener, HttpConfig config) {
        this.addTask(url, localpath, "-1", null, -1L, -1L, param, loadListener, config);
    }

    public void addTask(String url, String localpath, String md5, Object param, DownLoadListener loadListener) {
        if (this.oneSecondAction(url)) {
            LogSunmi.e("DownLoadManagerMaster", "wo \u5361\u4f4f\u4e86");
            return;
        }
        LogSunmi.e("DownLoadManagerMaster", "wo \u8fdb\u6765\u4e86");
        this.addTask(url, localpath, md5, null, -1L, -1L, param, loadListener, HttpConfig.getInstance());
    }

    public void addTask(String url, String localpath, String md5, String[] md5s, long sectionLength, long fileLength, Object param, DownLoadListener loadListener) {
        if (this.oneSecondAction(url)) {
            LogSunmi.e("DownLoadManagerMaster", "wo \u5361\u4f4f\u4e86");
            return;
        }
        LogSunmi.e("DownLoadManagerMaster", "wo \u8fdb\u6765\u4e86");
        if (sectionLength == -1L || sectionLength == 0L || md5s == null || md5s.length == 0 || sectionLength * (long)(md5s.length - 1) > fileLength) {
            if (loadListener != null) {
                DownInfo downInfo = new DownInfo();
                downInfo.setUrl(url);
                downInfo.setErrorCode(10004);
                downInfo.setErrorMsg("\u53c2\u6570\u5f02\u5e38");
                downInfo.setState(DownloadState.ERROR);
                loadListener.onDownError(downInfo);
            }
            return;
        }
        this.addTask(url, localpath, md5, md5s, sectionLength, fileLength, param, loadListener, HttpConfig.getInstance());
    }

    public synchronized void addTask(String url, String localpath, String md5, String[] md5s, long sectionLength, long fileLength, Object param, DownLoadListener loadListener, HttpConfig httpConfig) {
        LogSunmi.d("DownLoadManagerMaster", "addTask: ---------->" + (null == httpConfig));
        this.mListeners.put(url, loadListener);
        DownInfo downInfo = DaoUtils.getInstance().getByUrl(url);
        if (null == downInfo) {
            LogSunmi.d("DownLoadManagerMaster", "task it not exist ------------------>" + url);
            downInfo = this.insertDb(url, localpath, param, httpConfig);
            downInfo.setMd5(md5);
            downInfo.setFileLength(fileLength);
            downInfo.setSectionLength(sectionLength);
            downInfo.setMd5s(md5s);
            if (this.mRunnings.size() >= this.maxDownloadNum) {
                LogSunmi.d("DownLoadManagerMaster", " task queue is busy ----------->" + url);
                downInfo.setState(DownloadState.WAITING);
                this.mWaitings.add(downInfo);
                DaoUtils.getInstance().update(downInfo);
                if (loadListener != null) {
                    loadListener.onDownWaiting(downInfo);
                }
            } else {
                LogSunmi.d("DownLoadManagerMaster", "task queue is idle and start task------------>" + url);
                downInfo.setState(DownloadState.START);
                DaoUtils.getInstance().update(downInfo);
                if (null != loadListener) {
                    loadListener.onDownStart(downInfo);
                }
                DownLoadManager downLoadManager = new DownLoadManager(downInfo, param, this.mMasterDownLoadListener, httpConfig);
                downLoadManager.downloadFile();
                this.mRunnings.put(url, downLoadManager);
            }
        } else {
            downInfo.setMd5(md5);
            downInfo.setFileLength(fileLength);
            downInfo.setSectionLength(sectionLength);
            downInfo.setMd5s(md5s);
            boolean isexists = new File(downInfo.getLocalPath()).exists();
            if (!isexists && downInfo.getState() == DownloadState.FINISH) {
                downInfo.setState(DownloadState.INIT);
                DaoUtils.getInstance().update(downInfo);
            }
            LogSunmi.d("DownLoadManagerMaster", "database has the task item ------------>" + url + "    " + (Object)((Object)downInfo.getState()));
            if (downInfo.getState() == DownloadState.FINISH) {
                if (null != loadListener) {
                    loadListener.onDownComplete(downInfo);
                }
            } else if (downInfo.getState() == DownloadState.WAITING) {
                LogSunmi.d("DownLoadManagerMaster", "task state is waiting --------------->" + url);
                downInfo.setmHttpConfig(httpConfig);
                if (this.mRunnings.size() >= this.maxDownloadNum) {
                    LogSunmi.d("DownLoadManagerMaster", " task queue is busy ----------->" + url);
                    if (!this.mWaitings.contains(downInfo)) {
                        this.mWaitings.add(downInfo);
                    }
                    if (loadListener != null) {
                        loadListener.onDownWaiting(downInfo);
                    }
                } else {
                    LogSunmi.d("DownLoadManagerMaster", "task queue is idle and start task------------>");
                    downInfo.setState(DownloadState.START);
                    DaoUtils.getInstance().update(downInfo);
                    if (null != loadListener) {
                        loadListener.onDownStart(downInfo);
                    }
                    DownLoadManager downLoadFile = new DownLoadManager(downInfo, param, this.mMasterDownLoadListener, httpConfig);
                    downLoadFile.downloadFile();
                    this.mRunnings.put(url, downLoadFile);
                }
            } else if (downInfo.getState() == DownloadState.DOWNING) {
                LogSunmi.d("DownLoadManagerMaster", "task state is running --------------->" + url);
                DownLoadManager downLoadManager = this.mRunnings.get(downInfo.getUrl());
                if (null != downLoadManager) {
                    LogSunmi.d("DownLoadManagerMaster", "task is in running queue ----------->");
                    if (null == downLoadManager.getDownLoadListener()) {
                        downLoadManager.setDownLoadListener(this.mMasterDownLoadListener);
                    }
                } else {
                    LogSunmi.d("DownLoadManagerMaster", "task is  not in running queue ----------->");
                    downInfo.setmHttpConfig(httpConfig);
                    if (this.mRunnings.size() >= this.maxDownloadNum) {
                        LogSunmi.d("DownLoadManagerMaster", "task queue is busy----------->");
                        downInfo.setState(DownloadState.WAITING);
                        this.mWaitings.add(downInfo);
                        DaoUtils.getInstance().update(downInfo);
                        if (null != loadListener) {
                            loadListener.onDownWaiting(downInfo);
                        }
                    } else {
                        LogSunmi.d("DownLoadManagerMaster", "task queue is idle and start task------------>");
                        downInfo.setState(DownloadState.START);
                        DaoUtils.getInstance().update(downInfo);
                        if (null != loadListener) {
                            loadListener.onDownStart(downInfo);
                        }
                        downLoadManager = new DownLoadManager(downInfo, param, this.mMasterDownLoadListener, httpConfig);
                        downLoadManager.downloadFile();
                        this.mRunnings.put(url, downLoadManager);
                    }
                }
            } else if (downInfo.getState() == DownloadState.INIT) {
                downInfo.setmHttpConfig(httpConfig);
                if (this.mRunnings.size() >= this.maxDownloadNum) {
                    LogSunmi.d("DownLoadManagerMaster", " task queue is busy ----------->" + url);
                    downInfo.setState(DownloadState.WAITING);
                    this.mWaitings.add(downInfo);
                    DaoUtils.getInstance().update(downInfo);
                    if (loadListener != null) {
                        loadListener.onDownWaiting(downInfo);
                    }
                } else {
                    LogSunmi.d("DownLoadManagerMaster", "task queue is idle and start task------------>");
                    downInfo.setState(DownloadState.START);
                    DaoUtils.getInstance().update(downInfo);
                    if (null != loadListener) {
                        loadListener.onDownStart(downInfo);
                    }
                    DownLoadManager downLoadManager = new DownLoadManager(downInfo, param, this.mMasterDownLoadListener, httpConfig);
                    downLoadManager.downloadFile();
                    this.mRunnings.put(url, downLoadManager);
                }
            } else {
                downInfo.setmHttpConfig(httpConfig);
                downInfo.setState(DownloadState.INIT);
                DaoUtils.getInstance().update(downInfo);
                this.addTask(downInfo.getUrl(), downInfo.getLocalPath(), downInfo.getMd5(), downInfo.getMd5s(), downInfo.getSectionLength(), downInfo.getFileLength(), downInfo.getmParam(), this.mListeners.get(downInfo.getUrl()), downInfo.getmHttpConfig());
            }
        }
    }

    public DownInfo insertDb(String url, String localpath, Object param, HttpConfig httpConfig) {
        LogSunmi.d("tag", "insertDb: ------------>" + url);
        DownInfo downInfo = new DownInfo();
        downInfo.setUrl(url);
        downInfo.setLocalPath(localpath);
        downInfo.setmParam(param);
        downInfo.setmHttpConfig(httpConfig);
        downInfo.setState(DownloadState.INIT);
        DaoUtils.getInstance().insert(downInfo);
        return downInfo;
    }

    public synchronized void onComplete(DownInfo downInfo) {
        LogSunmi.d("DownLoadManagerMaster", "onComplete: --------->" + downInfo.getUrl() + "    " + this.mWaitings.size());
        this.mRunnings.remove(downInfo.getUrl());
        if (null != this.mListeners.get(downInfo.getUrl())) {
            this.mListeners.get(downInfo.getUrl()).onDownComplete(downInfo);
        }
        downInfo.setState(DownloadState.FINISH);
        DaoUtils.getInstance().update(downInfo);
        if (this.mWaitings.size() > 0) {
            DownInfo downInfo1 = this.mWaitings.remove(0);
            downInfo1.setState(DownloadState.INIT);
            this.addTask(downInfo1.getUrl(), downInfo1.getLocalPath(), downInfo1.getMd5(), downInfo1.getMd5s(), downInfo1.getSectionLength(), downInfo1.getFileLength(), downInfo1.getmParam(), this.mListeners.get(downInfo1.getUrl()), downInfo1.getmHttpConfig());
        }
    }

    public synchronized void onError(DownInfo downInfo) {
        LogSunmi.d("DownLoadManagerMaster", "onError: --------->" + downInfo.getErrorMsg() + "    ErrorCode=" + downInfo.getErrorCode());
        this.mRunnings.remove(downInfo.getUrl());
        downInfo.setState(DownloadState.ERROR);
        DaoUtils.getInstance().update(downInfo);
        if (null != this.mListeners.get(downInfo.getUrl())) {
            this.mListeners.get(downInfo.getUrl()).onDownError(downInfo);
        }
        if (this.mWaitings.size() > 0) {
            DownInfo downInfo1 = this.mWaitings.remove(0);
            downInfo1.setState(DownloadState.INIT);
            this.addTask(downInfo1.getUrl(), downInfo1.getLocalPath(), downInfo1.getMd5(), downInfo1.getMd5s(), downInfo1.getSectionLength(), downInfo1.getFileLength(), downInfo1.getmParam(), this.mListeners.get(downInfo1.getUrl()), downInfo1.getmHttpConfig());
        }
    }

    public synchronized void onStart(DownInfo downInfo) {
        LogSunmi.d("DownLoadManagerMaster", "onStart: --------->" + downInfo.getUrl());
        downInfo.setState(DownloadState.DOWNING);
        DaoUtils.getInstance().update(downInfo);
    }

    public synchronized void unregisterListener(String url) {
        this.mListeners.remove(url);
    }

    public synchronized void unregisterListeners() {
        this.mListeners.clear();
    }

    public synchronized void registerListener(String url, DownLoadListener listener) {
        this.mListeners.put(url, listener);
    }

    public synchronized void pause(String url) {
        DownInfo downInfo = DaoUtils.getInstance().getByUrl(url);
        if (null == downInfo) {
            LogSunmi.d("DownLoadManagerMaster", "database has not task item,pause return  -------->");
            return;
        }
        downInfo.setState(DownloadState.PAUSE);
        DaoUtils.getInstance().update(downInfo);
        DownLoadManager downLoadFile = this.mRunnings.remove(url);
        if (null != downLoadFile) {
            LogSunmi.d("DownLoadManagerMaster", "task is runnig,excute pause  -------->");
            downLoadFile.pause();
            if (this.mWaitings.size() > 0) {
                DownInfo downInfo1 = this.mWaitings.remove(0);
                downInfo1.setState(DownloadState.INIT);
                this.addTask(downInfo1.getUrl(), downInfo1.getLocalPath(), downInfo1.getMd5(), downInfo1.getMd5s(), downInfo1.getSectionLength(), downInfo1.getFileLength(), downInfo1.getmParam(), this.mListeners.get(downInfo1.getUrl()), downInfo1.getmHttpConfig());
            }
        } else {
            this.removeWaiting(url);
        }
        this.mListeners.remove(url);
    }

    public synchronized void cancel(String url) {
        DownInfo downInfo = DaoUtils.getInstance().getByUrl(url);
        if (null == downInfo) {
            LogSunmi.d("DownLoadManagerMaster", "database has not task item,cancel return  -------->");
        } else {
            File file;
            DaoUtils.getInstance().delete(downInfo);
            DownLoadManager downLoadManager = this.mRunnings.remove(url);
            if (null != downLoadManager) {
                LogSunmi.d("DownLoadManagerMaster", "task is runnig,excute cancel  -------->");
                downLoadManager.pause();
                if (this.mWaitings.size() > 0) {
                    DownInfo downInfo1 = this.mWaitings.remove(0);
                    downInfo1.setState(DownloadState.INIT);
                    this.addTask(downInfo1.getUrl(), downInfo1.getLocalPath(), downInfo1.getMd5(), downInfo1.getMd5s(), downInfo1.getSectionLength(), downInfo1.getFileLength(), downInfo1.getmParam(), this.mListeners.get(downInfo1.getUrl()), downInfo1.getmHttpConfig());
                }
            } else {
                this.removeWaiting(url);
            }
            if ((file = new File(downInfo.getLocalPath())).exists()) {
                file.delete();
            }
            if (this.mWaitings.size() > 0) {
                DownInfo downInfo1 = this.mWaitings.remove(0);
                downInfo1.setState(DownloadState.INIT);
                this.addTask(downInfo1.getUrl(), downInfo1.getLocalPath(), downInfo1.getMd5(), downInfo1.getMd5s(), downInfo1.getSectionLength(), downInfo1.getFileLength(), downInfo1.getmParam(), this.mListeners.get(downInfo1.getUrl()), downInfo1.getmHttpConfig());
            }
        }
        this.mListeners.remove(url);
    }

    public void removeWaiting(String url) {
        DownInfo downInfo = null;
        for (DownInfo info : this.mWaitings) {
            if (!info.getUrl().equals(url)) continue;
            downInfo = info;
            break;
        }
        if (null != downInfo) {
            this.mWaitings.remove(downInfo);
        }
    }

    public synchronized boolean oneSecondAction(String url) {
        long time;
        String key = MD5Utils.md5(url);
        long currentTime = System.currentTimeMillis();
        long l = time = this.hashMap.get(key) == null ? 0L : this.hashMap.get(key);
        if (Math.abs(currentTime - time) >= 300L) {
            this.hashMap.put(key, currentTime);
            return false;
        }
        return true;
    }

    public Map<String, DownLoadManager> getmRunnings() {
        return this.mRunnings;
    }

    public List<DownInfo> getmWaitings() {
        return this.mWaitings;
    }

    class MasterDownLoadListener
    implements DownLoadListener {
        MasterDownLoadListener() {
        }

        @Override
        public void onDownComplete(DownInfo downInfo) {
            DownLoadManagerMaster.this.onComplete(downInfo);
            DownLoadManagerMaster.this.hashMap.remove(downInfo.getUrl());
        }

        @Override
        public void onDownWaiting(DownInfo downInfo) {
        }

        @Override
        public void onDownStart(DownInfo downInfo) {
            DownLoadManagerMaster.this.onStart(downInfo);
        }

        @Override
        public void onDownError(DownInfo downInfo) {
            DownLoadManagerMaster.this.onError(downInfo);
            DownLoadManagerMaster.this.hashMap.remove(downInfo.getUrl());
        }

        @Override
        public void onMd5Verify(DownInfo downInfo) {
            if (null != DownLoadManagerMaster.this.mListeners.get(downInfo.getUrl())) {
                ((DownLoadListener)DownLoadManagerMaster.this.mListeners.get(downInfo.getUrl())).onMd5Verify(downInfo);
            }
        }

        @Override
        public void onDownSpeed(DownInfo downInfo, long speed) {
            if (null != DownLoadManagerMaster.this.mListeners.get(downInfo.getUrl())) {
                ((DownLoadListener)DownLoadManagerMaster.this.mListeners.get(downInfo.getUrl())).onDownSpeed(downInfo, speed);
            }
        }

        @Override
        public void onDownProgress(DownInfo downInfo, long progress, long total, boolean isComplete) {
            if (null != DownLoadManagerMaster.this.mListeners.get(downInfo.getUrl())) {
                ((DownLoadListener)DownLoadManagerMaster.this.mListeners.get(downInfo.getUrl())).onDownProgress(downInfo, progress, total, isComplete);
            }
        }
    }
}

