/*
 * Decompiled with CFR 0.152.
 */
package com.sunmilib.observer;

import com.sunmilib.bean.DownInfo;
import com.sunmilib.exception.IOException416;
import com.sunmilib.listener.DownLoadListener;
import com.sunmilib.util.FileUtils;
import com.sunmilib.util.LogSunmi;
import com.sunmilib.util.ParseErrorCodeUtil;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;

public class DownloadSingleObserver
implements SingleObserver<String> {
    private final String TAG = "DownloadSingleObserver";
    private DownLoadListener mDownLoadListener;
    private String url;
    private long start;
    private DownInfo mDownInfo;

    public DownloadSingleObserver(DownLoadListener listener, String url, long start) {
        this.mDownLoadListener = listener;
        this.url = url;
        this.start = start;
    }

    public DownloadSingleObserver(DownLoadListener listener, String url, long start, DownInfo downInfo) {
        this.mDownLoadListener = listener;
        this.url = url;
        this.start = start;
        this.mDownInfo = downInfo;
    }

    public void onSubscribe(Disposable d) {
        LogSunmi.d("DownloadSingleObserver", "onSubscribe: ----------->" + this.start);
    }

    public void onError(Throwable e) {
        LogSunmi.d("DownloadSingleObserver", "onError: --------------->");
        e.printStackTrace();
        if (e instanceof IOException416) {
            LogSunmi.d("DownloadSingleObserver", "onFinished: --------------->" + e.getMessage());
            this.onComplete();
            return;
        }
        if (null != this.mDownLoadListener) {
            this.mDownInfo.setErrorCode(ParseErrorCodeUtil.parseErrorCode(e));
            this.mDownInfo.setErrorMsg(e.getMessage());
            this.mDownLoadListener.onDownError(this.mDownInfo);
        }
    }

    public void onSuccess(String s) {
        LogSunmi.d("DownloadSingleObserver", "onSuccess: --------------->" + s);
        this.onComplete();
    }

    public void onComplete() {
        String md5 = this.mDownInfo.getMd5();
        String path = this.mDownInfo.getLocalPath();
        if (md5 != null && !md5.equals("-1")) {
            if (md5.equals(FileUtils.md5sum(path))) {
                if (this.mDownLoadListener != null) {
                    this.mDownLoadListener.onDownComplete(this.mDownInfo);
                }
            } else if (null != this.mDownLoadListener) {
                this.mDownInfo.setErrorCode(10003);
                this.mDownInfo.setErrorMsg("MD5\u9519\u8bef");
                this.mDownLoadListener.onDownError(this.mDownInfo);
            }
        } else if (this.mDownLoadListener != null) {
            this.mDownLoadListener.onDownComplete(this.mDownInfo);
        }
    }
}

