/*
 * Decompiled with CFR 0.152.
 */
package com.sunmilib.observer;

import com.sunmilib.http.BaseResponse;
import com.sunmilib.listener.UploadListener;
import com.sunmilib.util.LogSunmi;
import com.sunmilib.util.ParseErrorCodeUtil;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;

public class UpLoadSingleObserver
implements SingleObserver<BaseResponse> {
    private final String TAG = "UpLoadSingleObserver";
    private String mUrl;
    private UploadListener mUploadListener;

    public UpLoadSingleObserver(String url, UploadListener uploadListener) {
        this.mUrl = url;
        this.mUploadListener = uploadListener;
    }

    public void onSubscribe(Disposable d) {
        LogSunmi.d("UpLoadSingleObserver", "onSubscribe: --------->");
    }

    public void onSuccess(BaseResponse s) {
        LogSunmi.d("UpLoadSingleObserver", "onSuccess: ------------->" + s.code);
        if (null == this.mUploadListener) {
            return;
        }
        this.mUploadListener.onSuccess(this.mUrl, s);
    }

    public void onError(Throwable e) {
        LogSunmi.d("UpLoadSingleObserver", "onError: ------->" + e.getMessage());
        if (null == this.mUploadListener) {
            return;
        }
        this.mUploadListener.onError(this.mUrl, ParseErrorCodeUtil.parseErrorCode(e), e.getMessage());
    }
}

