/*
 * Decompiled with CFR 0.152.
 */
package com.sunmilib.retrofit;

import android.text.TextUtils;
import com.sunmilib.retrofit.APIDns;
import com.sunmilib.retrofit.FastJsonConverterFactory;
import com.sunmilib.retrofit.TLSSocketFactory;
import com.sunmilib.service.HttpConfig;
import com.sunmilib.util.LogSunmi;
import com.sunmilib.util.UrlUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import okhttp3.Dns;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;

public class RetrofitFactory {
    public static final String HTTP_TAG = "SunmiHttp";
    private final Charset UTF8 = StandardCharsets.UTF_8;
    private HttpLoggingInterceptor loggingInterceptor;
    private Interceptor headerInterceptor;
    private OkHttpClient okHttpClient = new OkHttpClient();

    private RetrofitFactory() {
        this.headerInterceptor = new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request originalRequest = chain.request();
                Request.Builder requestBuilder = originalRequest.newBuilder().addHeader("userAgent", "sunmi.com ");
                Request request = requestBuilder.build();
                return chain.proceed(request);
            }
        };
        this.loggingInterceptor = new HttpLoggingInterceptor(message -> {
            if (!TextUtils.isEmpty((CharSequence)message)) {
                try {
                    LogSunmi.d(HTTP_TAG, "log: ----------->" + message);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LogSunmi.d(HTTP_TAG, "log: ----------->" + message);
                }
            }
        });
        this.loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
    }

    public static RetrofitFactory getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public <T> T create(Class<T> clazz) {
        return this.create(clazz, null, HttpConfig.getInstance());
    }

    public <T> T create(Class<T> clazz, String url) {
        return this.create(clazz, url, HttpConfig.getInstance());
    }

    public <T> T create(Class<T> clazz, String url, HttpConfig config) {
        return this.create(clazz, url, config, true);
    }

    public <T> T create(Class<T> clazz, String url, HttpConfig config, boolean isAsync) {
        OkHttpClient.Builder mBuilder = this.okHttpClient.newBuilder();
        mBuilder.interceptors().clear();
        mBuilder.addInterceptor(this.headerInterceptor).connectTimeout((long)config.getConnectTimeout(), TimeUnit.SECONDS).readTimeout((long)config.getReadTimeout(), TimeUnit.SECONDS).writeTimeout((long)config.getWriteTimeout(), TimeUnit.SECONDS).dns((Dns)new APIDns()).retryOnConnectionFailure(config.getRetryCount() > 0);
        if (config.getProtocols() != null && !config.getProtocols().isEmpty()) {
            mBuilder.protocols(config.getProtocols());
        }
        if (config.getSSLProtocols() != null && config.getSSLProtocols().length > 0) {
            try {
                mBuilder.sslSocketFactory((SSLSocketFactory)new TLSSocketFactory(config.getSSLProtocols()), TLSSocketFactory.DEFAULT_TRUST_MANAGERS);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (Interceptor interceptor : config.getInterceptors()) {
            mBuilder.addInterceptor(interceptor);
        }
        if (config.isShowLogInterceptor()) {
            mBuilder.addInterceptor((Interceptor)this.loggingInterceptor);
        }
        if (config.getCTInterceptorFactory() != null) {
            mBuilder.addNetworkInterceptor(config.getCTInterceptorFactory().getCTInterceptor());
        }
        Retrofit retrofit = new Retrofit.Builder().baseUrl(UrlUtils.getBasUrl(url)).client(mBuilder.build()).addConverterFactory((Converter.Factory)FastJsonConverterFactory.create()).addCallAdapterFactory((CallAdapter.Factory)(isAsync ? RxJava2CallAdapterFactory.createAsync() : RxJava2CallAdapterFactory.create())).build();
        Object service = retrofit.create(clazz);
        return (T)service;
    }

    private static class SingletonHolder {
        private static final RetrofitFactory INSTANCE = new RetrofitFactory();

        private SingletonHolder() {
        }
    }
}

