/*
 * Decompiled with CFR 0.152.
 */
package com.sunmilib.retrofit;

import android.os.Build;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.internal.platform.Platform;

public class TLSSocketFactory
extends SSLSocketFactory {
    private static final String[] PROTOCOL_ARRAY;
    public static X509TrustManager DEFAULT_TRUST_MANAGERS;
    private SSLSocketFactory delegate;
    private String[] sslProtocols;

    public TLSSocketFactory(String[] sslProtocols) {
        try {
            this.sslProtocols = sslProtocols;
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{DEFAULT_TRUST_MANAGERS}, new SecureRandom());
            this.delegate = sslContext.getSocketFactory();
        }
        catch (GeneralSecurityException e) {
            throw new AssertionError();
        }
    }

    public TLSSocketFactory(SSLSocketFactory factory) {
        this.delegate = factory;
    }

    private void setSupportProtocolAndCipherSuites(Socket socket) {
        if (socket instanceof SSLSocket) {
            ((SSLSocket)socket).setEnabledProtocols(this.sslProtocols != null && this.sslProtocols.length > 0 ? this.sslProtocols : PROTOCOL_ARRAY);
        }
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegate.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        Socket ssl = this.delegate.createSocket(s, host, port, autoClose);
        this.setSupportProtocolAndCipherSuites(ssl);
        return ssl;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        Socket ssl = this.delegate.createSocket(host, port);
        this.setSupportProtocolAndCipherSuites(ssl);
        return ssl;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        Socket ssl = this.delegate.createSocket(host, port, localHost, localPort);
        this.setSupportProtocolAndCipherSuites(ssl);
        return ssl;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket ssl = this.delegate.createSocket(host, port);
        this.setSupportProtocolAndCipherSuites(ssl);
        return ssl;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket ssl = this.delegate.createSocket(address, port, localAddress, localPort);
        this.setSupportProtocolAndCipherSuites(ssl);
        return ssl;
    }

    @Override
    public Socket createSocket() throws IOException {
        Socket ssl = this.delegate.createSocket();
        this.setSupportProtocolAndCipherSuites(ssl);
        return ssl;
    }

    static {
        DEFAULT_TRUST_MANAGERS = Platform.get().platformTrustManager();
        PROTOCOL_ARRAY = Build.VERSION.SDK_INT >= 26 ? new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"} : (Build.VERSION.SDK_INT >= 16 ? new String[]{"SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2"} : new String[]{"SSLv3", "TLSv1"});
    }
}

