/*
 * Decompiled with CFR 0.152.
 */
package com.sunmilib.service;

import android.text.TextUtils;
import com.sunmilib.service.HttpConfig;
import java.io.File;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public abstract class AbsBaseHelper {
    public static final String VERSION = "version";
    public static final String PARAM = "params";
    public static final String TIMESTAMP = "timeStamp";
    public static final String RANDOM_NUM = "randomNum";
    public static final String TIMEZONE = "timeZone";
    public static final String LANGUAGE = "language";
    public static final String SIGN = "sign";
    public static final String REGION = "region";
    public static final String FILE = "file";
    public static final String IS_ENCRYPTED = "isEncrypted";
    public static final String DEFAULT_MEDIA_TYPE = "application/octet-stream";
    public static final String PARAMS_MSN = "msn";
    public static final String PARAMS_NONCE = "nonce";
    public static final String PARAMS_TIMESTAMP = "timestamp";

    public abstract void initParam(Object var1, HttpConfig.Builder var2);

    public abstract Map<String, String> getFieldMap();

    public abstract MultipartBody getRequestBody(ArrayList<String> var1, String var2);

    public abstract MultipartBody getRequestBody(String var1, long var2, long var4);

    public abstract Map<String, RequestBody> getRequestParamsBody();

    public Interceptor headInterceptor() {
        return null;
    }

    protected ArrayList<MultipartBody.Part> getRequestFilesToMultipartBodyParts(ArrayList<String> paths, String key) {
        if (paths == null || paths.isEmpty()) {
            return new ArrayList<MultipartBody.Part>();
        }
        ArrayList<MultipartBody.Part> parts = new ArrayList<MultipartBody.Part>(paths.size());
        for (String path : paths) {
            File file = new File(path);
            if (!file.exists()) continue;
            String contentTypeFor = URLConnection.getFileNameMap().getContentTypeFor(path);
            RequestBody requestBody = RequestBody.create((MediaType)(TextUtils.isEmpty((CharSequence)contentTypeFor) ? MediaType.parse((String)DEFAULT_MEDIA_TYPE) : MediaType.parse((String)contentTypeFor)), (File)file);
            MultipartBody.Part part = MultipartBody.Part.createFormData((String)(TextUtils.isEmpty((CharSequence)key) ? FILE : key), (String)file.getName(), (RequestBody)requestBody);
            parts.add(part);
        }
        return parts;
    }

    protected RequestBody paramToRequestBody(String param) {
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)param);
        return requestBody;
    }
}

