/*
 * Decompiled with CFR 0.152.
 */
package com.sunmilib.service;

import android.content.Context;
import com.sunmilib.certificatetransparency.CTInterceptorFactory;
import com.sunmilib.service.AbsBaseHelper;
import com.sunmilib.service.HttpConfig;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Interceptor;
import okhttp3.Protocol;

abstract class BaseHttpConfig {
    protected HttpConfig.SecretMode secretMode;
    protected String secretKey = "";
    protected String secretIV = "";
    protected String signKey = "";
    protected int writeTimeout;
    protected int connectTimeout;
    protected int readTimeout;
    protected int retryCount;
    protected boolean isEncrypted;
    protected boolean debug;
    protected boolean showLogInterceptor;
    protected Class<? extends AbsBaseHelper> helperClz;
    protected List<Interceptor> interceptors = new ArrayList<Interceptor>();
    protected CTInterceptorFactory cTInterceptorFactory;
    protected Context appContext;
    protected List<Protocol> protocols;
    protected String[] SSLProtocols;

    public BaseHttpConfig() {
        this.isEncrypted = false;
        this.debug = false;
        this.showLogInterceptor = false;
        this.retryCount = 3;
    }

    public BaseHttpConfig(BaseHttpConfig base) {
        this.secretKey = base.secretKey;
        this.secretIV = base.secretIV;
        this.signKey = base.signKey;
        this.secretMode = base.secretMode;
        if (this.secretMode == null) {
            this.secretMode = HttpConfig.SecretMode.DES;
        }
        this.helperClz = base.helperClz;
        this.connectTimeout = base.connectTimeout;
        this.readTimeout = base.readTimeout;
        this.writeTimeout = base.writeTimeout;
        this.isEncrypted = base.isEncrypted;
        this.retryCount = base.retryCount;
        this.debug = base.debug;
        this.showLogInterceptor = base.showLogInterceptor;
        this.interceptors.addAll(base.interceptors);
        this.cTInterceptorFactory = base.cTInterceptorFactory;
        this.appContext = base.appContext;
        this.protocols = base.protocols;
        this.SSLProtocols = base.SSLProtocols;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getSecretIV() {
        return this.secretIV;
    }

    public String getSignKey() {
        return this.signKey;
    }

    public HttpConfig.SecretMode getSecretMode() {
        return this.secretMode;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isShowLogInterceptor() {
        return this.showLogInterceptor;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public Context getAppContext() {
        return this.appContext;
    }

    public Class<? extends AbsBaseHelper> getHelper() {
        return this.helperClz;
    }

    public CTInterceptorFactory getCTInterceptorFactory() {
        return this.cTInterceptorFactory;
    }

    public List<Protocol> getProtocols() {
        return this.protocols;
    }

    public String[] getSSLProtocols() {
        return this.SSLProtocols;
    }

    public String toString() {
        return "Config{  writeTimeout=" + this.writeTimeout + "  connectTimeout=" + this.connectTimeout + "  readTimeout=" + this.readTimeout + "  retryCount=" + this.retryCount + "  showLogInterceptor" + this.showLogInterceptor + "  interceptors.size()" + this.interceptors.size() + "}";
    }
}

