/*
 * Decompiled with CFR 0.152.
 */
package com.sunmilib.service;

import android.content.Context;
import com.sunmilib.certificatetransparency.CTInterceptorFactory;
import com.sunmilib.service.AbsBaseHelper;
import com.sunmilib.service.BaseHttpConfig;
import java.util.List;
import okhttp3.Interceptor;
import okhttp3.Protocol;

public class HttpConfig
extends BaseHttpConfig {
    public static final String TAG = HttpConfig.class.getSimpleName();
    private static HttpConfig sConfig = null;

    private HttpConfig(Builder builder) {
        super(builder);
    }

    public static HttpConfig getInstance() {
        if (null == sConfig) {
            throw new RuntimeException("please excute initSConfig method first!!!");
        }
        return sConfig;
    }

    public static void initSConfig(HttpConfig config) {
        if (sConfig != null) {
            new RuntimeException(" dMultiple initialization ");
        }
        sConfig = new HttpConfig(new Builder(config));
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static final class Builder
    extends BaseHttpConfig {
        static final int DEFAULT_TIMEOUT = 30;

        public Builder() {
            this.connectTimeout = 30;
            this.readTimeout = 30;
            this.writeTimeout = 30;
        }

        private Builder(HttpConfig config) {
            super(config);
        }

        public Builder encrypted(boolean encrypted) {
            this.isEncrypted = encrypted;
            return this;
        }

        public Builder secretMode(SecretMode secretMode) {
            this.secretMode = secretMode;
            return this;
        }

        public Builder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public Builder secretIV(String secretIV) {
            this.secretIV = secretIV;
            return this;
        }

        public Builder signKey(String signKey) {
            this.signKey = signKey;
            return this;
        }

        public Builder httpHelper(Class<? extends AbsBaseHelper> helperClz) {
            this.helperClz = helperClz;
            return this;
        }

        public Builder retryCount(int retryCount) {
            this.retryCount = retryCount;
            return this;
        }

        public Builder writeTimeout(int writeTimeout) {
            this.writeTimeout = writeTimeout;
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder debug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public Builder log(boolean showLogInterceptor) {
            this.showLogInterceptor = showLogInterceptor;
            return this;
        }

        public Builder interceptor(Interceptor interceptor) {
            this.interceptors.add(interceptor);
            return this;
        }

        public Builder cTInterceptorFactory(CTInterceptorFactory factory) {
            this.cTInterceptorFactory = factory;
            return this;
        }

        public Builder appContext(Context appContext) {
            this.appContext = appContext.getApplicationContext();
            return this;
        }

        public Builder protocols(List<Protocol> protocols) {
            this.protocols = protocols;
            return this;
        }

        public Builder SSLProtocols(String[] sslProtocols) {
            this.SSLProtocols = sslProtocols;
            return this;
        }

        public HttpConfig build() {
            if (this.appContext == null) {
                throw new RuntimeException("please config app context");
            }
            return new HttpConfig(this);
        }
    }

    public static enum SecretMode {
        DES,
        AES;

    }
}

