/*
 * Decompiled with CFR 0.152.
 */
package com.sunmilib.service;

import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.sunmilib.http.PartUploadRequestBody;
import com.sunmilib.service.AbsBaseHelper;
import com.sunmilib.service.HttpConfig;
import com.sunmilib.util.AppUtil;
import com.sunmilib.util.DateUtilsSunmi;
import com.sunmilib.util.I18NUtils;
import java.io.File;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public abstract class HttpServiceHelper
extends AbsBaseHelper {
    protected String version;
    protected String sourceParamStr;
    protected String param;
    protected String timeStamp;
    protected String randomNum;
    protected String timeZone;
    protected String language;
    protected String region;
    protected String sign;
    protected String isEncrypted;

    @Override
    public void initParam(Object paramBean, HttpConfig.Builder builder) {
        this.version = AppUtil.getVersionName(builder.getAppContext());
        this.sourceParamStr = this.getParamString(paramBean);
        this.param = this.createJsonHttpParameter(this.sourceParamStr, builder);
        this.timeStamp = DateUtilsSunmi._getGMTime() + "";
        this.randomNum = String.valueOf((int)((Math.random() * 9.0 + 1.0) * 100000.0));
        this.timeZone = I18NUtils.getCurrentTimeZone();
        this.language = I18NUtils.getCurrentLanguage(builder.getAppContext());
        this.region = builder.getAppContext().getResources().getConfiguration().locale.getCountry();
    }

    private String getParamString(Object paramBean) {
        String trim;
        if (paramBean == null) {
            paramBean = "{}";
        }
        if (paramBean instanceof String && TextUtils.isEmpty((CharSequence)(trim = ((String)paramBean).trim()))) {
            paramBean = "{}";
        }
        String paramJson = JSON.toJSONString((Object)paramBean);
        return paramJson;
    }

    private String createJsonHttpParameter(String sourceParamStr, HttpConfig.Builder builder) {
        if (builder.isEncrypted()) {
            try {
                return this.secretEncodeParam(sourceParamStr, builder);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return sourceParamStr;
    }

    abstract String secretEncodeParam(String var1, HttpConfig.Builder var2) throws Exception;

    @Override
    public Map<String, String> getFieldMap() {
        HashMap<String, String> filedMap = new HashMap<String, String>();
        filedMap.put("version", this.version);
        filedMap.put("params", this.param);
        filedMap.put("timeStamp", this.timeStamp);
        filedMap.put("randomNum", this.randomNum);
        filedMap.put("timeZone", this.timeZone);
        filedMap.put("language", this.language);
        filedMap.put("region", this.region);
        filedMap.put("sign", this.sign);
        return filedMap;
    }

    public MultipartBody getRequestBody(String path) throws RuntimeException {
        File file = new File(path);
        if (!file.exists()) {
            throw new RuntimeException("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u5b58\u5728\uff01\uff01\uff01");
        }
        ArrayList<String> paths = new ArrayList<String>(1);
        paths.add(path);
        return this.getRequestBody(paths);
    }

    public MultipartBody getRequestBody(ArrayList<String> paths) {
        return this.getRequestBody(paths, "");
    }

    @Override
    public MultipartBody getRequestBody(ArrayList<String> paths, String key) {
        MultipartBody.Builder builder = this.getMultipartParamsBodyBuilder();
        for (String path : paths) {
            File file = new File(path);
            String contentTypeFor = URLConnection.getFileNameMap().getContentTypeFor(path);
            builder.addFormDataPart(TextUtils.isEmpty((CharSequence)key) ? "file" : key, file.getName(), RequestBody.create((MediaType)(TextUtils.isEmpty((CharSequence)contentTypeFor) ? MediaType.parse((String)"application/octet-stream") : MediaType.parse((String)contentTypeFor)), (File)file));
        }
        return builder.build();
    }

    @Override
    public MultipartBody getRequestBody(String path, long startUploadBytes, long endUploadBytes) throws RuntimeException {
        File file = new File(path);
        if (!file.exists()) {
            throw new RuntimeException("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u5b58\u5728\uff01\uff01\uff01");
        }
        MultipartBody.Builder builder = this.getMultipartParamsBodyBuilder();
        String contentTypeFor = URLConnection.getFileNameMap().getContentTypeFor(path);
        builder.addFormDataPart("file", file.getName(), (RequestBody)new PartUploadRequestBody(TextUtils.isEmpty((CharSequence)contentTypeFor) ? MediaType.parse((String)"application/octet-stream") : MediaType.parse((String)contentTypeFor), file, startUploadBytes, endUploadBytes));
        return builder.build();
    }

    public MultipartBody.Builder getMultipartParamsBodyBuilder() {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("version", this.version).addFormDataPart("params", this.param).addFormDataPart("timeStamp", this.timeStamp).addFormDataPart("randomNum", this.randomNum).addFormDataPart("timeZone", this.timeZone).addFormDataPart("language", this.language).addFormDataPart("region", this.region).addFormDataPart("sign", this.sign);
        return builder;
    }

    @Override
    public Map<String, RequestBody> getRequestParamsBody() {
        HashMap<String, RequestBody> params = new HashMap<String, RequestBody>();
        params.put("version", this.paramToRequestBody(this.version));
        params.put("params", this.paramToRequestBody(this.param));
        params.put("timeStamp", this.paramToRequestBody(this.timeStamp));
        params.put("randomNum", this.paramToRequestBody(this.randomNum));
        params.put("timeZone", this.paramToRequestBody(this.timeZone));
        params.put("language", this.paramToRequestBody(this.language));
        params.put("region", this.paramToRequestBody(this.region));
        params.put("sign", this.paramToRequestBody(this.sign));
        return params;
    }
}

