/*
 * Decompiled with CFR 0.152.
 */
package com.sunmilib.service;

import com.sunmilib.service.AESHttpServiceHelper;
import com.sunmilib.service.AbsBaseHelper;
import com.sunmilib.service.DESHttpServiceHelper;
import com.sunmilib.service.HttpConfig;
import com.sunmilib.util.LogSunmi;

public class HttpServiceHelperFactory {
    public static AbsBaseHelper get(HttpConfig.Builder builder) {
        Class clz = builder.getHelper();
        AbsBaseHelper helper = null;
        try {
            if (clz == null) {
                switch (builder.secretMode) {
                    case AES: {
                        helper = new AESHttpServiceHelper();
                        break;
                    }
                    default: {
                        helper = new DESHttpServiceHelper();
                        break;
                    }
                }
            } else {
                helper = (AbsBaseHelper)clz.newInstance();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LogSunmi.e("HttpServiceHelperFactory", "get httpService helper error");
        }
        return helper;
    }
}

