/*
 * Decompiled with CFR 0.152.
 */
package com.sunmilib.util;

import android.content.Context;
import com.sunmilib.bean.DownInfo;
import com.sunmilib.datebase.AppDatebase;
import com.sunmilib.util.LogSunmi;
import java.util.List;

public class DaoUtils {
    private static DaoUtils mDaoUtils = null;
    private Context mContext;

    private DaoUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DaoUtils getInstance() {
        if (null != mDaoUtils) return mDaoUtils;
        Class<DaoUtils> clazz = DaoUtils.class;
        synchronized (DaoUtils.class) {
            mDaoUtils = new DaoUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mDaoUtils;
        }
    }

    public void init(Context context) {
        this.mContext = context.getApplicationContext();
    }

    public void insert(DownInfo info) {
        LogSunmi.d("tag", "insert--------------->" + info.getUrl());
        AppDatebase.getInstance(this.mContext).downInfoDao().insert(info);
    }

    public void update(DownInfo info) {
        AppDatebase.getInstance(this.mContext).downInfoDao().update(info.getUrl(), info.getDownloadState());
    }

    public DownInfo getByUrl(String url) {
        List<DownInfo> infos = AppDatebase.getInstance(this.mContext).downInfoDao().getByUrl(url);
        if (null != infos && infos.size() > 0) {
            return infos.get(0);
        }
        return null;
    }

    public DownInfo getByPath(String path) {
        List<DownInfo> infos = AppDatebase.getInstance(this.mContext).downInfoDao().getByLocalpath(path);
        if (null != infos && infos.size() > 0) {
            return infos.get(0);
        }
        return null;
    }

    public void deleteAll() {
        AppDatebase.getInstance(this.mContext).downInfoDao().deleteAll();
    }

    public void delete(DownInfo info) {
        AppDatebase.getInstance(this.mContext).downInfoDao().deleteByUrl(info.getUrl());
    }

    public void delete(String url) {
        AppDatebase.getInstance(this.mContext).downInfoDao().deleteByUrl(url);
    }

    public void deleteByPath(String localpath) {
        AppDatebase.getInstance(this.mContext).downInfoDao().deleteByLocalpath(localpath);
    }
}

