/*
 * Decompiled with CFR 0.152.
 */
package com.sunmilib.util;

import android.annotation.SuppressLint;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

@SuppressLint(value={"SimpleDateFormat"})
public class DateUtilsSunmi {
    public static final int DAY = 86400000;
    public static final String yyyy_MM_dd_HH_mm_ss = "yyyy/MM/dd HH:mm:ss";
    public static final String yyyy_MM_dd = "yyyy/MM/dd";
    public static final String yyyy_MM_dd_HH_mm = "yyyy/MM/dd HH:mm";
    public static final String HH_mm = "HH:mm";
    public static final int WEEKDAYS = 7;
    public static String[] WEEK = new String[]{"\u5468\u65e5", "\u5468\u4e00", "\u5468\u4e8c", "\u5468\u4e09", "\u5468\u56db", "\u5468\u4e94", "\u5468\u516d"};

    public static long getGMTime() {
        SimpleDateFormat sdf = DateUtilsSunmi.getSimpleDateFormatYMDHMS();
        sdf.setTimeZone(TimeZone.getTimeZone("Etc/Greenwich"));
        String format = sdf.format(new Date());
        SimpleDateFormat sdf1 = DateUtilsSunmi.getSimpleDateFormatYMDHMS();
        Date gmDate = null;
        try {
            gmDate = sdf1.parse(format);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return gmDate.getTime() / 1000L;
    }

    public static long _getGMTime() {
        int round = (int)(System.currentTimeMillis() / 1000L);
        return round;
    }

    public static long getTodayZeroTime() {
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(10, 0);
        cal.set(13, 1);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public static String getCurrentTime() {
        SimpleDateFormat sdf = DateUtilsSunmi.getSimpleDateFormatYMDHMS();
        String date = sdf.format(new Date(System.currentTimeMillis()));
        return date;
    }

    public static String getYestoryDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        SimpleDateFormat sdf = DateUtilsSunmi.getSimpleDateFormat(yyyy_MM_dd);
        String yestoday = sdf.format(calendar.getTime());
        return yestoday;
    }

    public static String getTomorrowDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 1);
        SimpleDateFormat sdf = DateUtilsSunmi.getSimpleDateFormat(yyyy_MM_dd);
        String tomorrow = sdf.format(calendar.getTime());
        return tomorrow;
    }

    public static String getTodayDate() {
        long time = System.currentTimeMillis();
        Date date = new Date(time);
        SimpleDateFormat format = DateUtilsSunmi.getSimpleDateFormatYMDHMS();
        return format.format(date);
    }

    private static SimpleDateFormat getSimpleDateFormatYMDHMS() {
        SimpleDateFormat format = new SimpleDateFormat(yyyy_MM_dd_HH_mm_ss, Locale.ENGLISH);
        return format;
    }

    private static SimpleDateFormat getSimpleDateFormat(String dateType) {
        return new SimpleDateFormat(dateType, Locale.ENGLISH);
    }

    public static String convertTime(long time, String format) {
        if (time == 0L) {
            return "";
        }
        Date date = new Date(time * 1000L);
        SimpleDateFormat sdf = DateUtilsSunmi.getSimpleDateFormat(format);
        return sdf.format(date);
    }

    public static String convertTime(long time) {
        if (time == 0L) {
            return "";
        }
        Date date = new Date(time * 1000L);
        SimpleDateFormat sdf = DateUtilsSunmi.getSimpleDateFormatYMDHMS();
        return sdf.format(date);
    }

    public static String timeStampToStr(long timeStamp) {
        SimpleDateFormat sdf = DateUtilsSunmi.getSimpleDateFormatYMDHMS();
        String date = sdf.format(timeStamp * 1000L);
        return date;
    }

    public static String timeStampToStr1(long timeStamp) {
        SimpleDateFormat sdf = DateUtilsSunmi.getSimpleDateFormat(yyyy_MM_dd_HH_mm);
        String date = sdf.format(timeStamp * 1000L);
        return date;
    }

    public static String timeStampToTime(long timeStamp) {
        SimpleDateFormat sdf = DateUtilsSunmi.getSimpleDateFormat(HH_mm);
        String date = sdf.format(timeStamp * 1000L);
        return date;
    }

    public static long getStringToDate(String time) {
        SimpleDateFormat sdf = DateUtilsSunmi.getSimpleDateFormat(yyyy_MM_dd_HH_mm);
        Date date = new Date();
        try {
            date = sdf.parse(time);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date.getTime() / 1000L;
    }

    public static long getString2Date(String time) {
        SimpleDateFormat sdf = DateUtilsSunmi.getSimpleDateFormat(yyyy_MM_dd);
        Date date = new Date();
        try {
            date = sdf.parse(time);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date.getTime() / 1000L;
    }

    public static boolean judgeCurrTime(String time) {
        SimpleDateFormat sdf = DateUtilsSunmi.getSimpleDateFormat(yyyy_MM_dd_HH_mm);
        Date date = new Date();
        try {
            date = sdf.parse(time);
            long t = date.getTime();
            long round = System.currentTimeMillis();
            return t - round > 0L;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean judgeCurrTime(long time) {
        long round = System.currentTimeMillis();
        return time - round > 0L;
    }

    public static boolean judgeTime2Time(String time1, String time2) {
        SimpleDateFormat sdf = DateUtilsSunmi.getSimpleDateFormat(yyyy_MM_dd_HH_mm);
        try {
            Date date1 = sdf.parse(time1);
            Date date2 = sdf.parse(time2);
            long l1 = date1.getTime() / 1000L;
            long l2 = date2.getTime() / 1000L;
            return l2 - l1 > 0L;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String formatDate(long timeStamp) {
        SimpleDateFormat sdf = DateUtilsSunmi.getSimpleDateFormat(yyyy_MM_dd_HH_mm);
        String date = sdf.format(timeStamp * 1000L);
        return date;
    }

    public static String formatDateDot(long timeStamp) {
        SimpleDateFormat sdf = DateUtilsSunmi.getSimpleDateFormat(yyyy_MM_dd_HH_mm);
        String date = sdf.format(timeStamp);
        return date;
    }

    public static String getTime(long timeStamp) {
        String time = null;
        SimpleDateFormat sdf = DateUtilsSunmi.getSimpleDateFormat(yyyy_MM_dd_HH_mm_ss);
        String date = sdf.format(timeStamp * 1000L);
        String[] split = date.split("\\s");
        if (split.length > 1) {
            time = split[1];
        }
        return time;
    }

    public static String timeStampToFormat(long timeStamp) {
        long curTime = System.currentTimeMillis() / 1000L;
        long time = curTime - timeStamp;
        return time / 60L + "";
    }

    public static int nowCurrentTime(long timeStamp) {
        long curTime = System.currentTimeMillis() / 1000L;
        long time = timeStamp - curTime;
        return (int)time;
    }

    public static String nowCurrentPoint(boolean flag) {
        SimpleDateFormat sdf = DateUtilsSunmi.getSimpleDateFormat(HH_mm);
        String date = sdf.format(System.currentTimeMillis());
        String[] split = date.split(":");
        String hour = null;
        String minute = null;
        if (flag) {
            if (split.length > 1) {
                hour = split[0];
                return hour;
            }
        } else if (split.length > 1) {
            minute = split[1];
            return minute;
        }
        return null;
    }

    public static String StandardFormatStr(String str) {
        SimpleDateFormat sdf = DateUtilsSunmi.getSimpleDateFormatYMDHMS();
        try {
            Date d = sdf.parse(str);
            long timeStamp = d.getTime();
            long curTime = System.currentTimeMillis() / 1000L;
            long time = curTime - timeStamp / 1000L;
            return time / 60L + "";
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String DateToWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayIndex = calendar.get(7);
        if (dayIndex < 1 || dayIndex > 7) {
            return null;
        }
        return WEEK[dayIndex - 1];
    }

    public static String DateToWeek(long timeStamp) {
        Date date = new Date(timeStamp);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayIndex = calendar.get(7);
        if (dayIndex < 1 || dayIndex > 7) {
            return null;
        }
        return WEEK[dayIndex - 1];
    }

    public static String getCurrentDateString() {
        String result = null;
        SimpleDateFormat sdf = DateUtilsSunmi.getSimpleDateFormatYMDHMS();
        Date nowDate = new Date();
        result = sdf.format(nowDate);
        return result;
    }

    private static long getWeeOfToday() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }
}

