/*
 * Decompiled with CFR 0.152.
 */
package com.sunmilib.util;

import android.os.Environment;
import android.os.SystemClock;
import android.text.TextUtils;
import com.sunmilib.listener.FileListener;
import com.sunmilib.util.BufferedRandomAccessFile;
import com.sunmilib.util.LogSunmi;
import io.reactivex.Flowable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.util.List;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class FileUtils {
    private static final String TAG = "DownLoadManagerNew";
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static boolean checkSDStatus() {
        String sdStatus = Environment.getExternalStorageState();
        return sdStatus.equals("mounted");
    }

    public static String getDefaultDownLoadPath() {
        if (FileUtils.checkSDStatus()) {
            return Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).getAbsolutePath() + File.separator;
        }
        return "";
    }

    public static String getDefaultDownLoadFileName(String url) {
        if (url == null || url.length() == 0) {
            return "";
        }
        int nameStart = url.lastIndexOf(47) + 1;
        return url.substring(nameStart);
    }

    public static String writeToFile(ResponseBody responseBody, File file, long start) throws Exception {
        return FileUtils.writeToFile(responseBody, file, start, null);
    }

    public static String writeToFile(ResponseBody responseBody, File file, long start, FileListener fileListener) throws Exception {
        int len;
        long sectionLength;
        LogSunmi.d("TAG", "writeToFile: ---------->" + start);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        BufferedRandomAccessFile randomAccessFile = null;
        InputStream inputStream = null;
        long range = start;
        long byteLength = 4096L;
        if (fileListener != null && (sectionLength = fileListener.getByte()) != -1L && byteLength > sectionLength) {
            byteLength = sectionLength;
        }
        long currentTime = SystemClock.elapsedRealtime();
        long temp = 0L;
        long speed = 0L;
        byte[] buf = new byte[(int)byteLength];
        inputStream = responseBody.byteStream();
        randomAccessFile = new BufferedRandomAccessFile(file, "rwd");
        randomAccessFile.seek(range);
        while ((len = inputStream.read(buf)) != -1) {
            boolean fileWhile;
            randomAccessFile.write(buf, 0, len);
            if (fileListener != null && (fileWhile = fileListener.fileWhile(buf, len))) {
                return "md5fail";
            }
            temp += (long)len;
            long diff = SystemClock.elapsedRealtime() - currentTime;
            if (diff <= 1000L) continue;
            speed = temp * 1000L / diff;
            LogSunmi.e("speed", "speed=" + speed + "   diff=" + diff + "  temp=" + temp);
            temp = 0L;
            currentTime = SystemClock.elapsedRealtime();
            if (fileListener == null) continue;
            fileListener.speed(speed);
        }
        if (randomAccessFile != null) {
            randomAccessFile.close();
        }
        if (inputStream != null) {
            inputStream.close();
        }
        return "complete";
    }

    public static String toHexString(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            sb.append(HEX_DIGITS[(b[i] & 0xF0) >>> 4]);
            sb.append(HEX_DIGITS[b[i] & 0xF]);
        }
        return sb.toString().toLowerCase();
    }

    public static void md5sum(final String path, Consumer<String> consumer) {
        Flowable.just((Object)1).map((Function)new Function<Integer, String>(){

            public String apply(@NotNull Integer integer) throws Exception {
                return FileUtils.md5sum(path);
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String md5sum(String path) {
        if (!new File(path).exists()) {
            return "";
        }
        FileInputStream fis = null;
        byte[] buffer = new byte[1024];
        try {
            int numRead;
            fis = new FileInputStream(path);
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            while ((numRead = ((InputStream)fis).read(buffer)) > 0) {
                md5.update(buffer, 0, numRead);
            }
            String string = FileUtils.toHexString(md5.digest());
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    ((InputStream)fis).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return "";
    }

    public static boolean mergeFiles(String filePath, String[] fpaths, String resultPath) {
        if (fpaths == null || fpaths.length < 1 || TextUtils.isEmpty((CharSequence)resultPath)) {
            return false;
        }
        if (fpaths.length == 1) {
            new File(fpaths[0]).renameTo(new File(resultPath));
            FileUtils.deleteFile(new File(filePath));
            return true;
        }
        File[] files = new File[fpaths.length];
        for (int i = 0; i < fpaths.length; ++i) {
            files[i] = new File(fpaths[i]);
            if (!TextUtils.isEmpty((CharSequence)fpaths[i]) && files[i].exists() && files[i].isFile()) continue;
            return false;
        }
        File resultFile = new File(resultPath);
        try {
            FileChannel resultFileChannel = new FileOutputStream(resultFile, true).getChannel();
            for (int i = 0; i < fpaths.length; ++i) {
                FileChannel blk = new FileInputStream(files[i]).getChannel();
                resultFileChannel.transferFrom(blk, resultFileChannel.size(), blk.size());
                blk.close();
            }
            resultFileChannel.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        FileUtils.deleteFile(new File(filePath));
        return true;
    }

    public static void renameFile(String filePath, String oldfileName, String newfileName) {
        String oldFileName = filePath + oldfileName;
        File oldFile = new File(oldFileName);
        String newFileName = filePath + newfileName;
        File newFile = new File(newFileName);
        if (oldFile.exists() && oldFile.isFile()) {
            oldFile.renameTo(newFile);
        }
    }

    public static void createParentDir(File file) {
        File parentPath = file.getParentFile();
        if (parentPath != null && !parentPath.exists()) {
            parentPath.mkdirs();
        }
    }

    public static long getFileLength(String filePath, int position) {
        long length = 0L;
        for (int i = 0; i <= position; ++i) {
            File file = new File(filePath + i + ".temp");
            length += file.length();
        }
        return length;
    }

    public static int checkSliceMD5(MessageDigest messageDigest, File file, int sliceSize, List<String> MD5) {
        int bufferSize = 1024;
        byte[] bytes = new byte[bufferSize];
        int validCount = 0;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            while (!MD5.isEmpty()) {
                int tmp;
                int n;
                for (tmp = sliceSize; (n = fileInputStream.read(bytes, 0, Math.min(tmp, bufferSize))) > 0 && tmp > 0; tmp -= n) {
                    messageDigest.update(bytes, 0, n);
                }
                if (tmp == 0 && FileUtils.toHexString(messageDigest.digest()).equalsIgnoreCase(MD5.get(validCount))) {
                    ++validCount;
                    if (n >= 0) continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return validCount;
    }

    public static long getFileSize(File f) {
        long size = 0L;
        File[] flist = f.listFiles();
        if (flist != null) {
            for (int i = 0; i < flist.length; ++i) {
                if (flist[i].isDirectory()) {
                    size += FileUtils.getFileSize(flist[i]);
                    continue;
                }
                size += flist[i].length();
            }
        }
        return size;
    }

    public static boolean deleteFile(File file) {
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                FileUtils.deleteFile(f);
            }
        }
        return file.delete();
    }
}

