/*
 * Decompiled with CFR 0.152.
 */
package com.sunmilib.util;

import android.util.Log;
import com.sunmilib.service.HttpConfig;

public class LogSunmi {
    private static final int VERBOSE = 1;
    private static final int DEBUG = 2;
    private static final int INFO = 3;
    private static final int WARN = 4;
    private static final int ERROR = 5;
    private static final int NO = 6;
    private static int LEVEL = 1;

    public static void v(String TAG, String msg) {
        if (LogSunmi.isTagLoggable(TAG, 2)) {
            LogSunmi.MyLog(1, TAG, msg);
        }
    }

    public static void d(String TAG, String msg) {
        if (LogSunmi.isTagLoggable(TAG, 3)) {
            LogSunmi.MyLog(2, TAG, msg);
        }
    }

    public static void i(String TAG, String msg) {
        if (LogSunmi.isTagLoggable(TAG, 4)) {
            LogSunmi.MyLog(3, TAG, msg);
        }
    }

    public static void w(String TAG, String msg) {
        if (LogSunmi.isTagLoggable(TAG, 5)) {
            LogSunmi.MyLog(4, TAG, msg);
        }
    }

    public static void e(String TAG, String msg) {
        if (LogSunmi.isTagLoggable(TAG, 6)) {
            LogSunmi.MyLog(5, TAG, msg);
        }
    }

    private static void MyLog(int type, String TAG, String msg) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int index = 4;
        String className = stackTrace[index].getFileName();
        String methodName = stackTrace[index].getMethodName();
        int lineNumber = stackTrace[index].getLineNumber();
        methodName = methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ (").append(className).append(":").append(lineNumber).append(")#").append(methodName).append(" ] ");
        stringBuilder.append(msg);
        String logStr = stringBuilder.toString();
        switch (type) {
            case 1: {
                Log.v((String)TAG, (String)logStr);
                break;
            }
            case 2: {
                Log.d((String)TAG, (String)logStr);
                break;
            }
            case 3: {
                Log.i((String)TAG, (String)logStr);
                break;
            }
            case 4: {
                Log.w((String)TAG, (String)logStr);
                break;
            }
            case 5: {
                Log.e((String)TAG, (String)logStr);
                break;
            }
        }
    }

    private static boolean isTagLoggable(String tag, int level) {
        return Log.isLoggable((String)tag, (int)level) || HttpConfig.getInstance().isDebug();
    }
}

