/*
 * Decompiled with CFR 0.152.
 */
package com.sunmilib.util;

import com.sunmilib.util.LogSunmi;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Utils {
    public static final String TAG = "MD5Utils";
    protected static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    protected static MessageDigest messagedigest = null;

    public static String md5(String string) {
        byte[] hash;
        try {
            hash = MessageDigest.getInstance("MD5").digest(string.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Huh, MD5 should be supported?", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Huh, UTF-8 should be supported?", e);
        }
        StringBuilder hex = new StringBuilder(hash.length * 2);
        for (byte b : hash) {
            if ((b & 0xFF) < 16) {
                hex.append("0");
            }
            hex.append(Integer.toHexString(b & 0xFF));
        }
        return hex.toString();
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] >> 4 & 0xF;
            String hv = Integer.toHexString(v);
            stringBuilder.append(hv);
            v = src[i] & 0xF;
            hv = Integer.toHexString(v);
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static String getFileMD5String(File file) {
        FileInputStream fis;
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return "";
        }
        byte[] buffer = new byte[1024];
        int numRead = 0;
        try {
            while ((numRead = ((InputStream)fis).read(buffer)) > 0) {
                messagedigest.update(buffer, 0, numRead);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
        try {
            ((InputStream)fis).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return MD5Utils.bufferToHex(messagedigest.digest());
    }

    private static String bufferToHex(byte[] bytes) {
        return MD5Utils.bufferToHex(bytes, 0, bytes.length);
    }

    private static String bufferToHex(byte[] bytes, int m, int n) {
        StringBuffer stringbuffer = new StringBuffer(2 * n);
        int k = m + n;
        for (int l = m; l < k; ++l) {
            MD5Utils.appendHexPair(bytes[l], stringbuffer);
        }
        return stringbuffer.toString();
    }

    private static void appendHexPair(byte bt, StringBuffer stringbuffer) {
        char c0 = hexDigits[(bt & 0xF0) >> 4];
        char c1 = hexDigits[bt & 0xF];
        stringbuffer.append(c0);
        stringbuffer.append(c1);
    }

    static {
        try {
            messagedigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsaex) {
            LogSunmi.e(TAG, MD5Utils.class.getName() + "\u521d\u59cb\u5316\u5931\u8d25\uff0cMessageDigest\u4e0d\u652f\u6301MD5Util\u3002");
            nsaex.printStackTrace();
        }
    }
}

