/*
 * The MIT License
 * Copyright (c) 2012 Microsoft Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package microsoft.exchange.webservices.data.core;

/**
 * XML element names.
 */
public class XmlElementNames {

  /**
   * The Constant AllProperties.
   */
  public static final String AllProperties = "AllProperties";

  /**
   * The Constant ParentFolderIds.
   */
  public static final String ParentFolderIds = "ParentFolderIds";

  /**
   * The Constant DistinguishedFolderId.
   */
  public static final String DistinguishedFolderId = "DistinguishedFolderId";

  /**
   * The Constant ItemId.
   */
  public static final String ItemId = "ItemId";

  /**
   * The Constant ItemIds.
   */
  public static final String ItemIds = "ItemIds";

  /**
   * The Constant FolderId.
   */
  public static final String FolderId = "FolderId";

  /**
   * The Constant FolderIds.
   */
  public static final String FolderIds = "FolderIds";

  /**
   * The Constant OccurrenceItemId.
   */
  public static final String OccurrenceItemId = "OccurrenceItemId";

  /**
   * The Constant RecurringMasterItemId.
   */
  public static final String RecurringMasterItemId = "RecurringMasterItemId";

  /**
   * The Constant ItemShape.
   */
  public static final String ItemShape = "ItemShape";

  /**
   * The Constant FolderShape.
   */
  public static final String FolderShape = "FolderShape";

  /**
   * The Constant BaseShape.
   */
  public static final String BaseShape = "BaseShape";

  /**
   * The Constant IndexedPageItemView.
   */
  public static final String IndexedPageItemView = "IndexedPageItemView";

  /**
   * The Constant IndexedPageFolderView.
   */
  public static final String IndexedPageFolderView = "IndexedPageFolderView";

  /**
   * The Constant FractionalPageItemView.
   */
  public static final String FractionalPageItemView = "FractionalPageItemView";

  /**
   * The Constant FractionalPageFolderView.
   */
  public static final String FractionalPageFolderView =
      "FractionalPageFolderView";

  /**
   * The Constant ResponseCode.
   */
  public static final String ResponseCode = "ResponseCode";

  /**
   * The Constant RootFolder.
   */
  public static final String RootFolder = "RootFolder";

  /**
   * The Constant Folder.
   */
  public static final String Folder = "Folder";

  /**
   * The Constant ContactsFolder.
   */
  public static final String ContactsFolder = "ContactsFolder";

  /**
   * The Constant TasksFolder.
   */
  public static final String TasksFolder = "TasksFolder";

  /**
   * The Constant SearchFolder.
   */
  public static final String SearchFolder = "SearchFolder";

  /**
   * The Constant Folders.
   */
  public static final String Folders = "Folders";

  /**
   * The Constant Item.
   */
  public static final String Item = "Item";

  /**
   * The Constant Items.
   */
  public static final String Items = "Items";

  /**
   * The Constant Message.
   */
  public static final String Message = "Message";

  /**
   * The Constant Mailbox.
   */
  public static final String Mailbox = "Mailbox";

  /**
   * The Constant Body.
   */
  public static final String Body = "Body";

  /**
   * The Constant From.
   */
  public static final String From = "From";

  /**
   * The Constant Sender.
   */
  public static final String Sender = "Sender";

  /**
   * The Constant Name.
   */
  public static final String Name = "Name";

  /**
   * The Constant Address.
   */
  public static final String Address = "Address";

  /**
   * The Constant EmailAddress.
   */
  public static final String EmailAddress = "EmailAddress";

  /**
   * The Constant RoutingType.
   */
  public static final String RoutingType = "RoutingType";

  /**
   * The Constant MailboxType.
   */
  public static final String MailboxType = "MailboxType";

  /**
   * The Constant ToRecipients.
   */
  public static final String ToRecipients = "ToRecipients";

  /**
   * The Constant CcRecipients.
   */
  public static final String CcRecipients = "CcRecipients";

  /**
   * The Constant BccRecipients.
   */
  public static final String BccRecipients = "BccRecipients";

  /**
   * The Constant ReplyTo.
   */
  public static final String ReplyTo = "ReplyTo";

  /**
   * The Constant ConversationTopic.
   */
  public static final String ConversationTopic = "ConversationTopic";

  /**
   * The Constant ConversationIndex.
   */
  public static final String ConversationIndex = "ConversationIndex";

  /**
   * The Constant IsDeliveryReceiptRequested.
   */
  public static final String IsDeliveryReceiptRequested =
      "IsDeliveryReceiptRequested";

  /**
   * The Constant IsRead.
   */
  public static final String IsRead = "IsRead";

  /**
   * The Constant IsReadReceiptRequested.
   */
  public static final String IsReadReceiptRequested = "IsReadReceiptRequested";

  /**
   * The Constant IsResponseRequested.
   */
  public static final String IsResponseRequested = "IsResponseRequested";

  /**
   * The Constant InternetMessageId.
   */
  public static final String InternetMessageId = "InternetMessageId";

  /**
   * The Constant References.
   */
  public static final String References = "References";

  /**
   * The Constant ParentItemId.
   */
  public static final String ParentItemId = "ParentItemId";

  /**
   * The Constant ParentFolderId.
   */
  public static final String ParentFolderId = "ParentFolderId";

  /**
   * The Constant ChildFolderCount.
   */
  public static final String ChildFolderCount = "ChildFolderCount";

  /**
   * The Constant DisplayName.
   */
  public static final String DisplayName = "DisplayName";

  /**
   * The Constant TotalCount.
   */
  public static final String TotalCount = "TotalCount";

  /**
   * The Constant ItemClass.
   */
  public static final String ItemClass = "ItemClass";

  /**
   * The Constant FolderClass.
   */
  public static final String FolderClass = "FolderClass";

  /**
   * The Constant Subject.
   */
  public static final String Subject = "Subject";

  /**
   * The Constant MimeContent.
   */
  public static final String MimeContent = "MimeContent";

  /**
   * The Constant Sensitivity.
   */
  public static final String Sensitivity = "Sensitivity";

  /**
   * The Constant Attachments.
   */
  public static final String Attachments = "Attachments";

  /**
   * The Constant DateTimeReceived.
   */
  public static final String DateTimeReceived = "DateTimeReceived";

  /**
   * The Constant Size.
   */
  public static final String Size = "Size";

  /**
   * The Constant Categories.
   */
  public static final String Categories = "Categories";

  /**
   * The Constant Importance.
   */
  public static final String Importance = "Importance";

  /**
   * The Constant InReplyTo.
   */
  public static final String InReplyTo = "InReplyTo";

  /**
   * The Constant IsSubmitted.
   */
  public static final String IsSubmitted = "IsSubmitted";

  /**
   * The Constant IsAssociated.
   */
  public static final String IsAssociated = "IsAssociated";

  /**
   * The Constant IsDraft.
   */
  public static final String IsDraft = "IsDraft";

  /**
   * The Constant IsFromMe.
   */
  public static final String IsFromMe = "IsFromMe";

  /**
   * The Constant IsResend.
   */
  public static final String IsResend = "IsResend";

  /**
   * The Constant IsUnmodified.
   */
  public static final String IsUnmodified = "IsUnmodified";

  /**
   * The Constant InternetMessageHeader.
   */
  public static final String InternetMessageHeader = "InternetMessageHeader";

  /**
   * The Constant InternetMessageHeaders.
   */
  public static final String InternetMessageHeaders = "InternetMessageHeaders";

  /**
   * The Constant DateTimeSent.
   */
  public static final String DateTimeSent = "DateTimeSent";

  /**
   * The Constant DateTimeCreated.
   */
  public static final String DateTimeCreated = "DateTimeCreated";

  /**
   * The Constant ResponseObjects.
   */
  public static final String ResponseObjects = "ResponseObjects";

  /**
   * The Constant ReminderDueBy.
   */
  public static final String ReminderDueBy = "ReminderDueBy";

  /**
   * The Constant ReminderIsSet.
   */
  public static final String ReminderIsSet = "ReminderIsSet";

  /**
   * The Constant ReminderMinutesBeforeStart.
   */
  public static final String ReminderMinutesBeforeStart =
      "ReminderMinutesBeforeStart";

  /**
   * The Constant DisplayCc.
   */
  public static final String DisplayCc = "DisplayCc";

  /**
   * The Constant DisplayTo.
   */
  public static final String DisplayTo = "DisplayTo";

  /**
   * The Constant HasAttachments.
   */
  public static final String HasAttachments = "HasAttachments";

  /**
   * The Constant ExtendedProperty.
   */
  public static final String ExtendedProperty = "ExtendedProperty";

  /**
   * The Constant Culture.
   */
  public static final String Culture = "Culture";

  /**
   * The Constant FileAttachment.
   */
  public static final String FileAttachment = "FileAttachment";

  /**
   * The Constant ItemAttachment.
   */
  public static final String ItemAttachment = "ItemAttachment";

  /**
   * The Constant AttachmentIds.
   */
  public static final String AttachmentIds = "AttachmentIds";

  /**
   * The Constant AttachmentId.
   */
  public static final String AttachmentId = "AttachmentId";

  /**
   * The Constant ContentType.
   */
  public static final String ContentType = "ContentType";

  /**
   * The Constant ContentLocation.
   */
  public static final String ContentLocation = "ContentLocation";

  /**
   * The Constant ContentId.
   */
  public static final String ContentId = "ContentId";

  /**
   * The Constant Content.
   */
  public static final String Content = "Content";

  /**
   * The Constant SavedItemFolderId.
   */
  public static final String SavedItemFolderId = "SavedItemFolderId";

  /**
   * The Constant MessageText.
   */
  public static final String MessageText = "MessageText";

  /**
   * The Constant DescriptiveLinkKey.
   */
  public static final String DescriptiveLinkKey = "DescriptiveLinkKey";

  /**
   * The Constant ItemChange.
   */
  public static final String ItemChange = "ItemChange";

  /**
   * The Constant ItemChanges.
   */
  public static final String ItemChanges = "ItemChanges";

  /**
   * The Constant FolderChange.
   */
  public static final String FolderChange = "FolderChange";

  /**
   * The Constant FolderChanges.
   */
  public static final String FolderChanges = "FolderChanges";

  /**
   * The Constant Updates.
   */
  public static final String Updates = "Updates";

  /**
   * The Constant AppendToItemField.
   */
  public static final String AppendToItemField = "AppendToItemField";

  /**
   * The Constant SetItemField.
   */
  public static final String SetItemField = "SetItemField";

  /**
   * The Constant DeleteItemField.
   */
  public static final String DeleteItemField = "DeleteItemField";

  /**
   * The Constant SetFolderField.
   */
  public static final String SetFolderField = "SetFolderField";

  /**
   * The Constant DeleteFolderField.
   */
  public static final String DeleteFolderField = "DeleteFolderField";

  /**
   * The Constant FieldURI.
   */
  public static final String FieldURI = "FieldURI";

  /**
   * The Constant RootItemId.
   */
  public static final String RootItemId = "RootItemId";

  /**
   * The Constant ReferenceItemId.
   */
  public static final String ReferenceItemId = "ReferenceItemId";

  /**
   * The Constant NewBodyContent.
   */
  public static final String NewBodyContent = "NewBodyContent";

  /**
   * The Constant ReplyToItem.
   */
  public static final String ReplyToItem = "ReplyToItem";

  /**
   * The Constant ReplyAllToItem.
   */
  public static final String ReplyAllToItem = "ReplyAllToItem";

  /**
   * The Constant ForwardItem.
   */
  public static final String ForwardItem = "ForwardItem";

  /**
   * The Constant AcceptItem.
   */
  public static final String AcceptItem = "AcceptItem";

  /**
   * The Constant TentativelyAcceptItem.
   */
  public static final String TentativelyAcceptItem = "TentativelyAcceptItem";

  /**
   * The Constant DeclineItem.
   */
  public static final String DeclineItem = "DeclineItem";

  /**
   * The Constant CancelCalendarItem.
   */
  public static final String CancelCalendarItem = "CancelCalendarItem";

  /**
   * The Constant RemoveItem.
   */
  public static final String RemoveItem = "RemoveItem";

  /**
   * The Constant SuppressReadReceipt.
   */
  public static final String SuppressReadReceipt = "SuppressReadReceipt";

  /**
   * The Constant String.
   */
  public static final String String = "String";

  /**
   * The Constant Start.
   */
  public static final String Start = "Start";

  /**
   * The Constant End.
   */
  public static final String End = "End";

  /**
   * The Constant ProposedStart.
   */
  public static final String ProposedStart = "ProposedStart";

  /**
   * The Constant End.
   */
  public static final String ProposedEnd = "ProposedEnd";

  /**
   * The Constant OriginalStart.
   */
  public static final String OriginalStart = "OriginalStart";

  /**
   * The Constant IsAllDayEvent.
   */
  public static final String IsAllDayEvent = "IsAllDayEvent";

  /**
   * The Constant LegacyFreeBusyStatus.
   */
  public static final String LegacyFreeBusyStatus = "LegacyFreeBusyStatus";

  /**
   * The Constant Location.
   */
  public static final String Location = "Location";

  /**
   * The Constant When.
   */
  public static final String When = "When";

  /**
   * The Constant IsMeeting.
   */
  public static final String IsMeeting = "IsMeeting";

  /**
   * The Constant IsCancelled.
   */
  public static final String IsCancelled = "IsCancelled";

  /**
   * The Constant IsRecurring.
   */
  public static final String IsRecurring = "IsRecurring";

  /**
   * The Constant IsRecurring.
   */
  public static final String IsOrganizer = "IsOrganizer";

  /**
   * The Constant MeetingRequestWasSent.
   */
  public static final String MeetingRequestWasSent = "MeetingRequestWasSent";

  /**
   * The Constant CalendarItemType.
   */
  public static final String CalendarItemType = "CalendarItemType";

  /**
   * The Constant MyResponseType.
   */
  public static final String MyResponseType = "MyResponseType";

  /**
   * The Constant Organizer.
   */
  public static final String Organizer = "Organizer";

  /**
   * The Constant RequiredAttendees.
   */
  public static final String RequiredAttendees = "RequiredAttendees";

  /**
   * The Constant OptionalAttendees.
   */
  public static final String OptionalAttendees = "OptionalAttendees";

  /**
   * The Constant Resources.
   */
  public static final String Resources = "Resources";

  /**
   * The Constant ConflictingMeetingCount.
   */
  public static final String ConflictingMeetingCount =
      "ConflictingMeetingCount";

  /**
   * The Constant AdjacentMeetingCount.
   */
  public static final String AdjacentMeetingCount = "AdjacentMeetingCount";

  /**
   * The Constant ConflictingMeetings.
   */
  public static final String ConflictingMeetings = "ConflictingMeetings";

  /**
   * The Constant AdjacentMeetings.
   */
  public static final String AdjacentMeetings = "AdjacentMeetings";

  /**
   * The Constant Duration.
   */
  public static final String Duration = "Duration";

  /**
   * The Constant TimeZone.
   */
  public static final String TimeZone = "TimeZone";

  /**
   * The Constant AppointmentReplyTime.
   */
  public static final String AppointmentReplyTime = "AppointmentReplyTime";

  /**
   * The Constant AppointmentSequenceNumber.
   */
  public static final String AppointmentSequenceNumber =
      "AppointmentSequenceNumber";

  /**
   * The Constant AppointmentState.
   */
  public static final String AppointmentState = "AppointmentState";

  /**
   * The Constant Recurrence.
   */
  public static final String Recurrence = "Recurrence";

  /**
   * The Constant FirstOccurrence.
   */
  public static final String FirstOccurrence = "FirstOccurrence";

  /**
   * The Constant LastOccurrence.
   */
  public static final String LastOccurrence = "LastOccurrence";

  /**
   * The Constant ModifiedOccurrences.
   */
  public static final String ModifiedOccurrences = "ModifiedOccurrences";

  /**
   * The Constant DeletedOccurrences.
   */
  public static final String DeletedOccurrences = "DeletedOccurrences";

  /**
   * The Constant MeetingTimeZone.
   */
  public static final String MeetingTimeZone = "MeetingTimeZone";

  /**
   * The Constant ConferenceType.
   */
  public static final String ConferenceType = "ConferenceType";

  /**
   * The Constant AllowNewTimeProposal.
   */
  public static final String AllowNewTimeProposal = "AllowNewTimeProposal";

  /**
   * The Constant IsOnlineMeeting.
   */
  public static final String IsOnlineMeeting = "IsOnlineMeeting";

  /**
   * The Constant MeetingWorkspaceUrl.
   */
  public static final String MeetingWorkspaceUrl = "MeetingWorkspaceUrl";

  /**
   * The Constant NetShowUrl.
   */
  public static final String NetShowUrl = "NetShowUrl";

  /**
   * The Constant CalendarItem.
   */
  public static final String CalendarItem = "CalendarItem";

  /**
   * The Constant CalendarFolder.
   */
  public static final String CalendarFolder = "CalendarFolder";

  /**
   * The Constant Attendee.
   */
  public static final String Attendee = "Attendee";

  /**
   * The Constant ResponseType.
   */
  public static final String ResponseType = "ResponseType";

  /**
   * The Constant LastResponseTime.
   */
  public static final String LastResponseTime = "LastResponseTime";

  /**
   * The Constant Occurrence.
   */
  public static final String Occurrence = "Occurrence";

  /**
   * The Constant DeletedOccurrence.
   */
  public static final String DeletedOccurrence = "DeletedOccurrence";

  /**
   * The Constant RelativeYearlyRecurrence.
   */
  public static final String RelativeYearlyRecurrence =
      "RelativeYearlyRecurrence";

  /**
   * The Constant AbsoluteYearlyRecurrence.
   */
  public static final String AbsoluteYearlyRecurrence =
      "AbsoluteYearlyRecurrence";

  /**
   * The Constant RelativeMonthlyRecurrence.
   */
  public static final String RelativeMonthlyRecurrence =
      "RelativeMonthlyRecurrence";

  /**
   * The Constant AbsoluteMonthlyRecurrence.
   */
  public static final String AbsoluteMonthlyRecurrence =
      "AbsoluteMonthlyRecurrence";

  /**
   * The Constant WeeklyRecurrence.
   */
  public static final String WeeklyRecurrence = "WeeklyRecurrence";

  /**
   * The Constant DailyRecurrence.
   */
  public static final String DailyRecurrence = "DailyRecurrence";

  /**
   * The Constant DailyRegeneration.
   */
  public static final String DailyRegeneration = "DailyRegeneration";

  public static final String Data = "Data";

  /**
   * The Constant WeeklyRegeneration.
   */
  public static final String WeeklyRegeneration = "WeeklyRegeneration";

  /**
   * The Constant MonthlyRegeneration.
   */
  public static final String MonthlyRegeneration = "MonthlyRegeneration";

  /**
   * The Constant YearlyRegeneration.
   */
  public static final String YearlyRegeneration = "YearlyRegeneration";

  /**
   * The Constant NoEndRecurrence.
   */
  public static final String NoEndRecurrence = "NoEndRecurrence";

  /**
   * The Constant EndDateRecurrence.
   */
  public static final String EndDateRecurrence = "EndDateRecurrence";

  /**
   * The Constant NumberedRecurrence.
   */
  public static final String NumberedRecurrence = "NumberedRecurrence";

  /**
   * The Constant Interval.
   */
  public static final String Interval = "Interval";

  /**
   * The Constant DayOfMonth.
   */
  public static final String DayOfMonth = "DayOfMonth";

  /**
   * The Constant DayOfWeek.
   */
  public static final String DayOfWeek = "DayOfWeek";

  /**
   * The Constant DaysOfWeek.
   */
  public static final String DaysOfWeek = "DaysOfWeek";

  /**
   * The Constant DayOfWeekIndex.
   */
  public static final String DayOfWeekIndex = "DayOfWeekIndex";

  /**
   * The Constant Month.
   */
  public static final String Month = "Month";

  /**
   * The Constant StartDate.
   */
  public static final String StartDate = "StartDate";

  /**
   * The Constant EndDate.
   */
  public static final String EndDate = "EndDate";

  /**
   * The Constant StartTime.
   */
  public static final String StartTime = "StartTime";

  /**
   * The Constant EndTime.
   */
  public static final String EndTime = "EndTime";

  /**
   * The Constant NumberOfOccurrences.
   */
  public static final String NumberOfOccurrences = "NumberOfOccurrences";

  /**
   * The Constant AssociatedCalendarItemId.
   */
  public static final String AssociatedCalendarItemId =
      "AssociatedCalendarItemId";

  /**
   * The Constant IsDelegated.
   */
  public static final String IsDelegated = "IsDelegated";

  /**
   * The Constant IsOutOfDate.
   */
  public static final String IsOutOfDate = "IsOutOfDate";

  /**
   * The Constant HasBeenProcessed.
   */
  public static final String HasBeenProcessed = "HasBeenProcessed";

  /**
   * The Constant MeetingMessage.
   */
  public static final String MeetingMessage = "MeetingMessage";

  /**
   * The Constant FileAs.
   */
  public static final String FileAs = "FileAs";

  /**
   * The Constant FileAsMapping.
   */
  public static final String FileAsMapping = "FileAsMapping";

  /**
   * The Constant GivenName.
   */
  public static final String GivenName = "GivenName";

  /**
   * The Constant Initials.
   */
  public static final String Initials = "Initials";

  /**
   * The Constant MiddleName.
   */
  public static final String MiddleName = "MiddleName";

  /**
   * The Constant NickName.
   */
  public static final String NickName = "Nickname";

  /**
   * The Constant CompleteName.
   */
  public static final String CompleteName = "CompleteName";

  /**
   * The Constant CompanyName.
   */
  public static final String CompanyName = "CompanyName";

  /**
   * The Constant EmailAddresses.
   */
  public static final String EmailAddresses = "EmailAddresses";

  /**
   * The Constant PhysicalAddresses.
   */
  public static final String PhysicalAddresses = "PhysicalAddresses";

  /**
   * The Constant PhoneNumbers.
   */
  public static final String PhoneNumbers = "PhoneNumbers";

  /**
   * The Constant PhoneNumber.
   */
  public static final String PhoneNumber = "PhoneNumber";

  /**
   * The Constant AssistantName.
   */
  public static final String AssistantName = "AssistantName";

  /**
   * The Constant Birthday.
   */
  public static final String Birthday = "Birthday";

  /**
   * The Constant BusinessHomePage.
   */
  public static final String BusinessHomePage = "BusinessHomePage";

  /**
   * The Constant Children.
   */
  public static final String Children = "Children";

  /**
   * The Constant Companies.
   */
  public static final String Companies = "Companies";

  /**
   * The Constant ContactSource.
   */
  public static final String ContactSource = "ContactSource";

  /**
   * The Constant Department.
   */
  public static final String Department = "Department";

  /**
   * The Constant Generation.
   */
  public static final String Generation = "Generation";

  /**
   * The Constant ImAddresses.
   */
  public static final String ImAddresses = "ImAddresses";

  /**
   * The Constant ImAddress.
   */
  public static final String ImAddress = "ImAddress";

  /**
   * The Constant JobTitle.
   */
  public static final String JobTitle = "JobTitle";

  /**
   * The Constant Manager.
   */
  public static final String Manager = "Manager";

  /**
   * The Constant Mileage.
   */
  public static final String Mileage = "Mileage";

  /**
   * The Constant OfficeLocation.
   */
  public static final String OfficeLocation = "OfficeLocation";

  /**
   * The Constant PostalAddressIndex.
   */
  public static final String PostalAddressIndex = "PostalAddressIndex";

  /**
   * The Constant Profession.
   */
  public static final String Profession = "Profession";

  /**
   * The Constant SpouseName.
   */
  public static final String SpouseName = "SpouseName";

  /**
   * The Constant Surname.
   */
  public static final String Surname = "Surname";

  /**
   * The Constant WeddingAnniversary.
   */
  public static final String WeddingAnniversary = "WeddingAnniversary";

  /**
   * The Constant HasPicture.
   */
  public static final String HasPicture = "HasPicture";

  /**
   * The Constant Title.
   */
  public static final String Title = "Title";

  /**
   * The Constant FirstName.
   */
  public static final String FirstName = "FirstName";

  /**
   * The Constant LastName.
   */
  public static final String LastName = "LastName";

  /**
   * The Constant Suffix.
   */
  public static final String Suffix = "Suffix";

  /**
   * The Constant FullName.
   */
  public static final String FullName = "FullName";

  /**
   * The Constant YomiFirstName.
   */
  public static final String YomiFirstName = "YomiFirstName";

  /**
   * The Constant YomiLastName.
   */
  public static final String YomiLastName = "YomiLastName";

  /**
   * The Constant Contact.
   */
  public static final String Contact = "Contact";

  /**
   * The Constant Entry.
   */
  public static final String Entry = "Entry";

  /**
   * The Constant Street.
   */
  public static final String Street = "Street";

  /**
   * The Constant City.
   */
  public static final String City = "City";

  /**
   * The Constant State.
   */
  public static final String State = "State";

  /**
   * The Constant CountryOrRegion.
   */
  public static final String CountryOrRegion = "CountryOrRegion";

  /**
   * The Constant PostalCode.
   */
  public static final String PostalCode = "PostalCode";

  /**
   * The Constant Members.
   */
  public static final String Members = "Members";

  /**
   * The Constant Member.
   */
  public static final String Member = "Member";

  /**
   * The Constant AdditionalProperties.
   */
  public static final String AdditionalProperties = "AdditionalProperties";

  /**
   * The Constant ExtendedFieldURI.
   */
  public static final String ExtendedFieldURI = "ExtendedFieldURI";

  /**
   * The Constant Value.
   */
  public static final String Value = "Value";

  /**
   * The Constant Values.
   */
  public static final String Values = "Values";

  /**
   * The Constant ToFolderId.
   */
  public static final String ToFolderId = "ToFolderId";

  /**
   * The Constant ActualWork.
   */
  public static final String ActualWork = "ActualWork";

  /**
   * The Constant AssignedTime.
   */
  public static final String AssignedTime = "AssignedTime";

  /**
   * The Constant BillingInformation.
   */
  public static final String BillingInformation = "BillingInformation";

  /**
   * The Constant ChangeCount.
   */
  public static final String ChangeCount = "ChangeCount";

  /**
   * The Constant CompleteDate.
   */
  public static final String CompleteDate = "CompleteDate";

  /**
   * The Constant Contacts.
   */
  public static final String Contacts = "Contacts";

  /**
   * The Constant DelegationState.
   */
  public static final String DelegationState = "DelegationState";

  /**
   * The Constant Delegator.
   */
  public static final String Delegator = "Delegator";

  /**
   * The Constant DueDate.
   */
  public static final String DueDate = "DueDate";

  /**
   * The Constant IsAssignmentEditable.
   */
  public static final String IsAssignmentEditable = "IsAssignmentEditable";

  /**
   * The Constant IsComplete.
   */
  public static final String IsComplete = "IsComplete";

  /**
   * The Constant IsTeamTask.
   */
  public static final String IsTeamTask = "IsTeamTask";

  /**
   * The Constant Owner.
   */
  public static final String Owner = "Owner";

  /**
   * The Constant PercentComplete.
   */
  public static final String PercentComplete = "PercentComplete";

  /**
   * The Constant Status.
   */
  public static final String Status = "Status";

  /**
   * The Constant StatusDescription.
   */
  public static final String StatusDescription = "StatusDescription";

  /**
   * The Constant TotalWork.
   */
  public static final String TotalWork = "TotalWork";

  /**
   * The Constant Task.
   */
  public static final String Task = "Task";

  /**
   * The Constant MailboxCulture.
   */
  public static final String MailboxCulture = "MailboxCulture";

  /**
   * The Constant MeetingRequestType.
   */
  public static final String MeetingRequestType = "MeetingRequestType";

  /**
   * The Constant IntendedFreeBusyStatus.
   */
  public static final String IntendedFreeBusyStatus = "IntendedFreeBusyStatus";

  /**
   * The Constant MeetingRequest.
   */
  public static final String MeetingRequest = "MeetingRequest";

  /**
   * The Constant MeetingResponse.
   */
  public static final String MeetingResponse = "MeetingResponse";

  /**
   * The Constant MeetingCancellation.
   */
  public static final String MeetingCancellation = "MeetingCancellation";

  /**
   * The Constant BaseOffset.
   */
  public static final String BaseOffset = "BaseOffset";

  /**
   * The Constant Offset.
   */
  public static final String Offset = "Offset";

  /**
   * The Constant Standard.
   */
  public static final String Standard = "Standard";

  /**
   * The Constant Daylight.
   */
  public static final String Daylight = "Daylight";

  /**
   * The Constant Time.
   */
  public static final String Time = "Time";

  /**
   * The Constant AbsoluteDate.
   */
  public static final String AbsoluteDate = "AbsoluteDate";

  /**
   * The Constant UnresolvedEntry.
   */
  public static final String UnresolvedEntry = "UnresolvedEntry";

  /**
   * The Constant ResolutionSet.
   */
  public static final String ResolutionSet = "ResolutionSet";

  /**
   * The Constant Resolution.
   */
  public static final String Resolution = "Resolution";

  /**
   * The Constant DistributionList.
   */
  public static final String DistributionList = "DistributionList";

  /**
   * The Constant DLExpansion.
   */
  public static final String DLExpansion = "DLExpansion";

  /**
   * The Constant IndexedFieldURI.
   */
  public static final String IndexedFieldURI = "IndexedFieldURI";

  /**
   * The Constant PullSubscriptionRequest.
   */
  public static final String PullSubscriptionRequest =
      "PullSubscriptionRequest";

  /**
   * The Constant PushSubscriptionRequest.
   */
  public static final String PushSubscriptionRequest =
      "PushSubscriptionRequest";

  /**
   * The Constant StreamingSubscriptionRequest.
   */
  public static final String StreamingSubscriptionRequest =
      "StreamingSubscriptionRequest";
  /**
   * The Constant EventTypes.
   */
  public static final String EventTypes = "EventTypes";

  /**
   * The Constant EventType.
   */
  public static final String EventType = "EventType";

  /**
   * The Constant Timeout.
   */
  public static final String Timeout = "Timeout";

  /**
   * The Constant Watermark.
   */
  public static final String Watermark = "Watermark";

  /**
   * The Constant SubscriptionId.
   */
  public static final String SubscriptionId = "SubscriptionId";

  /**
   * The Constant SubscriptionId.
   */
  public static final String SubscriptionIds = "SubscriptionIds";

  /**
   * The Constant StatusFrequency.
   */
  public static final String StatusFrequency = "StatusFrequency";

  /**
   * The Constant URL.
   */
  public static final String URL = "URL";

  /**
   * The Constant Notification.
   */
  public static final String Notification = "Notification";

  /**
   * The Constant Notifications.
   */
  public static final String Notifications = "Notifications";

  /**
   * The Constant PreviousWatermark.
   */
  public static final String PreviousWatermark = "PreviousWatermark";

  /**
   * The Constant MoreEvents.
   */
  public static final String MoreEvents = "MoreEvents";

  /**
   * The Constant TimeStamp.
   */
  public static final String TimeStamp = "TimeStamp";

  /**
   * The Constant UnreadCount.
   */
  public static final String UnreadCount = "UnreadCount";

  /**
   * The Constant OldParentFolderId.
   */
  public static final String OldParentFolderId = "OldParentFolderId";

  /**
   * The Constant CopiedEvent.
   */
  public static final String CopiedEvent = "CopiedEvent";

  /**
   * The Constant CreatedEvent.
   */
  public static final String CreatedEvent = "CreatedEvent";

  /**
   * The Constant DeletedEvent.
   */
  public static final String DeletedEvent = "DeletedEvent";

  /**
   * The Constant ModifiedEvent.
   */
  public static final String ModifiedEvent = "ModifiedEvent";

  /**
   * The Constant MovedEvent.
   */
  public static final String MovedEvent = "MovedEvent";

  /**
   * The Constant NewMailEvent.
   */
  public static final String NewMailEvent = "NewMailEvent";

  /**
   * The Constant StatusEvent.
   */
  public static final String StatusEvent = "StatusEvent";

  /**
   * The Constant FreeBusyChangedEvent.
   */
  public static final String FreeBusyChangedEvent = "FreeBusyChangedEvent";

  /**
   * The Constant ExchangeImpersonation.
   */
  public static final String ExchangeImpersonation = "ExchangeImpersonation";

  /**
   * The Constant ConnectingSID.
   */
  public static final String ConnectingSID = "ConnectingSID";

  /**
   * The Constant SyncFolderId.
   */
  public static final String SyncFolderId = "SyncFolderId";

  /**
   * The Constant SyncScope.
   */
  public static final String SyncScope = "SyncScope";

  /**
   * The Constant SyncState.
   */
  public static final String SyncState = "SyncState";

  /**
   * The Constant Ignore.
   */
  public static final String Ignore = "Ignore";

  /**
   * The Constant MaxChangesReturned.
   */
  public static final String MaxChangesReturned = "MaxChangesReturned";

  /**
   * The Constant Changes.
   */
  public static final String Changes = "Changes";

  /**
   * The Constant IncludesLastItemInRange.
   */
  public static final String IncludesLastItemInRange =
      "IncludesLastItemInRange";

  /**
   * The Constant IncludesLastFolderInRange.
   */
  public static final String IncludesLastFolderInRange =
      "IncludesLastFolderInRange";

  /**
   * The Constant Create.
   */
  public static final String Create = "Create";

  /**
   * The Constant Update.
   */
  public static final String Update = "Update";

  /**
   * The Constant Delete.
   */
  public static final String Delete = "Delete";

  /**
   * The Constant ReadFlagChange.
   */
  public static final String ReadFlagChange = "ReadFlagChange";

  /**
   * The Constant SearchParameters.
   */
  public static final String SearchParameters = "SearchParameters";

  /**
   * The Constant SoftDeleted.
   */
  public static final String SoftDeleted = "SoftDeleted";

  /**
   * The Constant Shallow.
   */
  public static final String Shallow = "Shallow";

  /**
   * The Constant Associated.
   */
  public static final String Associated = "Associated";

  /**
   * The Constant BaseFolderIds.
   */
  public static final String BaseFolderIds = "BaseFolderIds";

  /**
   * The Constant SortOrder.
   */
  public static final String SortOrder = "SortOrder";

  /**
   * The Constant FieldOrder.
   */
  public static final String FieldOrder = "FieldOrder";

  /**
   * The Constant CanDelete.
   */
  public static final String CanDelete = "CanDelete";

  /**
   * The Constant CanRenameOrMove.
   */
  public static final String CanRenameOrMove = "CanRenameOrMove";

  /**
   * The Constant MustDisplayComment.
   */
  public static final String MustDisplayComment = "MustDisplayComment";

  /**
   * The Constant HasQuota.
   */
  public static final String HasQuota = "HasQuota";

  /**
   * The Constant IsManagedFoldersRoot.
   */
  public static final String IsManagedFoldersRoot = "IsManagedFoldersRoot";

  /**
   * The Constant ManagedFolderId.
   */
  public static final String ManagedFolderId = "ManagedFolderId";

  /**
   * The Constant Comment.
   */
  public static final String Comment = "Comment";

  /**
   * The Constant StorageQuota.
   */
  public static final String StorageQuota = "StorageQuota";

  /**
   * The Constant FolderSize.
   */
  public static final String FolderSize = "FolderSize";

  /**
   * The Constant HomePage.
   */
  public static final String HomePage = "HomePage";

  /**
   * The Constant ManagedFolderInformation.
   */
  public static final String ManagedFolderInformation =
      "ManagedFolderInformation";

  /**
   * The Constant CalendarView.
   */
  public static final String CalendarView = "CalendarView";

  /**
   * The Constant PostedTime.
   */
  public static final String PostedTime = "PostedTime";

  /**
   * The Constant PostItem.
   */
  public static final String PostItem = "PostItem";

  /**
   * The Constant RequestServerVersion.
   */
  public static final String RequestServerVersion = "RequestServerVersion";

  /**
   * The Constant PostReplyItem.
   */
  public static final String PostReplyItem = "PostReplyItem";

  /**
   * The Constant CreateAssociated.
   */
  public static final String CreateAssociated = "CreateAssociated";

  /**
   * The Constant CreateContents.
   */
  public static final String CreateContents = "CreateContents";

  /**
   * The Constant CreateHierarchy.
   */
  public static final String CreateHierarchy = "CreateHierarchy";

  /**
   * The Constant Modify.
   */
  public static final String Modify = "Modify";

  /**
   * The Constant Read.
   */
  public static final String Read = "Read";

  /**
   * The Constant EffectiveRights.
   */
  public static final String EffectiveRights = "EffectiveRights";

  /**
   * The Constant LastModifiedName.
   */
  public static final String LastModifiedName = "LastModifiedName";

  /**
   * The Constant LastModifiedTime.
   */
  public static final String LastModifiedTime = "LastModifiedTime";

  /**
   * The Constant ConversationId.
   */
  public static final String ConversationId = "ConversationId";

  /**
   * The Constant UniqueBody.
   */
  public static final String UniqueBody = "UniqueBody";

  /**
   * The Constant BodyType.
   */
  public static final String BodyType = "BodyType";

  /**
   * The Constant AttachmentShape.
   */
  public static final String AttachmentShape = "AttachmentShape";

  /**
   * The Constant UserId.
   */
  public static final String UserId = "UserId";

  /**
   * The Constant UserIds.
   */
  public static final String UserIds = "UserIds";

  /**
   * The Constant CanCreateItems.
   */
  public static final String CanCreateItems = "CanCreateItems";

  /**
   * The Constant CanCreateSubFolders.
   */
  public static final String CanCreateSubFolders = "CanCreateSubFolders";

  /**
   * The Constant IsFolderOwner.
   */
  public static final String IsFolderOwner = "IsFolderOwner";

  /**
   * The Constant IsFolderVisible.
   */
  public static final String IsFolderVisible = "IsFolderVisible";

  /**
   * The Constant IsFolderContact.
   */
  public static final String IsFolderContact = "IsFolderContact";

  /**
   * The Constant EditItems.
   */
  public static final String EditItems = "EditItems";

  /**
   * The Constant DeleteItems.
   */
  public static final String DeleteItems = "DeleteItems";

  /**
   * The Constant ReadItems.
   */
  public static final String ReadItems = "ReadItems";

  /**
   * The Constant PermissionLevel.
   */
  public static final String PermissionLevel = "PermissionLevel";

  /**
   * The Constant CalendarPermissionLevel.
   */
  public static final String CalendarPermissionLevel =
      "CalendarPermissionLevel";

  /**
   * The Constant SID.
   */
  public static final String SID = "SID";

  /**
   * The Constant PrimarySmtpAddress.
   */
  public static final String PrimarySmtpAddress = "PrimarySmtpAddress";

  /**
   * The Constant DistinguishedUser.
   */
  public static final String DistinguishedUser = "DistinguishedUser";

  /**
   * The Constant PermissionSet.
   */
  public static final String PermissionSet = "PermissionSet";

  /**
   * The Constant Permissions.
   */
  public static final String Permissions = "Permissions";

  /**
   * The Constant Permission.
   */
  public static final String Permission = "Permission";

  /**
   * The Constant CalendarPermissions.
   */
  public static final String CalendarPermissions = "CalendarPermissions";

  /**
   * The Constant CalendarPermission.
   */
  public static final String CalendarPermission = "CalendarPermission";

  /**
   * The Constant GroupBy.
   */
  public static final String GroupBy = "GroupBy";

  /**
   * The Constant AggregateOn.
   */
  public static final String AggregateOn = "AggregateOn";

  /**
   * The Constant Groups.
   */
  public static final String Groups = "Groups";

  /**
   * The Constant GroupedItems.
   */
  public static final String GroupedItems = "GroupedItems";

  /**
   * The Constant GroupIndex.
   */
  public static final String GroupIndex = "GroupIndex";

  /**
   * The Constant ConflictResults.
   */
  public static final String ConflictResults = "ConflictResults";

  /**
   * The Constant Count.
   */
  public static final String Count = "Count";

  /**
   * The Constant OofSettings.
   */
  public static final String OofSettings = "OofSettings";

  /**
   * The Constant UserOofSettings.
   */
  public static final String UserOofSettings = "UserOofSettings";

  /**
   * The Constant OofState.
   */
  public static final String OofState = "OofState";

  /**
   * The Constant ExternalAudience.
   */
  public static final String ExternalAudience = "ExternalAudience";

  /**
   * The Constant AllowExternalOof.
   */
  public static final String AllowExternalOof = "AllowExternalOof";

  /**
   * The Constant InternalReply.
   */
  public static final String InternalReply = "InternalReply";

  /**
   * The Constant ExternalReply.
   */
  public static final String ExternalReply = "ExternalReply";

  /**
   * The Constant Bias.
   */
  public static final String Bias = "Bias";

  /**
   * The Constant DayOrder.
   */
  public static final String DayOrder = "DayOrder";

  /**
   * The Constant Year.
   */
  public static final String Year = "Year";

  /**
   * The Constant StandardTime.
   */
  public static final String StandardTime = "StandardTime";

  /**
   * The Constant DaylightTime.
   */
  public static final String DaylightTime = "DaylightTime";

  /**
   * The Constant MailboxData.
   */
  public static final String MailboxData = "MailboxData";

  /**
   * The Constant MailboxDataArray.
   */
  public static final String MailboxDataArray = "MailboxDataArray";

  /**
   * The Constant Email.
   */
  public static final String Email = "Email";

  /**
   * The Constant AttendeeType.
   */
  public static final String AttendeeType = "AttendeeType";

  /**
   * The Constant ExcludeConflicts.
   */
  public static final String ExcludeConflicts = "ExcludeConflicts";

  /**
   * The Constant FreeBusyViewOptions.
   */
  public static final String FreeBusyViewOptions = "FreeBusyViewOptions";

  /**
   * The Constant SuggestionsViewOptions.
   */
  public static final String SuggestionsViewOptions = "SuggestionsViewOptions";

  /**
   * The Constant FreeBusyView.
   */
  public static final String FreeBusyView = "FreeBusyView";

  /**
   * The Constant TimeWindow.
   */
  public static final String TimeWindow = "TimeWindow";

  /**
   * The Constant MergedFreeBusyIntervalInMinutes.
   */
  public static final String MergedFreeBusyIntervalInMinutes =
      "MergedFreeBusyIntervalInMinutes";

  /**
   * The Constant RequestedView.
   */
  public static final String RequestedView = "RequestedView";

  /**
   * The Constant FreeBusyViewType.
   */
  public static final String FreeBusyViewType = "FreeBusyViewType";

  /**
   * The Constant CalendarEventArray.
   */
  public static final String CalendarEventArray = "CalendarEventArray";

  /**
   * The Constant CalendarEvent.
   */
  public static final String CalendarEvent = "CalendarEvent";

  /**
   * The Constant BusyType.
   */
  public static final String BusyType = "BusyType";

  /**
   * The Constant MergedFreeBusy.
   */
  public static final String MergedFreeBusy = "MergedFreeBusy";

  /**
   * The Constant WorkingHours.
   */
  public static final String WorkingHours = "WorkingHours";

  /**
   * The Constant WorkingPeriodArray.
   */
  public static final String WorkingPeriodArray = "WorkingPeriodArray";

  /**
   * The Constant WorkingPeriod.
   */
  public static final String WorkingPeriod = "WorkingPeriod";

  /**
   * The Constant StartTimeInMinutes.
   */
  public static final String StartTimeInMinutes = "StartTimeInMinutes";

  /**
   * The Constant EndTimeInMinutes.
   */
  public static final String EndTimeInMinutes = "EndTimeInMinutes";

  /**
   * The Constant GoodThreshold.
   */
  public static final String GoodThreshold = "GoodThreshold";

  /**
   * The Constant MaximumResultsByDay.
   */
  public static final String MaximumResultsByDay = "MaximumResultsByDay";

  /**
   * The Constant MaximumNonWorkHourResultsByDay.
   */
  public static final String MaximumNonWorkHourResultsByDay =
      "MaximumNonWorkHourResultsByDay";

  /**
   * The Constant MeetingDurationInMinutes.
   */
  public static final String MeetingDurationInMinutes =
      "MeetingDurationInMinutes";

  /**
   * The Constant MinimumSuggestionQuality.
   */
  public static final String MinimumSuggestionQuality =
      "MinimumSuggestionQuality";

  /**
   * The Constant DetailedSuggestionsWindow.
   */
  public static final String DetailedSuggestionsWindow =
      "DetailedSuggestionsWindow";

  /**
   * The Constant CurrentMeetingTime.
   */
  public static final String CurrentMeetingTime = "CurrentMeetingTime";

  /**
   * The Constant GlobalObjectId.
   */
  public static final String GlobalObjectId = "GlobalObjectId";

  /**
   * The Constant SuggestionDayResultArray.
   */
  public static final String SuggestionDayResultArray =
      "SuggestionDayResultArray";

  /**
   * The Constant SuggestionDayResult.
   */
  public static final String SuggestionDayResult = "SuggestionDayResult";

  /**
   * The Constant Date.
   */
  public static final String Date = "Date";

  /**
   * The Constant DayQuality.
   */
  public static final String DayQuality = "DayQuality";

  /**
   * The Constant SuggestionArray.
   */
  public static final String SuggestionArray = "SuggestionArray";

  /**
   * The Constant Suggestion.
   */
  public static final String Suggestion = "Suggestion";

  /**
   * The Constant MeetingTime.
   */
  public static final String MeetingTime = "MeetingTime";

  /**
   * The Constant IsWorkTime.
   */
  public static final String IsWorkTime = "IsWorkTime";

  /**
   * The Constant SuggestionQuality.
   */
  public static final String SuggestionQuality = "SuggestionQuality";

  /**
   * The Constant AttendeeConflictDataArray.
   */
  public static final String AttendeeConflictDataArray =
      "AttendeeConflictDataArray";

  /**
   * The Constant UnknownAttendeeConflictData.
   */
  public static final String UnknownAttendeeConflictData =
      "UnknownAttendeeConflictData";

  /**
   * The Constant TooBigGroupAttendeeConflictData.
   */
  public static final String TooBigGroupAttendeeConflictData =
      "TooBigGroupAttendeeConflictData";

  /**
   * The Constant IndividualAttendeeConflictData.
   */
  public static final String IndividualAttendeeConflictData =
      "IndividualAttendeeConflictData";

  /**
   * The Constant GroupAttendeeConflictData.
   */
  public static final String GroupAttendeeConflictData =
      "GroupAttendeeConflictData";

  /**
   * The Constant NumberOfMembers.
   */
  public static final String NumberOfMembers = "NumberOfMembers";

  /**
   * The Constant NumberOfMembersAvailable.
   */
  public static final String NumberOfMembersAvailable =
      "NumberOfMembersAvailable";

  /**
   * The Constant NumberOfMembersWithConflict.
   */
  public static final String NumberOfMembersWithConflict =
      "NumberOfMembersWithConflict";

  /**
   * The Constant NumberOfMembersWithNoData.
   */
  public static final String NumberOfMembersWithNoData =
      "NumberOfMembersWithNoData";

  /**
   * The Constant SourceIds.
   */
  public static final String SourceIds = "SourceIds";

  /**
   * The Constant AlternateId.
   */
  public static final String AlternateId = "AlternateId";

  /**
   * The Constant AlternatePublicFolderId.
   */
  public static final String AlternatePublicFolderId =
      "AlternatePublicFolderId";

  /**
   * The Constant AlternatePublicFolderItemId.
   */
  public static final String AlternatePublicFolderItemId =
      "AlternatePublicFolderItemId";

  /**
   * The Constant DelegatePermissions.
   */
  public static final String DelegatePermissions = "DelegatePermissions";

  /**
   * The Constant ReceiveCopiesOfMeetingMessages.
   */
  public static final String ReceiveCopiesOfMeetingMessages =
      "ReceiveCopiesOfMeetingMessages";

  /**
   * The Constant ViewPrivateItems.
   */
  public static final String ViewPrivateItems = "ViewPrivateItems";

  /**
   * The Constant CalendarFolderPermissionLevel.
   */
  public static final String CalendarFolderPermissionLevel =
      "CalendarFolderPermissionLevel";

  /**
   * The Constant TasksFolderPermissionLevel.
   */
  public static final String TasksFolderPermissionLevel =
      "TasksFolderPermissionLevel";

  /**
   * The Constant InboxFolderPermissionLevel.
   */
  public static final String InboxFolderPermissionLevel =
      "InboxFolderPermissionLevel";

  /**
   * The Constant ContactsFolderPermissionLevel.
   */
  public static final String ContactsFolderPermissionLevel =
      "ContactsFolderPermissionLevel";

  /**
   * The Constant NotesFolderPermissionLevel.
   */
  public static final String NotesFolderPermissionLevel =
      "NotesFolderPermissionLevel";

  /**
   * The Constant JournalFolderPermissionLevel.
   */
  public static final String JournalFolderPermissionLevel =
      "JournalFolderPermissionLevel";

  /**
   * The Constant DelegateUser.
   */
  public static final String DelegateUser = "DelegateUser";

  /**
   * The Constant DelegateUsers.
   */
  public static final String DelegateUsers = "DelegateUsers";

  /**
   * The Constant DeliverMeetingRequests.
   */
  public static final String DeliverMeetingRequests = "DeliverMeetingRequests";

  /**
   * The Constant MessageXml.
   */
  public static final String MessageXml = "MessageXml";

  /**
   * The Constant UserConfiguration.
   */
  public static final String UserConfiguration = "UserConfiguration";

  /**
   * The Constant UserConfigurationName.
   */
  public static final String UserConfigurationName = "UserConfigurationName";

  /**
   * The Constant UserConfigurationProperties.
   */
  public static final String UserConfigurationProperties =
      "UserConfigurationProperties";

  /**
   * The Constant Dictionary.
   */
  public static final String Dictionary = "Dictionary";

  /**
   * The Constant DictionaryEntry.
   */
  public static final String DictionaryEntry = "DictionaryEntry";

  /**
   * The Constant DictionaryKey.
   */
  public static final String DictionaryKey = "DictionaryKey";

  /**
   * The Constant DictionaryValue.
   */
  public static final String DictionaryValue = "DictionaryValue";

  /**
   * The Constant XmlData.
   */
  public static final String XmlData = "XmlData";

  /**
   * The Constant BinaryData.
   */
  public static final String BinaryData = "BinaryData";

  /**
   * The Constant FilterHtmlContent.
   */
  public static final String FilterHtmlContent = "FilterHtmlContent";

  /**
   * The Constant ConvertHtmlCodePageToUTF8.
   */
  public static final String ConvertHtmlCodePageToUTF8 =
      "ConvertHtmlCodePageToUTF8";

  /**
   * The Constant UnknownEntries.
   */
  public static final String UnknownEntries = "UnknownEntries";

  /**
   * The Constant UnknownEntry.
   */
  public static final String UnknownEntry = "UnknownEntry";

  /**
   * The Constant PhoneCallId.
   */
  public static final String PhoneCallId = "PhoneCallId";

  /**
   * The Constant DialString.
   */
  public static final String DialString = "DialString";

  /**
   * The Constant PhoneCallInformation.
   */
  public static final String PhoneCallInformation = "PhoneCallInformation";

  /**
   * The Constant PhoneCallState.
   */
  public static final String PhoneCallState = "PhoneCallState";

  /**
   * The Constant ConnectionFailureCause.
   */
  public static final String ConnectionFailureCause = "ConnectionFailureCause";

  /**
   * The Constant SIPResponseCode.
   */
  public static final String SIPResponseCode = "SIPResponseCode";

  /**
   * The Constant SIPResponseText.
   */
  public static final String SIPResponseText = "SIPResponseText";

  /**
   * The Constant WebClientReadFormQueryString.
   */
  public static final String WebClientReadFormQueryString =
      "WebClientReadFormQueryString";

  /**
   * The Constant WebClientEditFormQueryString.
   */
  public static final String WebClientEditFormQueryString =
      "WebClientEditFormQueryString";

  /**
   * The Constant Ids.
   */
  public static final String Ids = "Ids";

  /**
   * The Constant Id.
   */
  public static final String Id = "Id";

  /**
   * The Constant TimeZoneDefinitions.
   */
  public static final String TimeZoneDefinitions = "TimeZoneDefinitions";

  /**
   * The Constant TimeZoneDefinition.
   */
  public static final String TimeZoneDefinition = "TimeZoneDefinition";

  /**
   * The Constant Periods.
   */
  public static final String Periods = "Periods";

  /**
   * The Constant Period.
   */
  public static final String Period = "Period";

  /**
   * The Constant TransitionsGroups.
   */
  public static final String TransitionsGroups = "TransitionsGroups";

  /**
   * The Constant TransitionsGroup.
   */
  public static final String TransitionsGroup = "TransitionsGroup";

  /**
   * The Constant Transitions.
   */
  public static final String Transitions = "Transitions";

  /**
   * The Constant Transition.
   */
  public static final String Transition = "Transition";

  /**
   * The Constant AbsoluteDateTransition.
   */
  public static final String AbsoluteDateTransition = "AbsoluteDateTransition";

  /**
   * The Constant RecurringDayTransition.
   */
  public static final String RecurringDayTransition = "RecurringDayTransition";

  /**
   * The Constant RecurringDateTransition.
   */
  public static final String RecurringDateTransition =
      "RecurringDateTransition";

  /**
   * The Constant DateTime.
   */
  public static final String DateTime = "DateTime";

  /**
   * The Constant TimeOffset.
   */
  public static final String TimeOffset = "TimeOffset";

  /**
   * The Constant Day.
   */
  public static final String Day = "Day";

  /**
   * The Constant TimeZoneContext.
   */
  public static final String TimeZoneContext = "TimeZoneContext";

  /**
   * The Constant StartTimeZone.
   */
  public static final String StartTimeZone = "StartTimeZone";

  /**
   * The Constant EndTimeZone.
   */
  public static final String EndTimeZone = "EndTimeZone";

  /**
   * The Constant ReceivedBy.
   */
  public static final String ReceivedBy = "ReceivedBy";

  /**
   * The Constant ReceivedRepresenting.
   */
  public static final String ReceivedRepresenting = "ReceivedRepresenting";

  /**
   * The Constant Uid.
   */
  public static final String Uid = "UID";

  /**
   * The Constant RecurrenceId.
   */
  public static final String RecurrenceId = "RecurrenceId";

  /**
   * The Constant DateTimeStamp.
   */
  public static final String DateTimeStamp = "DateTimeStamp";

  /**
   * The Constant IsInline.
   */
  public static final String IsInline = "IsInline";

  /**
   * The Constant IsContactPhoto.
   */
  public static final String IsContactPhoto = "IsContactPhoto";

  /**
   * The Constant QueryString.
   */
  public static final String QueryString = "QueryString";

  /**
   * The Constant CalendarEventDetails.
   */
  public static final String CalendarEventDetails = "CalendarEventDetails";

  /**
   * The Constant ID.
   */
  public static final String ID = "ID";

  /**
   * The Constant IsException.
   */
  public static final String IsException = "IsException";

  /**
   * The Constant IsReminderSet.
   */
  public static final String IsReminderSet = "IsReminderSet";

  /**
   * The Constant IsPrivate.
   */
  public static final String IsPrivate = "IsPrivate";

  /**
   * The Constant FirstDayOfWeek.
   */
  public static final String FirstDayOfWeek = "FirstDayOfWeek";

  /**
   * The Constant Verb.
   */
  public static final String Verb = "Verb";

  /**
   * The Constant Parameter.
   */
  public static final String Parameter = "Parameter";

  /**
   * The Constant ReturnValue.
   */
  public static final String ReturnValue = "ReturnValue";

  /**
   * The Constant ReturnNewItemIds.
   */
  public static final String ReturnNewItemIds = "ReturnNewItemIds";

  /**
   * The Constant DateTimePrecision.
   */
  public static final String DateTimePrecision = "DateTimePrecision";

  /**
   * The Constant PasswordExpirationDate.
   */
  public static final String PasswordExpirationDate = "PasswordExpirationDate";

  /**
   * The Constant StoreEntryId.
   */
  public static final String StoreEntryId = "StoreEntryId";

  // Conversations
  /**
   * The Constant Conversations.
   */
  public static final String Conversations = "Conversations";

  /**
   * The Constant Conversation.
   */
  public static final String Conversation = "Conversation";

  /**
   * The Constant UniqueRecipients.
   */
  public static final String UniqueRecipients = "UniqueRecipients";

  /**
   * The Constant GlobalUniqueRecipients.
   */
  public static final String GlobalUniqueRecipients = "GlobalUniqueRecipients";

  /**
   * The Constant UniqueUnreadSenders.
   */
  public static final String UniqueUnreadSenders = "UniqueUnreadSenders";

  /**
   * The Constant GlobalUniqueUnreadSenders.
   */
  public static final String GlobalUniqueUnreadSenders =
      "GlobalUniqueUnreadSenders";

  /**
   * The Constant UniqueSenders.
   */
  public static final String UniqueSenders = "UniqueSenders";

  /**
   * The Constant GlobalUniqueSenders.
   */
  public static final String GlobalUniqueSenders = "GlobalUniqueSenders";

  /**
   * The Constant LastDeliveryTime.
   */
  public static final String LastDeliveryTime = "LastDeliveryTime";

  /**
   * The Constant GlobalLastDeliveryTime.
   */
  public static final String GlobalLastDeliveryTime = "GlobalLastDeliveryTime";

  /**
   * The Constant GlobalCategories.
   */
  public static final String GlobalCategories = "GlobalCategories";

  /**
   * The Constant FlagStatus.
   */
  public static final String FlagStatus = "FlagStatus";

  /**
   * The Constant GlobalFlagStatus.
   */
  public static final String GlobalFlagStatus = "GlobalFlagStatus";

  /**
   * The Constant GlobalHasAttachments.
   */
  public static final String GlobalHasAttachments = "GlobalHasAttachments";

  /**
   * The Constant MessageCount.
   */
  public static final String MessageCount = "MessageCount";

  /**
   * The Constant GlobalMessageCount.
   */
  public static final String GlobalMessageCount = "GlobalMessageCount";

  /**
   * The Constant GlobalUnreadCount.
   */
  public static final String GlobalUnreadCount = "GlobalUnreadCount";

  /**
   * The Constant GlobalSize.
   */
  public static final String GlobalSize = "GlobalSize";

  /**
   * The Constant ItemClasses.
   */
  public static final String ItemClasses = "ItemClasses";

  /**
   * The Constant GlobalItemClasses.
   */
  public static final String GlobalItemClasses = "GlobalItemClasses";

  /**
   * The Constant GlobalImportance.
   */
  public static final String GlobalImportance = "GlobalImportance";

  /**
   * The Constant GlobalItemIds.
   */
  public static final String GlobalItemIds = "GlobalItemIds";

  // ApplyConversationAction

  /**
   * The Constant ApplyConversationAction.
   */
  public static final String ApplyConversationAction =
      "ApplyConversationAction";

  /**
   * The Constant ConversationActions.
   */
  public static final String ConversationActions = "ConversationActions";

  /**
   * The Constant ConversationAction.
   */
  public static final String ConversationAction = "ConversationAction";

  /**
   * The Constant ApplyConversationActionResponse.
   */
  public static final String ApplyConversationActionResponse =
      "ApplyConversationActionResponse";

  /**
   * The Constant ApplyConversationActionResponseMessage.
   */
  public static final String ApplyConversationActionResponseMessage =
      "ApplyConversationActionResponseMessage";

  /**
   * The Constant EnableAlwaysDelete.
   */
  public static final String EnableAlwaysDelete = "EnableAlwaysDelete";

  /**
   * The Constant ProcessRightAway.
   */
  public static final String ProcessRightAway = "ProcessRightAway";

  /**
   * The Constant DestinationFolderId.
   */
  public static final String DestinationFolderId = "DestinationFolderId";

  /**
   * The Constant ContextFolderId.
   */
  public static final String ContextFolderId = "ContextFolderId";

  /**
   * The Constant ConversationLastSyncTime.
   */
  public static final String ConversationLastSyncTime =
      "ConversationLastSyncTime";

  /**
   * The Constant AlwaysCategorize.
   */
  public static final String AlwaysCategorize = "AlwaysCategorize";

  /**
   * The Constant AlwaysDelete.
   */
  public static final String AlwaysDelete = "AlwaysDelete";

  /**
   * The Constant AlwaysMove.
   */
  public static final String AlwaysMove = "AlwaysMove";

  /**
   * The Constant Move.
   */
  public static final String Move = "Move";

  /**
   * The Constant Copy.
   */
  public static final String Copy = "Copy";

  /**
   * The Constant SetReadState.
   */
  public static final String SetReadState = "SetReadState";

  /**
   * The Constant DeleteType.
   */
  public static final String DeleteType = "DeleteType";
  // RoomList & Room

  /**
   * The Constant RoomLists.
   */
  public static final String RoomLists = "RoomLists";

  /**
   * The Constant Rooms.
   */
  public static final String Rooms = "Rooms";

  /**
   * The Constant Room.
   */
  public static final String Room = "Room";

  /**
   * The Constant RoomList.
   */
  public static final String RoomList = "RoomList";

  /**
   * The Constant RoomId.
   */
  public static final String RoomId = "Id";

  // Autodiscover

  /**
   * The Constant Autodiscover.
   */
  public static final String Autodiscover = "Autodiscover";

  /**
   * The Constant BinarySecret.
   */
  public static final String BinarySecret = "BinarySecret";

  /**
   * The Constant Response.
   */
  public static final String Response = "Response";

  /**
   * The Constant User.
   */
  public static final String User = "User";

  /**
   * The Constant LegacyDN.
   */
  public static final String LegacyDN = "LegacyDN";

  /**
   * The Constant DeploymentId.
   */
  public static final String DeploymentId = "DeploymentId";

  /**
   * The Constant Account.
   */
  public static final String Account = "Account";

  /**
   * The Constant AccountType.
   */
  public static final String AccountType = "AccountType";

  /**
   * The Constant Action.
   */
  public static final String Action = "Action";

  /**
   * The Constant To.
   */
  public static final String To = "To";

  /**
   * The Constant RedirectAddr.
   */
  public static final String RedirectAddr = "RedirectAddr";

  /**
   * The Constant RedirectUrl.
   */
  public static final String RedirectUrl = "RedirectUrl";

  /**
   * The Constant Protocol.
   */
  public static final String Protocol = "Protocol";

  /**
   * The Constant Type.
   */
  public static final String Type = "Type";

  /**
   * The Constant Server.
   */
  public static final String Server = "Server";

  /**
   * The Constant ServerDN.
   */
  public static final String ServerDN = "ServerDN";

  /**
   * The Constant ServerVersion.
   */
  public static final String ServerVersion = "ServerVersion";

  /**
   * The Constant ServerVersionInfo.
   */
  public static final String ServerVersionInfo = "ServerVersionInfo";


  /**
   * The Constant SmtpAddress.
   */
  public static final String SmtpAddress = "SmtpAddress";

  /**
   * The Constant OwnerSmtpAddress.
   */
  public static final String OwnerSmtpAddress = "OwnerSmtpAddress";

  /**
   * The Constant AD.
   */
  public static final String AD = "AD";

  /**
   * The Constant AuthPackage.
   */
  public static final String AuthPackage = "AuthPackage";

  /**
   * The Constant MdbDN.
   */
  public static final String MdbDN = "MdbDN";

  /**
   * The Constant EWSUrl.
   */
  public static final String EWSUrl = "EWSUrl";

  /**
   * The Constant ASUrl.
   */
  public static final String ASUrl = "ASUrl";

  /**
   * The Constant OOFUrl.
   */
  public static final String OOFUrl = "OOFUrl";

  /**
   * The Constant UMUrl.
   */
  public static final String UMUrl = "UMUrl";

  /**
   * The Constant OABUrl.
   */
  public static final String OABUrl = "OABUrl";

  /**
   * The Constant Internal.
   */
  public static final String Internal = "Internal";

  /**
   * The Constant External.
   */
  public static final String External = "External";

  /**
   * The Constant OWAUrl.
   */
  public static final String OWAUrl = "OWAUrl";

  /**
   * The Constant Error.
   */
  public static final String Error = "Error";

  /**
   * The Constant ErrorCode.
   */
  public static final String ErrorCode = "ErrorCode";

  /**
   * The Constant DebugData.
   */
  public static final String DebugData = "DebugData";

  /**
   * The Constant Users.
   */
  public static final String Users = "Users";

  /**
   * The Constant RequestedSettings.
   */
  public static final String RequestedSettings = "RequestedSettings";

  /**
   * The Constant Setting.
   */
  public static final String Setting = "Setting";

  /**
   * The Constant GetUserSettingsRequestMessage.
   */
  public static final String GetUserSettingsRequestMessage =
      "GetUserSettingsRequestMessage";

  /**
   * The Constant RequestedServerVersion.
   */
  public static final String RequestedServerVersion = "RequestedServerVersion";

  /**
   * The Constant Request.
   */
  public static final String Request = "Request";

  /**
   * The Constant RedirectTarget.
   */
  public static final String RedirectTarget = "RedirectTarget";

  /**
   * The Constant UserSettings.
   */
  public static final String UserSettings = "UserSettings";

  /**
   * The Constant UserSettingErrors.
   */
  public static final String UserSettingErrors = "UserSettingErrors";

  /**
   * The Constant GetUserSettingsResponseMessage.
   */
  public static final String GetUserSettingsResponseMessage =
      "GetUserSettingsResponseMessage";

  /**
   * The Constant ErrorMessage.
   */
  public static final String ErrorMessage = "ErrorMessage";

  /**
   * The Constant UserResponse.
   */
  public static final String UserResponse = "UserResponse";

  /**
   * The Constant UserResponses.
   */
  public static final String UserResponses = "UserResponses";

  /**
   * The Constant UserSettingError.
   */
  public static final String UserSettingError = "UserSettingError";

  /**
   * The Constant Domain.
   */
  public static final String Domain = "Domain";

  /**
   * The Constant Domains.
   */
  public static final String Domains = "Domains";

  /**
   * The Constant DomainResponse.
   */
  public static final String DomainResponse = "DomainResponse";

  /**
   * The Constant DomainResponses.
   */
  public static final String DomainResponses = "DomainResponses";

  /**
   * The Constant DomainSetting.
   */
  public static final String DomainSetting = "DomainSetting";

  /**
   * The Constant DomainSettings.
   */
  public static final String DomainSettings = "DomainSettings";

  /**
   * The Constant DomainStringSetting.
   */
  public static final String DomainStringSetting = "DomainStringSetting";

  /**
   * The Constant DomainSettingError.
   */
  public static final String DomainSettingError = "DomainSettingError";

  /**
   * The Constant DomainSettingErrors.
   */
  public static final String DomainSettingErrors = "DomainSettingErrors";

  /**
   * The Constant GetDomainSettingsRequestMessage.
   */
  public static final String GetDomainSettingsRequestMessage =
      "GetDomainSettingsRequestMessage";

  /**
   * The Constant GetDomainSettingsResponseMessage.
   */
  public static final String GetDomainSettingsResponseMessage =
      "GetDomainSettingsResponseMessage";

  /**
   * The Constant SettingName.
   */
  public static final String SettingName = "SettingName";

  /**
   * The Constant UserSetting.
   */
  public static final String UserSetting = "UserSetting";

  /**
   * The Constant StringSetting.
   */
  public static final String StringSetting = "StringSetting";

  /**
   * The Constant WebClientUrlCollectionSetting.
   */
  public static final String WebClientUrlCollectionSetting =
      "WebClientUrlCollectionSetting";

  /**
   * The Constant WebClientUrls.
   */
  public static final String WebClientUrls = "WebClientUrls";

  /**
   * The Constant WebClientUrl.
   */
  public static final String WebClientUrl = "WebClientUrl";

  /**
   * The Constant AuthenticationMethods.
   */
  public static final String AuthenticationMethods = "AuthenticationMethods";

  /**
   * The Constant Url.
   */
  public static final String Url = "Url";

  /**
   * The Constant AlternateMailboxCollectionSetting.
   */
  public static final String AlternateMailboxCollectionSetting =
      "AlternateMailboxCollectionSetting";

  /**
   * The Constant AlternateMailboxes.
   */
  public static final String AlternateMailboxes = "AlternateMailboxes";

  /**
   * The Constant AlternateMailbox.
   */
  public static final String AlternateMailbox = "AlternateMailbox";

  /**
   * The Constant ProtocolConnectionCollectionSetting.
   */
  public static final String ProtocolConnectionCollectionSetting =
      "ProtocolConnectionCollectionSetting";

  /**
   * The Constant ProtocolConnections.
   */
  public static final String ProtocolConnections = "ProtocolConnections";

  /**
   * The Constant ProtocolConnection.
   */
  public static final String ProtocolConnection = "ProtocolConnection";

  /**
   * The Constant EncryptionMethod.
   */
  public static final String EncryptionMethod = "EncryptionMethod";

  /**
   * The Constant Hostname.
   */
  public static final String Hostname = "Hostname";

  /**
   * The Constant Port.
   */
  public static final String Port = "Port";

  /**
   * The Constant Version.
   */
  public static final String Version = "Version";

  /**
   * The Constant MajorVersion.
   */
  public static final String MajorVersion = "MajorVersion";

  /**
   * The Constant MinorVersion.
   */
  public static final String MinorVersion = "MinorVersion";

  /**
   * The Constant MajorBuildNumber.
   */
  public static final String MajorBuildNumber = "MajorBuildNumber";

  /**
   * The Constant MinorBuildNumber.
   */
  public static final String MinorBuildNumber = "MinorBuildNumber";

  /**
   * The Constant RequestedVersion.
   */
  public static final String RequestedVersion = "RequestedVersion";

  /**
   * The Constant PublicFolderServer.
   */
  public static final String PublicFolderServer = "PublicFolderServer";

  /**
   * The Constant Ssl.
   */
  public static final String Ssl = "SSL";

  /**
   * The Constant SharingUrl.
   */
  public static final String SharingUrl = "SharingUrl";

  /**
   * The Constant EcpUrl.
   */
  public static final String EcpUrl = "EcpUrl";

  /**
   * The Constant EcpUrl_um.
   */
  public static final String EcpUrl_um = "EcpUrl-um";

  /**
   * The Constant EcpUrl_aggr.
   */
  public static final String EcpUrl_aggr = "EcpUrl-aggr";

  /**
   * The Constant EcpUrl_sms.
   */
  public static final String EcpUrl_sms = "EcpUrl-sms";

  /**
   * The Constant EcpUrl_mt.
   */
  public static final String EcpUrl_mt = "EcpUrl-mt";

  /**
   * The Constant EcpUrl_ret.
   */
  public static final String EcpUrl_ret = "EcpUrl-ret";

  /**
   * The Constant EcpUrl_publish.
   */
  public static final String EcpUrl_publish = "EcpUrl-publish";

  /**
   * The Constant ExchangeRpcUrl.
   */
  public static final String ExchangeRpcUrl = "ExchangeRpcUrl";

  /**
   * The Constant PartnerToken.
   */
  public static final String PartnerToken = "PartnerToken";

  /**
   * The Constant PartnerTokenReference.
   */
  public static final String PartnerTokenReference = "PartnerTokenReference";

  /**
   * The Constant GroupingInformation.
   */
  public static final String GroupingInformation = "GroupingInformation";

  // InboxRule
  /**
   * The Constant MinorBuildNumber.
   */
  public static final String MailboxSmtpAddress = "MailboxSmtpAddress";

  /**
   * The Constant RuleId.
   */
  public static final String RuleId = "RuleId";

  /**
   * The Constant Priority.
   */
  public static final String Priority = "Priority";

  /**
   * The Constant IsEnabled.
   */
  public static final String IsEnabled = "IsEnabled";

  /**
   * The Constant IsNotSupported.
   */
  public static final String IsNotSupported = "IsNotSupported";

  /**
   * The Constant IsInError.
   */
  public static final String IsInError = "IsInError";

  /**
   * The Constant Conditions.
   */
  public static final String Conditions = "Conditions";

  /**
   * The Constant Exceptions.
   */
  public static final String Exceptions = "Exceptions";

  /**
   * The Constant Actions.
   */
  public static final String Actions = "Actions";

  /**
   * The Constant InboxRules.
   */
  public static final String InboxRules = "InboxRules";

  /**
   * The Constant Rule.
   */
  public static final String Rule = "Rule";

  /**
   * The Constant OutlookRuleBlobExists.
   */
  public static final String OutlookRuleBlobExists = "OutlookRuleBlobExists";

  /**
   * The Constant RemoveOutlookRuleBlob.
   */
  public static final String RemoveOutlookRuleBlob = "RemoveOutlookRuleBlob";

  /**
   * The Constant ContainsBodyStrings.
   */
  public static final String ContainsBodyStrings = "ContainsBodyStrings";

  /**
   * The Constant ContainsHeaderStrings.
   */
  public static final String ContainsHeaderStrings = "ContainsHeaderStrings";

  /**
   * The Constant ContainsRecipientStrings.
   */
  public static final String ContainsRecipientStrings =
      "ContainsRecipientStrings";

  /**
   * The Constant ContainsSenderStrings.
   */
  public static final String ContainsSenderStrings = "ContainsSenderStrings";

  /**
   * The Constant ContainsSubjectOrBodyStrings.
   */
  public static final String ContainsSubjectOrBodyStrings =
      "ContainsSubjectOrBodyStrings";

  /**
   * The Constant ContainsSubjectStrings.
   */
  public static final String ContainsSubjectStrings = "ContainsSubjectStrings";

  /**
   * The Constant FlaggedForAction.
   */
  public static final String FlaggedForAction = "FlaggedForAction";

  /**
   * The Constant FromAddresses.
   */
  public static final String FromAddresses = "FromAddresses";

  /**
   * The Constant FromConnectedAccounts.
   */
  public static final String FromConnectedAccounts = "FromConnectedAccounts";

  /**
   * The Constant IsApprovalRequest.
   */
  public static final String IsApprovalRequest = "IsApprovalRequest";

  /**
   * The Constant IsAutomaticForward.
   */
  public static final String IsAutomaticForward = "IsAutomaticForward";

  /**
   * The Constant IsAutomaticReply.
   */
  public static final String IsAutomaticReply = "IsAutomaticReply";

  /**
   * The Constant IsEncrypted.
   */
  public static final String IsEncrypted = "IsEncrypted";

  /**
   * The Constant IsMeetingRequest.
   */
  public static final String IsMeetingRequest = "IsMeetingRequest";

  /**
   * The Constant IsMeetingResponse.
   */
  public static final String IsMeetingResponse = "IsMeetingResponse";

  /**
   * The Constant IsNDR.
   */
  public static final String IsNDR = "IsNDR";

  /**
   * The Constant IsPermissionControlled.
   */
  public static final String IsPermissionControlled = "IsPermissionControlled";

  /**
   * The Constant IsSigned.
   */
  public static final String IsSigned = "IsSigned";

  /**
   * The Constant IsVoicemail.
   */
  public static final String IsVoicemail = "IsVoicemail";

  /**
   * The Constant IsReadReceipt.
   */
  public static final String IsReadReceipt = "IsReadReceipt";

  /**
   * The Constant MessageClassifications.
   */
  public static final String MessageClassifications = "MessageClassifications";

  /**
   * The Constant NotSentToMe.
   */
  public static final String NotSentToMe = "NotSentToMe";

  /**
   * The Constant SentCcMe.
   */
  public static final String SentCcMe = "SentCcMe";

  /**
   * The Constant SentOnlyToMe.
   */
  public static final String SentOnlyToMe = "SentOnlyToMe";

  /**
   * The Constant SentToAddresses.
   */
  public static final String SentToAddresses = "SentToAddresses";

  /**
   * The Constant SentToMe.
   */
  public static final String SentToMe = "SentToMe";

  /**
   * The Constant SentToOrCcMe.
   */
  public static final String SentToOrCcMe = "SentToOrCcMe";

  /**
   * The Constant WithinDateRange.
   */
  public static final String WithinDateRange = "WithinDateRange";

  /**
   * The Constant WithinSizeRange.
   */
  public static final String WithinSizeRange = "WithinSizeRange";

  /**
   * The Constant MinimumSize.
   */
  public static final String MinimumSize = "MinimumSize";

  /**
   * The Constant MaximumSize.
   */
  public static final String MaximumSize = "MaximumSize";

  /**
   * The Constant StartDateTime.
   */
  public static final String StartDateTime = "StartDateTime";

  /**
   * The Constant EndDateTime.
   */
  public static final String EndDateTime = "EndDateTime";

  /**
   * The Constant AssignCategories.
   */
  public static final String AssignCategories = "AssignCategories";

  /**
   * The Constant CopyToFolder.
   */
  public static final String CopyToFolder = "CopyToFolder";

  /**
   * The Constant FlagMessage.
   */
  public static final String FlagMessage = "FlagMessage";

  /**
   * The Constant ForwardAsAttachmentToRecipients.
   */
  public static final String ForwardAsAttachmentToRecipients =
      "ForwardAsAttachmentToRecipients";

  /**
   * The Constant ForwardToRecipients.
   */
  public static final String ForwardToRecipients = "ForwardToRecipients";

  /**
   * The Constant MarkImportance.
   */
  public static final String MarkImportance = "MarkImportance";

  /**
   * The Constant MarkAsRead.
   */
  public static final String MarkAsRead = "MarkAsRead";

  /**
   * The Constant MoveToFolder.
   */
  public static final String MoveToFolder = "MoveToFolder";

  /**
   * The Constant PermanentDelete.
   */
  public static final String PermanentDelete = "PermanentDelete";

  /**
   * The Constant RedirectToRecipients.
   */
  public static final String RedirectToRecipients = "RedirectToRecipients";

  /**
   * The Constant SendSMSAlertToRecipients.
   */
  public static final String SendSMSAlertToRecipients =
      "SendSMSAlertToRecipients";

  /**
   * The Constant ServerReplyWithMessage.
   */
  public static final String ServerReplyWithMessage = "ServerReplyWithMessage";

  /**
   * The Constant StopProcessingRules.
   */
  public static final String StopProcessingRules = "StopProcessingRules";

  /**
   * The Constant CreateRuleOperation.
   */
  public static final String CreateRuleOperation = "CreateRuleOperation";

  /**
   * The Constant SetRuleOperation.
   */
  public static final String SetRuleOperation = "SetRuleOperation";

  /**
   * The Constant DeleteRuleOperation.
   */
  public static final String DeleteRuleOperation = "DeleteRuleOperation";

  /**
   * The Constant Operations.
   */
  public static final String Operations = "Operations";

  /**
   * The Constant RuleOperationErrors.
   */
  public static final String RuleOperationErrors = "RuleOperationErrors";

  /**
   * The Constant RuleOperationError.
   */
  public static final String RuleOperationError = "RuleOperationError";

  /**
   * The Constant OperationIndex.
   */
  public static final String OperationIndex = "OperationIndex";

  /**
   * The Constant ValidationErrors.
   */
  public static final String ValidationErrors = "ValidationErrors";

  /**
   * The Constant FieldValue.
   */
  public static final String FieldValue = "FieldValue";

  // Restrictions
  /**
   * The Constant Not.
   */
  public static final String Not = "Not";

  /**
   * The Constant Bitmask.
   */
  public static final String Bitmask = "Bitmask";

  /**
   * The Constant Constant.
   */
  public static final String Constant = "Constant";

  /**
   * The Constant Restriction.
   */
  public static final String Restriction = "Restriction";

  /**
   * The Constant Contains.
   */
  public static final String Contains = "Contains";

  /**
   * The Constant Excludes.
   */
  public static final String Excludes = "Excludes";

  /**
   * The Constant Exists.
   */
  public static final String Exists = "Exists";

  /**
   * The Constant FieldURIOrConstant.
   */
  public static final String FieldURIOrConstant = "FieldURIOrConstant";

  /**
   * The Constant And.
   */
  public static final String And = "And";

  /**
   * The Constant Or.
   */
  public static final String Or = "Or";

  /**
   * The Constant IsEqualTo.
   */
  public static final String IsEqualTo = "IsEqualTo";

  /**
   * The Constant IsNotEqualTo.
   */
  public static final String IsNotEqualTo = "IsNotEqualTo";

  /**
   * The Constant IsGreaterThan.
   */
  public static final String IsGreaterThan = "IsGreaterThan";

  /**
   * The Constant IsGreaterThanOrEqualTo.
   */
  public static final String IsGreaterThanOrEqualTo = "IsGreaterThanOrEqualTo";

  /**
   * The Constant IsLessThan.
   */
  public static final String IsLessThan = "IsLessThan";

  /**
   * The Constant IsLessThanOrEqualTo.
   */
  public static final String IsLessThanOrEqualTo = "IsLessThanOrEqualTo";

  // Directory only contact property
  /**
   * The Constant PhoneticFullName.
   */
  public static final String PhoneticFullName = "PhoneticFullName";

  /**
   * The Constant PhoneticFirstName.
   */
  public static final String PhoneticFirstName = "PhoneticFirstName";

  /**
   * The Constant PhoneticLastName.
   */
  public static final String PhoneticLastName = "PhoneticLastName";

  /**
   * The Constant Alias.
   */
  public static final String Alias = "Alias";

  /**
   * The Constant Notes.
   */
  public static final String Notes = "Notes";

  /**
   * The Constant Photo.
   */
  public static final String Photo = "Photo";

  /**
   * The Constant UserSMIMECertificate.
   */
  public static final String UserSMIMECertificate = "UserSMIMECertificate";

  /**
   * The Constant MSExchangeCertificate.
   */
  public static final String MSExchangeCertificate = "MSExchangeCertificate";

  /**
   * The Constant DirectoryId.
   */
  public static final String DirectoryId = "DirectoryId";

  /**
   * The Constant ManagerMailbox.
   */
  public static final String ManagerMailbox = "ManagerMailbox";

  /**
   * The Constant DirectReports.
   */
  public static final String DirectReports = "DirectReports";

  // Request/response element names
  /**
   * The Constant ResponseMessage.
   */
  public static final String ResponseMessage = "ResponseMessage";

  /**
   * The Constant ResponseMessages.
   */
  public static final String ResponseMessages = "ResponseMessages";

  // FindConversation
  /**
   * The Constant FindConversation.
   */
  public static final String FindConversation = "FindConversation";

  /**
   * The Constant FindConversationResponse.
   */
  public static final String FindConversationResponse =
      "FindConversationResponse";

  /**
   * The Constant FindConversationResponseMessage.
   */
  public static final String FindConversationResponseMessage =
      "FindConversationResponseMessage";

  // FindItem
  /**
   * The Constant FindItem.
   */
  public static final String FindItem = "FindItem";

  /**
   * The Constant FindItemResponse.
   */
  public static final String FindItemResponse = "FindItemResponse";

  /**
   * The Constant FindItemResponseMessage.
   */
  public static final String FindItemResponseMessage =
      "FindItemResponseMessage";

  // GetItem
  /**
   * The Constant GetItem.
   */
  public static final String GetItem = "GetItem";

  /**
   * The Constant GetItemResponse.
   */
  public static final String GetItemResponse = "GetItemResponse";

  /**
   * The Constant GetItemResponseMessage.
   */
  public static final String GetItemResponseMessage = "GetItemResponseMessage";

  // CreateItem
  /**
   * The Constant CreateItem.
   */
  public static final String CreateItem = "CreateItem";

  /**
   * The Constant CreateItemResponse.
   */
  public static final String CreateItemResponse = "CreateItemResponse";

  /**
   * The Constant CreateItemResponseMessage.
   */
  public static final String CreateItemResponseMessage =
      "CreateItemResponseMessage";

  // SendItem
  /**
   * The Constant SendItem.
   */
  public static final String SendItem = "SendItem";

  /**
   * The Constant SendItemResponse.
   */
  public static final String SendItemResponse = "SendItemResponse";

  /**
   * The Constant SendItemResponseMessage.
   */
  public static final String SendItemResponseMessage =
      "SendItemResponseMessage";

  // DeleteItem
  /**
   * The Constant DeleteItem.
   */
  public static final String DeleteItem = "DeleteItem";

  /**
   * The Constant DeleteItemResponse.
   */
  public static final String DeleteItemResponse = "DeleteItemResponse";

  /**
   * The Constant DeleteItemResponseMessage.
   */
  public static final String DeleteItemResponseMessage =
      "DeleteItemResponseMessage";

  // ExportItems
  public static final String ExportItems = "ExportItems";

  public static final String ExportItemsResponse = "ExportItemsResponse";

  public static final String ExportItemsResponseMessage =
      "ExportItemsResponseMessage";

  // ExportItems
  public static final String UploadItems = "UploadItems";

  public static final String UploadItemsResponse = "UploadItemsResponse";

  public static final String UploadItemsResponseMessage =
      "UploadItemsResponseMessage";

  // UpdateItem
  /**
   * The Constant UpdateItem.
   */
  public static final String UpdateItem = "UpdateItem";

  /**
   * The Constant UpdateItemResponse.
   */
  public static final String UpdateItemResponse = "UpdateItemResponse";

  /**
   * The Constant UpdateItemResponseMessage.
   */
  public static final String UpdateItemResponseMessage =
      "UpdateItemResponseMessage";

  // CopyItem
  /**
   * The Constant CopyItem.
   */
  public static final String CopyItem = "CopyItem";

  /**
   * The Constant CopyItemResponse.
   */
  public static final String CopyItemResponse = "CopyItemResponse";

  /**
   * The Constant CopyItemResponseMessage.
   */
  public static final String CopyItemResponseMessage =
      "CopyItemResponseMessage";

  // MoveItem
  /**
   * The Constant MoveItem.
   */
  public static final String MoveItem = "MoveItem";

  /**
   * The Constant MoveItemResponse.
   */
  public static final String MoveItemResponse = "MoveItemResponse";

  /**
   * The Constant MoveItemResponseMessage.
   */
  public static final String MoveItemResponseMessage =
      "MoveItemResponseMessage";

  // FindFolder
  /**
   * The Constant FindFolder.
   */
  public static final String FindFolder = "FindFolder";

  /**
   * The Constant FindFolderResponse.
   */
  public static final String FindFolderResponse = "FindFolderResponse";

  /**
   * The Constant FindFolderResponseMessage.
   */
  public static final String FindFolderResponseMessage =
      "FindFolderResponseMessage";

  // GetFolder
  /**
   * The Constant GetFolder.
   */
  public static final String GetFolder = "GetFolder";

  /**
   * The Constant GetFolderResponse.
   */
  public static final String GetFolderResponse = "GetFolderResponse";

  /**
   * The Constant GetFolderResponseMessage.
   */
  public static final String GetFolderResponseMessage =
      "GetFolderResponseMessage";

  // CreateFolder
  /**
   * The Constant CreateFolder.
   */
  public static final String CreateFolder = "CreateFolder";

  /**
   * The Constant CreateFolderResponse.
   */
  public static final String CreateFolderResponse = "CreateFolderResponse";

  /**
   * The Constant CreateFolderResponseMessage.
   */
  public static final String CreateFolderResponseMessage =
      "CreateFolderResponseMessage";

  // DeleteFolder
  /**
   * The Constant DeleteFolder.
   */
  public static final String DeleteFolder = "DeleteFolder";

  /**
   * The Constant DeleteFolderResponse.
   */
  public static final String DeleteFolderResponse = "DeleteFolderResponse";

  /**
   * The Constant DeleteFolderResponseMessage.
   */
  public static final String DeleteFolderResponseMessage =
      "DeleteFolderResponseMessage";

  // EmptyFolder
  /**
   * The Constant EmptyFolder.
   */
  public static final String EmptyFolder = "EmptyFolder";

  /**
   * The Constant EmptyFolderResponse.
   */
  public static final String EmptyFolderResponse = "EmptyFolderResponse";

  /**
   * The Constant EmptyFolderResponseMessage.
   */
  public static final String EmptyFolderResponseMessage =
      "EmptyFolderResponseMessage";

  // UpdateFolder
  /**
   * The Constant UpdateFolder.
   */
  public static final String UpdateFolder = "UpdateFolder";

  /**
   * The Constant UpdateFolderResponse.
   */
  public static final String UpdateFolderResponse = "UpdateFolderResponse";

  /**
   * The Constant UpdateFolderResponseMessage.
   */
  public static final String UpdateFolderResponseMessage =
      "UpdateFolderResponseMessage";

  // CopyFolder
  /**
   * The Constant CopyFolder.
   */
  public static final String CopyFolder = "CopyFolder";

  /**
   * The Constant CopyFolderResponse.
   */
  public static final String CopyFolderResponse = "CopyFolderResponse";

  /**
   * The Constant CopyFolderResponseMessage.
   */
  public static final String CopyFolderResponseMessage =
      "CopyFolderResponseMessage";

  // MoveFolder
  /**
   * The Constant MoveFolder.
   */
  public static final String MoveFolder = "MoveFolder";

  /**
   * The Constant MoveFolderResponse.
   */
  public static final String MoveFolderResponse = "MoveFolderResponse";

  /**
   * The Constant MoveFolderResponseMessage.
   */
  public static final String MoveFolderResponseMessage =
      "MoveFolderResponseMessage";

  // GetAttachment
  /**
   * The Constant GetAttachment.
   */
  public static final String GetAttachment = "GetAttachment";

  /**
   * The Constant GetAttachmentResponse.
   */
  public static final String GetAttachmentResponse = "GetAttachmentResponse";

  /**
   * The Constant GetAttachmentResponseMessage.
   */
  public static final String GetAttachmentResponseMessage =
      "GetAttachmentResponseMessage";

  // CreateAttachment
  /**
   * The Constant CreateAttachment.
   */
  public static final String CreateAttachment = "CreateAttachment";

  /**
   * The Constant CreateAttachmentResponse.
   */
  public static final String CreateAttachmentResponse =
      "CreateAttachmentResponse";

  /**
   * The Constant CreateAttachmentResponseMessage.
   */
  public static final String CreateAttachmentResponseMessage =
      "CreateAttachmentResponseMessage";

  // DeleteAttachment
  /**
   * The Constant DeleteAttachment.
   */
  public static final String DeleteAttachment = "DeleteAttachment";

  /**
   * The Constant DeleteAttachmentResponse.
   */
  public static final String DeleteAttachmentResponse =
      "DeleteAttachmentResponse";

  /**
   * The Constant DeleteAttachmentResponseMessage.
   */
  public static final String DeleteAttachmentResponseMessage =
      "DeleteAttachmentResponseMessage";

  // ResolveNames
  /**
   * The Constant ResolveNames.
   */
  public static final String ResolveNames = "ResolveNames";

  /**
   * The Constant ResolveNamesResponse.
   */
  public static final String ResolveNamesResponse = "ResolveNamesResponse";

  /**
   * The Constant ResolveNamesResponseMessage.
   */
  public static final String ResolveNamesResponseMessage =
      "ResolveNamesResponseMessage";

  // ExpandDL
  /**
   * The Constant ExpandDL.
   */
  public static final String ExpandDL = "ExpandDL";

  /**
   * The Constant ExpandDLResponse.
   */
  public static final String ExpandDLResponse = "ExpandDLResponse";

  /**
   * The Constant ExpandDLResponseMessage.
   */
  public static final String ExpandDLResponseMessage =
      "ExpandDLResponseMessage";

  // Subscribe
  /**
   * The Constant Subscribe.
   */
  public static final String Subscribe = "Subscribe";

  /**
   * The Constant SubscribeResponse.
   */
  public static final String SubscribeResponse = "SubscribeResponse";

  /**
   * The Constant SubscribeResponseMessage.
   */
  public static final String SubscribeResponseMessage =
      "SubscribeResponseMessage";

  // Unsubscribe
  /**
   * The Constant Unsubscribe.
   */
  public static final String Unsubscribe = "Unsubscribe";

  /**
   * The Constant UnsubscribeResponse.
   */
  public static final String UnsubscribeResponse = "UnsubscribeResponse";

  /**
   * The Constant UnsubscribeResponseMessage.
   */
  public static final String UnsubscribeResponseMessage =
      "UnsubscribeResponseMessage";

  // GetEvents
  /**
   * The Constant GetEvents.
   */
  public static final String GetEvents = "GetEvents";

  /**
   * The Constant GetEventsResponse.
   */
  public static final String GetEventsResponse = "GetEventsResponse";

  /**
   * The Constant GetEventsResponseMessage.
   */
  public static final String GetEventsResponseMessage =
      "GetEventsResponseMessage";

  // GetStreamingEvents
  /**
   * The Constant GetStreamingEvents.
   */
  public static final String GetStreamingEvents = "GetStreamingEvents";

  /**
   * The Constant GetStreamingEventsResponse.
   */
  public static final String GetStreamingEventsResponse =
      "GetStreamingEventsResponse";

  /**
   * The Constant GetStreamingEventsResponseMessage.
   */
  public static final String GetStreamingEventsResponseMessage =
      "GetStreamingEventsResponseMessage";

  /**
   * The Constant ConnectionStatus.
   */
  public static final String ConnectionStatus = "ConnectionStatus";

  /**
   * The Constant ErrorSubscriptionIds.
   */
  public static final String ErrorSubscriptionIds = "ErrorSubscriptionIds";

  /**
   * The Constant ConnectionTimeout.
   */
  public static final String ConnectionTimeout = "ConnectionTimeout";

  /**
   * The Constant HeartbeatFrequency.
   */
  public static final String HeartbeatFrequency = "HeartbeatFrequency";


  // SyncFolderItems
  /**
   * The Constant SyncFolderItems.
   */
  public static final String SyncFolderItems = "SyncFolderItems";

  /**
   * The Constant SyncFolderItemsResponse.
   */
  public static final String SyncFolderItemsResponse =
      "SyncFolderItemsResponse";

  /**
   * The Constant SyncFolderItemsResponseMessage.
   */
  public static final String SyncFolderItemsResponseMessage =
      "SyncFolderItemsResponseMessage";

  // SyncFolderHierarchy
  /**
   * The Constant SyncFolderHierarchy.
   */
  public static final String SyncFolderHierarchy = "SyncFolderHierarchy";

  /**
   * The Constant SyncFolderHierarchyResponse.
   */
  public static final String SyncFolderHierarchyResponse =
      "SyncFolderHierarchyResponse";

  /**
   * The Constant SyncFolderHierarchyResponseMessage.
   */
  public static final String SyncFolderHierarchyResponseMessage =
      "SyncFolderHierarchyResponseMessage";

  // GetUserOofSettings
  /**
   * The Constant GetUserOofSettingsRequest.
   */
  public static final String GetUserOofSettingsRequest =
      "GetUserOofSettingsRequest";

  /**
   * The Constant GetUserOofSettingsResponse.
   */
  public static final String GetUserOofSettingsResponse =
      "GetUserOofSettingsResponse";

  // SetUserOofSettings
  /**
   * The Constant SetUserOofSettingsRequest.
   */
  public static final String SetUserOofSettingsRequest =
      "SetUserOofSettingsRequest";

  /**
   * The Constant SetUserOofSettingsResponse.
   */
  public static final String SetUserOofSettingsResponse =
      "SetUserOofSettingsResponse";

  // GetUserAvailability
  /**
   * The Constant GetUserAvailabilityRequest.
   */
  public static final String GetUserAvailabilityRequest =
      "GetUserAvailabilityRequest";

  /**
   * The Constant GetUserAvailabilityResponse.
   */
  public static final String GetUserAvailabilityResponse =
      "GetUserAvailabilityResponse";

  /**
   * The Constant FreeBusyResponseArray.
   */
  public static final String FreeBusyResponseArray = "FreeBusyResponseArray";

  /**
   * The Constant FreeBusyResponse.
   */
  public static final String FreeBusyResponse = "FreeBusyResponse";

  /**
   * The Constant SuggestionsResponse.
   */
  public static final String SuggestionsResponse = "SuggestionsResponse";

  // GetRoomLists
  /**
   * The Constant GetRoomListsRequest.
   */
  public static final String GetRoomListsRequest = "GetRoomLists";

  /**
   * The Constant GetRoomListsResponse.
   */
  public static final String GetRoomListsResponse = "GetRoomListsResponse";

  // GetRooms
  /**
   * The Constant GetRoomsRequest.
   */
  public static final String GetRoomsRequest = "GetRooms";

  /**
   * The Constant GetRoomsResponse.
   */
  public static final String GetRoomsResponse = "GetRoomsResponse";

  // ConvertId
  /**
   * The Constant ConvertId.
   */
  public static final String ConvertId = "ConvertId";

  /**
   * The Constant ConvertIdResponse.
   */
  public static final String ConvertIdResponse = "ConvertIdResponse";

  /**
   * The Constant ConvertIdResponseMessage.
   */
  public static final String ConvertIdResponseMessage =
      "ConvertIdResponseMessage";

  // AddDelegate
  /**
   * The Constant AddDelegate.
   */
  public static final String AddDelegate = "AddDelegate";

  /**
   * The Constant AddDelegateResponse.
   */
  public static final String AddDelegateResponse = "AddDelegateResponse";

  /**
   * The Constant DelegateUserResponseMessageType.
   */
  public static final String DelegateUserResponseMessageType =
      "DelegateUserResponseMessageType";

  // RemoveDelegte
  /**
   * The Constant RemoveDelegate.
   */
  public static final String RemoveDelegate = "RemoveDelegate";

  /**
   * The Constant RemoveDelegateResponse.
   */
  public static final String RemoveDelegateResponse = "RemoveDelegateResponse";

  // GetDelegate
  /**
   * The Constant GetDelegate.
   */
  public static final String GetDelegate = "GetDelegate";

  /**
   * The Constant GetDelegateResponse.
   */
  public static final String GetDelegateResponse = "GetDelegateResponse";

  // UpdateDelegate
  /**
   * The Constant UpdateDelegate.
   */
  public static final String UpdateDelegate = "UpdateDelegate";

  /**
   * The Constant UpdateDelegateResponse.
   */
  public static final String UpdateDelegateResponse = "UpdateDelegateResponse";

  // CreateUserConfiguration
  /**
   * The Constant CreateUserConfiguration.
   */
  public static final String CreateUserConfiguration =
      "CreateUserConfiguration";

  /**
   * The Constant CreateUserConfigurationResponse.
   */
  public static final String CreateUserConfigurationResponse =
      "CreateUserConfigurationResponse";

  /**
   * The Constant CreateUserConfigurationResponseMessage.
   */
  public static final String CreateUserConfigurationResponseMessage =
      "CreateUserConfigurationResponseMessage";

  // DeleteUserConfiguration
  /**
   * The Constant DeleteUserConfiguration.
   */
  public static final String DeleteUserConfiguration =
      "DeleteUserConfiguration";

  /**
   * The Constant DeleteUserConfigurationResponse.
   */
  public static final String DeleteUserConfigurationResponse =
      "DeleteUserConfigurationResponse";

  /**
   * The Constant DeleteUserConfigurationResponseMessage.
   */
  public static final String DeleteUserConfigurationResponseMessage =
      "DeleteUserConfigurationResponseMessage";

  // GetUserConfiguration
  /**
   * The Constant GetUserConfiguration.
   */
  public static final String GetUserConfiguration = "GetUserConfiguration";

  /**
   * The Constant GetUserConfigurationResponse.
   */
  public static final String GetUserConfigurationResponse =
      "GetUserConfigurationResponse";

  /**
   * The Constant GetUserConfigurationResponseMessage.
   */
  public static final String GetUserConfigurationResponseMessage =
      "GetUserConfigurationResponseMessage";

  // UpdateUserConfiguration
  /**
   * The Constant UpdateUserConfiguration.
   */
  public static final String UpdateUserConfiguration =
      "UpdateUserConfiguration";

  /**
   * The Constant UpdateUserConfigurationResponse.
   */
  public static final String UpdateUserConfigurationResponse =
      "UpdateUserConfigurationResponse";

  /**
   * The Constant UpdateUserConfigurationResponseMessage.
   */
  public static final String UpdateUserConfigurationResponseMessage =
      "UpdateUserConfigurationResponseMessage";

  // PlayOnPhone
  /**
   * The Constant PlayOnPhone.
   */
  public static final String PlayOnPhone = "PlayOnPhone";

  /**
   * The Constant PlayOnPhoneResponse.
   */
  public static final String PlayOnPhoneResponse = "PlayOnPhoneResponse";

  // GetPhoneCallInformation
  /**
   * The Constant GetPhoneCall.
   */
  public static final String GetPhoneCall = "GetPhoneCallInformation";

  /**
   * The Constant GetPhoneCallResponse.
   */
  public static final String GetPhoneCallResponse =
      "GetPhoneCallInformationResponse";

  // DisconnectCall
  /**
   * The Constant DisconnectPhoneCall.
   */
  public static final String DisconnectPhoneCall = "DisconnectPhoneCall";

  /**
   * The Constant DisconnectPhoneCallResponse.
   */
  public static final String DisconnectPhoneCallResponse =
      "DisconnectPhoneCallResponse";

  // GetServerTimeZones
  /**
   * The Constant GetServerTimeZones.
   */
  public static final String GetServerTimeZones = "GetServerTimeZones";

  /**
   * The Constant GetServerTimeZonesResponse.
   */
  public static final String GetServerTimeZonesResponse =
      "GetServerTimeZonesResponse";

  /**
   * The Constant GetServerTimeZonesResponseMessage.
   */
  public static final String GetServerTimeZonesResponseMessage =
      "GetServerTimeZonesResponseMessage";

  // GetInboxRules
  /**
   * The Constant GetInboxRules.
   */
  public static final String GetInboxRules = "GetInboxRules";

  /**
   * The Constant GetInboxRulesResponse.
   */
  public static final String GetInboxRulesResponse = "GetInboxRulesResponse";

  // UpdateInboxRules
  /**
   * The Constant UpdateInboxRules.
   */
  public static final String UpdateInboxRules = "UpdateInboxRules";

  /**
   * The Constant UpdateInboxRulesResponse.
   */
  public static final String UpdateInboxRulesResponse =
      "UpdateInboxRulesResponse";

  // ExecuteDiagnosticMethod
  /**
   * The Constant ExecuteDiagnosticMethod.
   */
  public static final String ExecuteDiagnosticMethod =
      "ExecuteDiagnosticMethod";

  /**
   * The Constant ExecuteDiagnosticMethodResponse.
   */
  public static final String ExecuteDiagnosticMethodResponse =
      "ExecuteDiagnosticMethodResponse";

  /**
   * The Constant ExecuteDiagnosticMethodResponseMEssage.
   */
  public static final String ExecuteDiagnosticMethodResponseMEssage =
      "ExecuteDiagnosticMethodResponseMessage";

  // GetPasswordExpirationDate
  /**
   * The Constant GetPasswordExpirationDate.
   */
  public static final String GetPasswordExpirationDateRequest =
      "GetPasswordExpirationDate";

  /**
   * The Constant GetPasswordExpirationDateResponse.
   */
  public static final String GetPasswordExpirationDateResponse =
      "GetPasswordExpirationDateResponse";

  // SOAP element names

  /**
   * The Constant SOAPEnvelopeElementName.
   */
  public static final String SOAPEnvelopeElementName = "Envelope";

  /**
   * The Constant SOAPHeaderElementName.
   */
  public static final String SOAPHeaderElementName = "Header";

  /**
   * The Constant SOAPBodyElementName.
   */
  public static final String SOAPBodyElementName = "Body";

  /**
   * The Constant SOAPFaultElementName.
   */
  public static final String SOAPFaultElementName = "Fault";

  /**
   * The Constant SOAPFaultCodeElementName.
   */
  public static final String SOAPFaultCodeElementName = "faultcode";

  /**
   * The Constant SOAPFaultStringElementName.
   */
  public static final String SOAPFaultStringElementName = "faultstring";

  /**
   * The Constant SOAPFaultActorElementName.
   */
  public static final String SOAPFaultActorElementName = "faultactor";

  /**
   * The Constant SOAPDetailElementName.
   */
  public static final String SOAPDetailElementName = "detail";

  /**
   * The Constant EwsResponseCodeElementName.
   */
  public static final String EwsResponseCodeElementName = "ResponseCode";

  /**
   * The Constant EwsMessageElementName.
   */
  public static final String EwsMessageElementName = "Message";

  /**
   * The Constant EwsLineElementName.
   */
  public static final String EwsLineElementName = "Line";

  /**
   * The Constant EwsPositionElementName.
   */
  public static final String EwsPositionElementName = "Position";

  /**
   * The Constant EwsErrorCodeElementName.
   */
  public static final String EwsErrorCodeElementName = "ErrorCode"; // Generated


  // by
  // Availability
  /**
   * The Constant EwsExceptionTypeElementName.
   */
  public static final String EwsExceptionTypeElementName = "ExceptionType"; // Generated

  // by
  // UM

}
