/*
 * The MIT License
 * Copyright (c) 2012 Microsoft Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package microsoft.exchange.webservices.data.core.enumeration.property;

/**
 * Defines phone number entries for a contact.
 */
public enum PhoneNumberKey {

  // The assistant's phone number.
  /**
   * The Assistant phone.
   */
  AssistantPhone,

  // The business fax number.
  /**
   * The Business fax.
   */
  BusinessFax,

  // The business phone number.
  /**
   * The Business phone.
   */
  BusinessPhone,

  // The second business phone number.
  /**
   * The Business phone2.
   */
  BusinessPhone2,

  // The callback number.
  /**
   * The Callback.
   */
  Callback,

  // The car phone number.
  /**
   * The Car phone.
   */
  CarPhone,

  // The company's main phone number.
  /**
   * The Company main phone.
   */
  CompanyMainPhone,

  // The home fax number.
  /**
   * The Home fax.
   */
  HomeFax,

  // The home phone number.
  /**
   * The Home phone.
   */
  HomePhone,

  // The second home phone number.
  /**
   * The Home phone2.
   */
  HomePhone2,

  // The ISDN number.
  /**
   * The Isdn.
   */
  Isdn,

  // The mobile phone number.
  /**
   * The Mobile phone.
   */
  MobilePhone,

  // An alternate fax number.
  /**
   * The Other fax.
   */
  OtherFax,

  // An alternate phone number.
  /**
   * The Other telephone.
   */
  OtherTelephone,

  // The pager number.
  /**
   * The Pager.
   */
  Pager,

  // The primary phone number.
  /**
   * The Primary phone.
   */
  PrimaryPhone,

  // The radio phone number.
  /**
   * The Radio phone.
   */
  RadioPhone,

  // The Telex number.
  /**
   * The Telex.
   */
  Telex,

  // The TTY/TTD phone number.
  /**
   * The Tty tdd phone.
   */
  TtyTddPhone
}
