/*
 * The MIT License
 * Copyright (c) 2012 Microsoft Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package microsoft.exchange.webservices.data.core.enumeration.property;

/**
 * Identifies the user configuration dictionary key and value types.
 */
public enum UserConfigurationDictionaryObjectType {

  // DateTime type.
  /**
   * The Date time.
   */
  DateTime,

  // Boolean type.
  /**
   * The Boolean.
   */
  Boolean,

  // Byte type.
  /**
   * The Byte.
   */
  Byte,

  // String type.
  /**
   * The String.
   */
  String,

  // 32-bit integer type.
  /**
   * The Integer32.
   */
  Integer32,

  // 32-bit unsigned integer type.
  /**
   * The Unsigned integer32.
   */
  UnsignedInteger32,

  // 64-bit integer type.
  /**
   * The Integer64.
   */
  Integer64,

  // 64-bit unsigned integer type.
  /**
   * The Unsigned integer64.
   */
  UnsignedInteger64,

  // String array type.
  /**
   * The String array.
   */
  StringArray,

  // Byte array type
  /**
   * The Byte array.
   */
  ByteArray,

}
