/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.autodiscover.request;

import java.net.URI;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.autodiscover.AutodiscoverService;
import microsoft.exchange.webservices.data.autodiscover.enumeration.AutodiscoverErrorCode;
import microsoft.exchange.webservices.data.autodiscover.enumeration.DomainSettingName;
import microsoft.exchange.webservices.data.autodiscover.request.AutodiscoverRequest;
import microsoft.exchange.webservices.data.autodiscover.response.AutodiscoverResponse;
import microsoft.exchange.webservices.data.autodiscover.response.GetDomainSettingsResponse;
import microsoft.exchange.webservices.data.autodiscover.response.GetDomainSettingsResponseCollection;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceValidationException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;

public class GetDomainSettingsRequest
extends AutodiscoverRequest {
    private static final String GetDomainSettingsActionUri = "http://schemas.microsoft.com/exchange/2010/Autodiscover/Autodiscover/GetDomainSettings";
    private List<String> domains;
    private List<DomainSettingName> settings;
    private ExchangeVersion requestedVersion;

    public GetDomainSettingsRequest(AutodiscoverService service, URI url) {
        super(service, url);
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParam(this.getDomains(), "domains");
        EwsUtilities.validateParam(this.getSettings(), "settings");
        if (this.getSettings().size() == 0) {
            throw new ServiceValidationException("At least one setting must be requested.");
        }
        if (this.domains.size() == 0) {
            throw new ServiceValidationException("At least one domain name must be requested.");
        }
        for (String domain : this.getDomains()) {
            if (domain != null && !domain.isEmpty()) continue;
            throw new ServiceValidationException("The domain name must be specified.");
        }
    }

    public GetDomainSettingsResponseCollection execute() throws Exception {
        GetDomainSettingsResponseCollection responses = (GetDomainSettingsResponseCollection)this.internalExecute();
        if (responses.getErrorCode() == AutodiscoverErrorCode.NoError) {
            this.PostProcessResponses(responses);
        }
        return responses;
    }

    private void PostProcessResponses(GetDomainSettingsResponseCollection responses) {
        for (int index = 0; index < responses.getCount(); ++index) {
            ((GetDomainSettingsResponse)responses.getResponses().get(index)).setDomain(this.getDomains().get(index));
        }
    }

    @Override
    protected String getRequestXmlElementName() {
        return "GetDomainSettingsRequestMessage";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "GetDomainSettingsResponseMessage";
    }

    @Override
    protected String getWsAddressingActionName() {
        return GetDomainSettingsActionUri;
    }

    @Override
    protected AutodiscoverResponse createServiceResponse() {
        return new GetDomainSettingsResponseCollection();
    }

    @Override
    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        writer.writeAttributeValue("xmlns", "a", (Object)"http://schemas.microsoft.com/exchange/2010/Autodiscover");
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        writer.writeStartElement(XmlNamespace.Autodiscover, "Request");
        writer.writeStartElement(XmlNamespace.Autodiscover, "Domains");
        for (String domain : this.getDomains()) {
            if (domain == null || domain.isEmpty()) continue;
            writer.writeElementValue(XmlNamespace.Autodiscover, "Domain", domain);
        }
        writer.writeEndElement();
        writer.writeStartElement(XmlNamespace.Autodiscover, "RequestedSettings");
        for (DomainSettingName setting : this.settings) {
            writer.writeElementValue(XmlNamespace.Autodiscover, "Setting", (Object)setting);
        }
        writer.writeEndElement();
        if (this.requestedVersion != null) {
            writer.writeElementValue(XmlNamespace.Autodiscover, "RequestedVersion", (Object)this.requestedVersion);
        }
        writer.writeEndElement();
    }

    protected List<String> getDomains() {
        return this.domains;
    }

    public void setDomains(List<String> value) {
        this.domains = value;
    }

    protected List<DomainSettingName> getSettings() {
        return this.settings;
    }

    public void setSettings(List<DomainSettingName> value) {
        this.settings = value;
    }

    protected ExchangeVersion getRequestedVersion() {
        return this.requestedVersion;
    }

    public void setRequestedVersion(ExchangeVersion value) {
        this.requestedVersion = value;
    }
}

