/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeServiceBase;
import microsoft.exchange.webservices.data.core.IDisposable;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.misc.OutParam;
import microsoft.exchange.webservices.data.property.complex.ISearchStringProvider;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class EwsServiceXmlWriter
implements IDisposable {
    private static final Log LOG = LogFactory.getLog(EwsServiceXmlWriter.class);
    private boolean isDisposed;
    private ExchangeServiceBase service;
    private XMLStreamWriter xmlWriter;
    private boolean isTimeZoneHeaderEmitted;
    private static final int BufferSize = 4096;
    protected boolean requireWSSecurityUtilityNamespace;

    public EwsServiceXmlWriter(ExchangeServiceBase service, OutputStream stream) throws XMLStreamException {
        this.service = service;
        XMLOutputFactory xmlof = XMLOutputFactory.newInstance();
        this.xmlWriter = xmlof.createXMLStreamWriter(stream, "utf-8");
    }

    protected boolean tryConvertObjectToString(Object value, OutParam<String> str) {
        boolean converted = true;
        str.setParam((Object)null);
        if (value != null) {
            if (value.getClass().isEnum()) {
                str.setParam((Object)EwsUtilities.serializeEnum(value));
            } else if (value.getClass().equals(Boolean.class)) {
                str.setParam((Object)EwsUtilities.boolToXSBool((Boolean)value));
            } else if (value instanceof Date) {
                str.setParam((Object)this.service.convertDateTimeToUniversalDateTimeString((Date)value));
            } else if (value.getClass().isPrimitive()) {
                str.setParam((Object)value.toString());
            } else if (value instanceof String) {
                str.setParam((Object)value.toString());
            } else if (value instanceof ISearchStringProvider) {
                ISearchStringProvider searchStringProvider = (ISearchStringProvider)value;
                str.setParam((Object)searchStringProvider.getSearchString());
            } else if (value instanceof Number) {
                str.setParam((Object)value.toString());
            } else {
                converted = false;
            }
        }
        return converted;
    }

    @Override
    public void dispose() {
        if (!this.isDisposed) {
            try {
                this.xmlWriter.close();
            }
            catch (XMLStreamException e) {
                LOG.error((Object)e);
            }
            this.isDisposed = true;
        }
    }

    public void flush() throws XMLStreamException {
        this.xmlWriter.flush();
    }

    public void writeStartElement(XmlNamespace xmlNamespace, String localName) throws XMLStreamException {
        String strPrefix = EwsUtilities.getNamespacePrefix(xmlNamespace);
        String strNameSpace = EwsUtilities.getNamespaceUri(xmlNamespace);
        this.xmlWriter.writeStartElement(strPrefix, localName, strNameSpace);
    }

    public void writeEndElement() throws XMLStreamException {
        this.xmlWriter.writeEndElement();
    }

    public void writeAttributeValue(String localName, Object value) throws ServiceXmlSerializationException {
        this.writeAttributeValue(localName, false, value);
    }

    public void writeAttributeValue(String localName, boolean alwaysWriteEmptyString, Object value) throws ServiceXmlSerializationException {
        OutParam<String> stringOut = new OutParam<String>();
        String stringValue = null;
        if (this.tryConvertObjectToString(value, stringOut)) {
            stringValue = (String)stringOut.getParam();
            if (null != stringValue && (alwaysWriteEmptyString || stringValue.length() != 0)) {
                this.writeAttributeString(localName, stringValue);
            }
        } else {
            throw new ServiceXmlSerializationException(String.format("Values of type '%s' can't be used for the '%s' attribute.", value.getClass().getName(), localName));
        }
    }

    public void writeAttributeValue(String namespacePrefix, String localName, Object value) throws ServiceXmlSerializationException {
        OutParam<String> stringOut = new OutParam<String>();
        String stringValue = null;
        if (this.tryConvertObjectToString(value, stringOut)) {
            stringValue = (String)stringOut.getParam();
            if (null != stringValue && !stringValue.isEmpty()) {
                this.writeAttributeString(namespacePrefix, localName, stringValue);
            }
        } else {
            throw new ServiceXmlSerializationException(String.format("Values of type '%s' can't be used for the '%s' attribute.", value.getClass().getName(), localName));
        }
    }

    protected void writeAttributeString(String localName, String stringValue) throws ServiceXmlSerializationException {
        try {
            this.xmlWriter.writeAttribute(localName, stringValue);
        }
        catch (XMLStreamException e) {
            throw new ServiceXmlSerializationException(String.format("The invalid value '%s' was specified for the '%s' attribute.", stringValue, localName), e);
        }
    }

    protected void writeAttributeString(String namespacePrefix, String localName, String stringValue) throws ServiceXmlSerializationException {
        try {
            this.xmlWriter.writeAttribute(namespacePrefix, "", localName, stringValue);
        }
        catch (XMLStreamException e) {
            throw new ServiceXmlSerializationException(String.format("The invalid value '%s' was specified for the '%s' attribute.", stringValue, localName), e);
        }
    }

    public void writeValue(String value, String name) throws ServiceXmlSerializationException {
        try {
            this.xmlWriter.writeCharacters(value);
        }
        catch (XMLStreamException e) {
            throw new ServiceXmlSerializationException(String.format("The invalid value '%s' was specified for the '%s' element.", value, name), e);
        }
    }

    public void writeElementValue(XmlNamespace xmlNamespace, String localName, String displayName, Object value) throws XMLStreamException, ServiceXmlSerializationException {
        String stringValue = null;
        OutParam<String> strOut = new OutParam<String>();
        if (this.tryConvertObjectToString(value, strOut)) {
            stringValue = (String)strOut.getParam();
            if (null != stringValue) {
                this.writeStartElement(xmlNamespace, localName);
                this.writeValue(stringValue, displayName);
                this.writeEndElement();
            }
        } else {
            throw new ServiceXmlSerializationException(String.format("Values of type '%s' can't be used for the '%s' element.", value.getClass().getName(), localName));
        }
    }

    public void writeNode(Node xmlNode) throws XMLStreamException {
        if (xmlNode != null) {
            EwsServiceXmlWriter.writeNode(xmlNode, this.xmlWriter);
        }
    }

    public static void writeNode(Node xmlNode, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        if (xmlNode instanceof Element) {
            EwsServiceXmlWriter.addElement((Element)xmlNode, xmlStreamWriter);
        } else if (xmlNode instanceof Text) {
            xmlStreamWriter.writeCharacters(xmlNode.getNodeValue());
        } else if (xmlNode instanceof CDATASection) {
            xmlStreamWriter.writeCData(((CDATASection)xmlNode).getData());
        } else if (xmlNode instanceof Comment) {
            xmlStreamWriter.writeComment(((Comment)xmlNode).getData());
        } else if (xmlNode instanceof EntityReference) {
            xmlStreamWriter.writeEntityRef(xmlNode.getNodeValue());
        } else if (xmlNode instanceof ProcessingInstruction) {
            ProcessingInstruction procInst = (ProcessingInstruction)xmlNode;
            xmlStreamWriter.writeProcessingInstruction(procInst.getTarget(), procInst.getData());
        } else if (xmlNode instanceof Document) {
            EwsServiceXmlWriter.writeToDocument((Document)xmlNode, xmlStreamWriter);
        }
    }

    public static void writeToDocument(Document document, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        xmlStreamWriter.writeStartDocument();
        Element rootElement = document.getDocumentElement();
        EwsServiceXmlWriter.addElement(rootElement, xmlStreamWriter);
        xmlStreamWriter.writeEndDocument();
    }

    public static void addElement(Element element, XMLStreamWriter writer) throws XMLStreamException {
        boolean declareNamespace;
        String nameSpace = element.getNamespaceURI();
        String prefix = element.getPrefix();
        String localName = element.getLocalName();
        if (prefix == null) {
            prefix = "";
        }
        if (localName == null && (localName = element.getNodeName()) == null) {
            throw new IllegalStateException("Element's local name cannot be null!");
        }
        String decUri = writer.getNamespaceContext().getNamespaceURI(prefix);
        boolean bl = declareNamespace = decUri == null || !decUri.equals(nameSpace);
        if (nameSpace == null || nameSpace.length() == 0) {
            writer.writeStartElement(localName);
        } else {
            writer.writeStartElement(prefix, localName, nameSpace);
        }
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            String attrPrefix = "";
            int prefixIndex = name.indexOf(58);
            if (prefixIndex != -1) {
                attrPrefix = name.substring(0, prefixIndex);
                name = name.substring(prefixIndex + 1);
            }
            if ("xmlns".equals(attrPrefix)) {
                writer.writeNamespace(name, attr.getNodeValue());
                if (!name.equals(prefix) || !attr.getNodeValue().equals(nameSpace)) continue;
                declareNamespace = false;
                continue;
            }
            if ("xmlns".equals(name) && "".equals(attrPrefix)) {
                writer.writeNamespace("", attr.getNodeValue());
                if (!attr.getNodeValue().equals(nameSpace)) continue;
                declareNamespace = false;
                continue;
            }
            writer.writeAttribute(attrPrefix, attr.getNamespaceURI(), name, attr.getNodeValue());
        }
        if (declareNamespace) {
            if (nameSpace == null) {
                writer.writeNamespace(prefix, "");
            } else {
                writer.writeNamespace(prefix, nameSpace);
            }
        }
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            EwsServiceXmlWriter.writeNode(n, writer);
        }
        writer.writeEndElement();
    }

    public void writeElementValue(XmlNamespace xmlNamespace, String localName, Object value) throws XMLStreamException, ServiceXmlSerializationException {
        this.writeElementValue(xmlNamespace, localName, localName, value);
    }

    public void writeBase64ElementValue(byte[] buffer) throws XMLStreamException {
        String strValue = Base64.encodeBase64String((byte[])buffer);
        this.xmlWriter.writeCharacters(strValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBase64ElementValue(InputStream stream) throws IOException, XMLStreamException {
        byte[] buf = new byte[4096];
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int readNum;
            while ((readNum = stream.read(buf)) != -1) {
                bos.write(buf, 0, readNum);
            }
        }
        byte[] bytes = bos.toByteArray();
        String strValue = Base64.encodeBase64String((byte[])bytes);
        this.xmlWriter.writeCharacters(strValue);
    }

    public XMLStreamWriter getInternalWriter() {
        return this.xmlWriter;
    }

    public ExchangeServiceBase getService() {
        return this.service;
    }

    public boolean isRequireWSSecurityUtilityNamespace() {
        return this.requireWSSecurityUtilityNamespace;
    }

    public void setRequireWSSecurityUtilityNamespace(boolean requireWSSecurityUtilityNamespace) {
        this.requireWSSecurityUtilityNamespace = requireWSSecurityUtilityNamespace;
    }

    public boolean isTimeZoneHeaderEmitted() {
        return this.isTimeZoneHeaderEmitted;
    }

    public void setTimeZoneHeaderEmitted(boolean isTimeZoneHeaderEmitted) {
        this.isTimeZoneHeaderEmitted = isTimeZoneHeaderEmitted;
    }

    public void writeStartDocument() throws XMLStreamException {
        this.xmlWriter.writeStartDocument("utf-8", "1.0");
    }
}

