/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.service.error.ServiceErrorHandling;
import microsoft.exchange.webservices.data.core.request.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.core.response.ExportItemsResponse;
import microsoft.exchange.webservices.data.misc.ItemIdWrapperList;

public final class ExportItemsRequest
extends MultiResponseServiceRequest<ExportItemsResponse> {
    private ItemIdWrapperList itemIds = new ItemIdWrapperList();

    public ExportItemsRequest(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    @Override
    protected void validate() throws Exception {
        EwsUtilities.validateParamCollection(this.itemIds.iterator(), "itemIds");
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return this.itemIds.getCount();
    }

    @Override
    protected ExportItemsResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new ExportItemsResponse();
    }

    @Override
    public String getXmlElementName() {
        return "ExportItems";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "ExportItemsResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "ExportItemsResponseMessage";
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        this.itemIds.writeToXml(writer, XmlNamespace.Messages, "ItemIds");
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2010_SP1;
    }

    public ItemIdWrapperList getItemIds() {
        return this.itemIds;
    }
}

