/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import microsoft.exchange.webservices.data.core.WebProxy;
import microsoft.exchange.webservices.data.core.exception.http.EWSHttpException;

public abstract class HttpWebRequest
implements Closeable {
    private URL url;
    private boolean preAuthenticate;
    private int timeout;
    private String contentType = "text/xml; charset=utf-8";
    private String accept = "text/xml";
    private String userAgent = "EWS SDK";
    private boolean allowAutoRedirect;
    private boolean keepAlive = true;
    private boolean acceptGzipEncoding;
    private boolean useDefaultCredentials;
    private boolean allowAuthentication = true;
    private String username;
    private String password;
    private String domain;
    private String requestMethod = "POST";
    private Map<String, String> headers;
    private WebProxy proxy;

    public WebProxy getProxy() {
        return this.proxy;
    }

    public void setProxy(WebProxy proxy) {
        this.proxy = proxy;
    }

    public boolean isHttpScheme() {
        return this.getUrl().getProtocol().equalsIgnoreCase("http");
    }

    public boolean isHttpsScheme() {
        return this.getUrl().getProtocol().equalsIgnoreCase("https");
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public boolean isPreAuthenticate() {
        return this.preAuthenticate;
    }

    public void setPreAuthenticate(boolean preAuthenticate) {
        this.preAuthenticate = preAuthenticate;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getAccept() {
        return this.accept;
    }

    public void setAccept(String accept) {
        this.accept = accept;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public boolean isAllowAutoRedirect() {
        return this.allowAutoRedirect;
    }

    public void setAllowAutoRedirect(boolean allowAutoRedirect) {
        this.allowAutoRedirect = allowAutoRedirect;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean isAcceptGzipEncoding() {
        return this.acceptGzipEncoding;
    }

    public void setAcceptGzipEncoding(boolean acceptGzipEncoding) {
        this.acceptGzipEncoding = acceptGzipEncoding;
    }

    public boolean isUseDefaultCredentials() {
        return this.useDefaultCredentials;
    }

    public void setUseDefaultCredentials(boolean useDefaultCredentials) {
        this.useDefaultCredentials = useDefaultCredentials;
    }

    public boolean isAllowAuthentication() {
        return this.allowAuthentication;
    }

    public void setAllowAuthentication(boolean allowAuthentication) {
        this.allowAuthentication = allowAuthentication;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setCredentials(String domain, String user, String pwd) {
        this.domain = domain;
        this.username = user;
        this.password = pwd;
    }

    public abstract InputStream getInputStream() throws EWSHttpException, IOException;

    public abstract InputStream getErrorStream() throws EWSHttpException;

    public abstract OutputStream getOutputStream() throws EWSHttpException;

    @Override
    public abstract void close() throws IOException;

    public abstract void prepareConnection();

    public abstract Map<String, String> getResponseHeaders() throws EWSHttpException;

    public abstract String getContentEncoding() throws EWSHttpException;

    public abstract String getResponseContentType() throws EWSHttpException;

    public abstract int getResponseCode() throws EWSHttpException;

    public abstract String getResponseText() throws EWSHttpException;

    public abstract String getResponseHeaderField(String var1) throws EWSHttpException;

    public abstract Map<String, String> getRequestProperty() throws EWSHttpException;

    public abstract int executeRequest() throws EWSHttpException, IOException;
}

