/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import java.net.URI;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.misc.ArgumentException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.core.request.SubscribeRequest;
import microsoft.exchange.webservices.data.core.response.SubscribeResponse;
import microsoft.exchange.webservices.data.notification.PushSubscription;

public class SubscribeToPushNotificationsRequest
extends SubscribeRequest<PushSubscription> {
    private int frequency = 30;
    private URI url;

    public SubscribeToPushNotificationsRequest(ExchangeService service) throws Exception {
        super(service);
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParam(this.getUrl(), "Url");
        if (this.getFrequency() < 1 || this.getFrequency() > 1440) {
            throw new ArgumentException(String.format("%d is not a valid frequency value. Valid values range from 1 to 1440.", this.getFrequency()));
        }
    }

    @Override
    protected String getSubscriptionXmlElementName() {
        return "PushSubscriptionRequest";
    }

    @Override
    protected void internalWriteElementsToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        writer.writeElementValue(XmlNamespace.Types, "StatusFrequency", this.getFrequency());
        writer.writeElementValue(XmlNamespace.Types, "URL", this.getUrl().toString());
    }

    @Override
    protected SubscribeResponse<PushSubscription> createServiceResponse(ExchangeService service, int responseIndex) throws Exception {
        return new SubscribeResponse<PushSubscription>(new PushSubscription(service));
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public URI getUrl() {
        return this.url;
    }

    public void setUrl(URI url) {
        this.url = url;
    }
}

