/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import java.util.List;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.service.error.ServiceErrorHandling;
import microsoft.exchange.webservices.data.core.request.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.core.response.UploadItemsResponse;
import microsoft.exchange.webservices.data.core.service.item.UploadItem;

public class UploadItemsRequest
extends MultiResponseServiceRequest<UploadItemsResponse> {
    private List<UploadItem> items;

    public UploadItemsRequest(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParam(this.items, "items");
        for (UploadItem i : this.items) {
            i.validate();
        }
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return this.items.size();
    }

    @Override
    protected UploadItemsResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new UploadItemsResponse();
    }

    @Override
    public String getXmlElementName() {
        return "UploadItems";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "UploadItemsResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "UploadItemsResponseMessage";
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        if (!this.items.isEmpty()) {
            writer.writeStartElement(XmlNamespace.Messages, "Items");
            this.items.stream().forEach(item -> item.writeToXml(writer));
            writer.writeEndElement();
        }
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2010_SP1;
    }

    public void setItems(List<UploadItem> items) {
        this.items = items;
    }

    public List<UploadItem> getItems() {
        return this.items;
    }
}

