/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.response;

import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.service.ServiceResult;
import microsoft.exchange.webservices.data.core.response.IGetObjectInstanceDelegate;
import microsoft.exchange.webservices.data.core.response.ServiceResponse;
import microsoft.exchange.webservices.data.core.service.ServiceObject;
import microsoft.exchange.webservices.data.core.service.item.Item;

public final class UpdateItemResponse
extends ServiceResponse
implements IGetObjectInstanceDelegate<ServiceObject> {
    private Item item;
    private Item returnedItem;
    private int conflictCount;

    public UpdateItemResponse(Item item) {
        EwsUtilities.ewsAssert(item != null, "UpdateItemResponse.ctor", "item is null");
        this.item = item;
    }

    @Override
    protected void readElementsFromXml(EwsServiceXmlReader reader) throws Exception {
        super.readElementsFromXml(reader);
        reader.readServiceObjectsCollectionFromXml("Items", this, false, null, false);
        if (!reader.getService().getExchange2007CompatibilityMode()) {
            reader.readStartElement(XmlNamespace.Messages, "ConflictResults");
            this.conflictCount = reader.readElementValue(Integer.class, XmlNamespace.Types, "Count");
            reader.readEndElement(XmlNamespace.Messages, "ConflictResults");
        }
        if (this.returnedItem != null && this.item.getId().getUniqueId().equals(this.returnedItem.getId().getUniqueId())) {
            this.item.getId().setChangeKey(this.returnedItem.getId().getChangeKey());
            this.returnedItem = null;
        }
    }

    @Override
    public ServiceObject getObjectInstanceDelegate(ExchangeService service, String xmlElementName) throws Exception {
        return this.getObjectInstance(service, xmlElementName);
    }

    @Override
    protected void loaded() {
        if (this.getResult() == ServiceResult.Success) {
            this.item.clearChangeLog();
        }
    }

    private Item getObjectInstance(ExchangeService service, String xmlElementName) throws Exception {
        this.returnedItem = (Item)EwsUtilities.createEwsObjectFromXmlElementName(Item.class, service, xmlElementName);
        return this.returnedItem;
    }

    public Item getReturnedItem() {
        return this.returnedItem;
    }

    public int getConflictCount() {
        return this.conflictCount;
    }
}

