/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.service.item;

import java.util.Arrays;
import microsoft.exchange.webservices.data.attribute.Attachable;
import microsoft.exchange.webservices.data.attribute.ServiceObjectDefinition;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.property.WellKnownFolderName;
import microsoft.exchange.webservices.data.core.enumeration.service.ConflictResolutionMode;
import microsoft.exchange.webservices.data.core.enumeration.service.MessageDisposition;
import microsoft.exchange.webservices.data.core.enumeration.service.ResponseMessageType;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.service.item.Item;
import microsoft.exchange.webservices.data.core.service.response.ResponseMessage;
import microsoft.exchange.webservices.data.core.service.response.SuppressReadReceipt;
import microsoft.exchange.webservices.data.core.service.schema.EmailMessageSchema;
import microsoft.exchange.webservices.data.core.service.schema.ServiceObjectSchema;
import microsoft.exchange.webservices.data.property.complex.EmailAddress;
import microsoft.exchange.webservices.data.property.complex.EmailAddressCollection;
import microsoft.exchange.webservices.data.property.complex.FolderId;
import microsoft.exchange.webservices.data.property.complex.ItemAttachment;
import microsoft.exchange.webservices.data.property.complex.ItemId;
import microsoft.exchange.webservices.data.property.complex.MessageBody;

@Attachable
@ServiceObjectDefinition(xmlElementName="Message")
public class EmailMessage
extends Item {
    public EmailMessage(ExchangeService service) throws Exception {
        super(service);
    }

    public EmailMessage(ExchangeService service, ItemId itemId) throws Exception {
        super(service, itemId);
    }

    public EmailMessage(ItemAttachment parentAttachment) throws Exception {
        super(parentAttachment);
    }

    public static EmailMessage bind(ExchangeService service, ItemId id, PropertySet propertySet) throws Exception {
        return service.bindToItem(EmailMessage.class, id, propertySet);
    }

    public static EmailMessage bind(ExchangeService service, ItemId id) throws Exception {
        return EmailMessage.bind(service, id, PropertySet.getFirstClassProperties());
    }

    @Override
    public ServiceObjectSchema getSchema() {
        return EmailMessageSchema.Instance;
    }

    @Override
    public ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    private void internalSend(FolderId parentFolderId, MessageDisposition messageDisposition) throws Exception {
        this.throwIfThisIsAttachment();
        if (this.isNew()) {
            if (this.getAttachments().getCount() == 0 || messageDisposition == MessageDisposition.SaveOnly) {
                this.internalCreate(parentFolderId, messageDisposition, null);
            } else {
                this.internalCreate(null, MessageDisposition.SaveOnly, null);
                this.getService().sendItem(this, parentFolderId);
            }
        } else if (this.isDirty()) {
            this.getAttachments().validate();
            this.getAttachments().save();
            if (this.getPropertyBag().getIsUpdateCallNecessary()) {
                this.internalUpdate(parentFolderId, ConflictResolutionMode.AutoResolve, messageDisposition, null);
            } else {
                this.getService().sendItem(this, parentFolderId);
            }
        } else {
            this.getService().sendItem(this, parentFolderId);
        }
    }

    public ResponseMessage createReply(boolean replyAll) throws Exception {
        this.throwIfThisIsNew();
        return new ResponseMessage(this, replyAll ? ResponseMessageType.ReplyAll : ResponseMessageType.Reply);
    }

    public ResponseMessage createForward() throws Exception {
        this.throwIfThisIsNew();
        return new ResponseMessage(this, ResponseMessageType.Forward);
    }

    public void reply(MessageBody bodyPrefix, boolean replyAll) throws Exception {
        ResponseMessage responseMessage = this.createReply(replyAll);
        responseMessage.setBodyPrefix(bodyPrefix);
        responseMessage.sendAndSaveCopy();
    }

    public void forward(MessageBody bodyPrefix, EmailAddress ... toRecipients) throws Exception {
        if (null != toRecipients) {
            this.forward(bodyPrefix, Arrays.asList(toRecipients));
        }
    }

    public void forward(MessageBody bodyPrefix, Iterable<EmailAddress> toRecipients) throws Exception {
        ResponseMessage responseMessage = this.createForward();
        responseMessage.setBodyPrefix(bodyPrefix);
        responseMessage.getToRecipients().addEmailRange(toRecipients.iterator());
        responseMessage.sendAndSaveCopy();
    }

    public void send() throws Exception {
        this.internalSend(null, MessageDisposition.SendOnly);
    }

    public void sendAndSaveCopy(FolderId destinationFolderId) throws Exception {
        EwsUtilities.validateParam(destinationFolderId, "destinationFolderId");
        this.internalSend(destinationFolderId, MessageDisposition.SendAndSaveCopy);
    }

    public void sendAndSaveCopy(WellKnownFolderName destinationFolderName) throws Exception {
        this.internalSend(new FolderId(destinationFolderName), MessageDisposition.SendAndSaveCopy);
    }

    public void sendAndSaveCopy() throws Exception {
        this.internalSend(new FolderId(WellKnownFolderName.SentItems), MessageDisposition.SendAndSaveCopy);
    }

    public void suppressReadReceipt() throws Exception {
        this.throwIfThisIsNew();
        new SuppressReadReceipt(this).internalCreate(null, null);
    }

    public EmailAddressCollection getToRecipients() throws ServiceLocalException {
        return (EmailAddressCollection)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.ToRecipients);
    }

    public EmailAddressCollection getBccRecipients() throws ServiceLocalException {
        return (EmailAddressCollection)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.BccRecipients);
    }

    public EmailAddressCollection getCcRecipients() throws ServiceLocalException {
        return (EmailAddressCollection)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.CcRecipients);
    }

    public String getConversationTopic() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.ConversationTopic);
    }

    public byte[] getConversationIndex() throws ServiceLocalException {
        return (byte[])this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.ConversationIndex);
    }

    public EmailAddress getFrom() throws ServiceLocalException {
        return (EmailAddress)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.From);
    }

    public void setFrom(EmailAddress value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(EmailMessageSchema.From, value);
    }

    @Override
    public boolean getIsAssociated() throws ServiceLocalException {
        return super.getIsAssociated();
    }

    public void setIsAssociated(boolean value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(EmailMessageSchema.IsAssociated, value);
    }

    public Boolean getIsDeliveryReceiptRequested() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.IsDeliveryReceiptRequested);
    }

    public void setIsDeliveryReceiptRequested(Boolean value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(EmailMessageSchema.IsDeliveryReceiptRequested, value);
    }

    public Boolean getIsRead() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.IsRead);
    }

    public void setIsRead(Boolean value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(EmailMessageSchema.IsRead, value);
    }

    public Boolean getIsReadReceiptRequested() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.IsReadReceiptRequested);
    }

    public void setIsReadReceiptRequested(Boolean value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(EmailMessageSchema.IsReadReceiptRequested, value);
    }

    public Boolean getIsResponseRequested() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.IsResponseRequested);
    }

    public void setIsResponseRequested(Boolean value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(EmailMessageSchema.IsResponseRequested, value);
    }

    public String getInternetMessageId() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.InternetMessageId);
    }

    public String getReferences() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.References);
    }

    public void setReferences(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(EmailMessageSchema.References, value);
    }

    public EmailAddressCollection getReplyTo() throws ServiceLocalException {
        return (EmailAddressCollection)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.ReplyTo);
    }

    public EmailAddress getSender() throws ServiceLocalException {
        return (EmailAddress)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.Sender);
    }

    public void setSender(EmailAddress value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(EmailMessageSchema.Sender, value);
    }

    public EmailAddress getReceivedBy() throws ServiceLocalException {
        return (EmailAddress)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.ReceivedBy);
    }

    public EmailAddress getReceivedRepresenting() throws ServiceLocalException {
        return (EmailAddress)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.ReceivedRepresenting);
    }
}

