/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.service.item;

import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.property.complex.FolderId;
import microsoft.exchange.webservices.data.property.complex.ItemId;

public class UploadItem {
    private CreateAction createAction;
    private FolderId parentFolderId;
    private ItemId itemId;
    private byte[] data;

    public void writeToXml(EwsServiceXmlWriter writer) {
        try {
            writer.writeStartElement(XmlNamespace.Types, "Item");
            writer.writeAttributeValue("CreateAction", (Object)this.createAction);
            this.parentFolderId.writeToXml(writer, "ParentFolderId");
            if (this.itemId != null) {
                this.itemId.writeToXml(writer);
            }
            writer.writeStartElement(XmlNamespace.Types, "Data");
            writer.writeBase64ElementValue(this.data);
            writer.writeEndElement();
            writer.writeEndElement();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void validate() throws Exception {
        EwsUtilities.validateParam((Object)this.createAction, "createAction");
        EwsUtilities.validateParam(this.parentFolderId, "parentFolderId");
        EwsUtilities.validateParam(this.data, "data");
        if (this.createAction == CreateAction.Update) {
            EwsUtilities.validateParam(this.itemId, "itemId required for updates");
        }
    }

    public CreateAction getCreateAction() {
        return this.createAction;
    }

    public UploadItem setCreateAction(CreateAction createAction) {
        this.createAction = createAction;
        return this;
    }

    public FolderId getParentFolderId() {
        return this.parentFolderId;
    }

    public UploadItem setParentFolderId(FolderId parentFolderId) {
        this.parentFolderId = parentFolderId;
        return this;
    }

    public ItemId getItemId() {
        return this.itemId;
    }

    public UploadItem setItemId(ItemId itemId) {
        this.itemId = itemId;
        return this;
    }

    public byte[] getData() {
        return this.data;
    }

    public UploadItem setData(byte[] data) {
        this.data = data;
        return this;
    }

    public static enum CreateAction {
        CreateNew,
        Update;

    }
}

