/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.misc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.service.item.Item;
import microsoft.exchange.webservices.data.misc.AbstractItemIdWrapper;
import microsoft.exchange.webservices.data.misc.ItemIdWrapper;
import microsoft.exchange.webservices.data.misc.ItemWrapper;
import microsoft.exchange.webservices.data.property.complex.ItemId;

public class ItemIdWrapperList
implements Iterable<AbstractItemIdWrapper> {
    private List<AbstractItemIdWrapper> itemIds = new ArrayList<AbstractItemIdWrapper>();

    protected void add(Item item) throws ServiceLocalException {
        this.itemIds.add(new ItemWrapper(item));
    }

    public void addRangeItem(Iterable<Item> items) throws ServiceLocalException {
        for (Item item : items) {
            this.add(item);
        }
    }

    public void addRange(Iterable<ItemId> itemIds) {
        for (ItemId itemId : itemIds) {
            this.add(itemId);
        }
    }

    protected void add(ItemId itemId) {
        this.itemIds.add(new ItemIdWrapper(itemId));
    }

    public void writeToXml(EwsServiceXmlWriter writer, XmlNamespace ewsNamesapce, String xmlElementName) throws Exception {
        if (this.getCount() > 0) {
            writer.writeStartElement(ewsNamesapce, xmlElementName);
            for (AbstractItemIdWrapper itemIdWrapper : this.itemIds) {
                itemIdWrapper.writeToXml(writer);
            }
            writer.writeEndElement();
        }
    }

    public int getCount() {
        return this.itemIds.size();
    }

    public Item getItemIdWrapperList(int i) {
        return this.itemIds.get(i).getItem();
    }

    @Override
    public Iterator<AbstractItemIdWrapper> iterator() {
        return this.itemIds.iterator();
    }

    public String toString() {
        return this.itemIds.toString();
    }
}

