/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.misc.availability;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.ISelfValidate;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;

public class TimeWindow
implements ISelfValidate {
    private Date startTime;
    private Date endTime;

    public TimeWindow() {
    }

    public TimeWindow(Date startTime, Date endTime) {
        this();
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void loadFromXml(EwsServiceXmlReader reader) throws Exception {
        reader.ensureCurrentNodeIsStartElement(XmlNamespace.Types, "Duration");
        this.startTime = reader.readElementValueAsDateTime(XmlNamespace.Types, "StartTime");
        this.endTime = reader.readElementValueAsDateTime(XmlNamespace.Types, "EndTime");
        reader.readEndElement(XmlNamespace.Types, "Duration");
    }

    private static void writeToXml(EwsServiceXmlWriter writer, String xmlElementName, Object startTime, Object endTime) throws XMLStreamException, ServiceXmlSerializationException {
        writer.writeStartElement(XmlNamespace.Types, xmlElementName);
        writer.writeElementValue(XmlNamespace.Types, "StartTime", startTime);
        writer.writeElementValue(XmlNamespace.Types, "EndTime", endTime);
        writer.writeEndElement();
    }

    protected void writeToXmlUnscopedDatesOnly(EwsServiceXmlWriter writer, String xmlElementName) throws XMLStreamException, ServiceXmlSerializationException {
        String DateOnlyFormat = "yyyy-MM-dd'T'00:00:00";
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'00:00:00");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        String start = formatter.format(this.startTime);
        String end = formatter.format(this.endTime);
        TimeWindow.writeToXml(writer, xmlElementName, start, end);
    }

    public void writeToXml(EwsServiceXmlWriter writer, String xmlElementName) throws XMLStreamException, ServiceXmlSerializationException {
        TimeWindow.writeToXml(writer, xmlElementName, this.startTime, this.endTime);
    }

    public long getDuration() {
        return this.endTime.getTime() - this.startTime.getTime();
    }

    @Override
    public void validate() {
    }
}

