/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.permission.folder.DelegateFolderPermissionLevel;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceValidationException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.property.complex.ComplexProperty;

public final class DelegatePermissions
extends ComplexProperty {
    private Map<String, DelegateFolderPermission> delegateFolderPermissions = new HashMap<String, DelegateFolderPermission>();

    protected DelegatePermissions() {
        this.delegateFolderPermissions.put("CalendarFolderPermissionLevel", new DelegateFolderPermission());
        this.delegateFolderPermissions.put("TasksFolderPermissionLevel", new DelegateFolderPermission());
        this.delegateFolderPermissions.put("InboxFolderPermissionLevel", new DelegateFolderPermission());
        this.delegateFolderPermissions.put("ContactsFolderPermissionLevel", new DelegateFolderPermission());
        this.delegateFolderPermissions.put("NotesFolderPermissionLevel", new DelegateFolderPermission());
        this.delegateFolderPermissions.put("JournalFolderPermissionLevel", new DelegateFolderPermission());
    }

    public DelegateFolderPermissionLevel getCalendarFolderPermissionLevel() {
        return this.delegateFolderPermissions.get("CalendarFolderPermissionLevel").getPermissionLevel();
    }

    public void setCalendarFolderPermissionLevel(DelegateFolderPermissionLevel value) {
        this.delegateFolderPermissions.get("CalendarFolderPermissionLevel").setPermissionLevel(value);
    }

    public DelegateFolderPermissionLevel getTasksFolderPermissionLevel() {
        return this.delegateFolderPermissions.get("TasksFolderPermissionLevel").getPermissionLevel();
    }

    public void setTasksFolderPermissionLevel(DelegateFolderPermissionLevel value) {
        this.delegateFolderPermissions.get("TasksFolderPermissionLevel").setPermissionLevel(value);
    }

    public DelegateFolderPermissionLevel getInboxFolderPermissionLevel() {
        return this.delegateFolderPermissions.get("InboxFolderPermissionLevel").getPermissionLevel();
    }

    public void setInboxFolderPermissionLevel(DelegateFolderPermissionLevel value) {
        this.delegateFolderPermissions.get("InboxFolderPermissionLevel").setPermissionLevel(value);
    }

    public DelegateFolderPermissionLevel getContactsFolderPermissionLevel() {
        return this.delegateFolderPermissions.get("ContactsFolderPermissionLevel").getPermissionLevel();
    }

    public void setContactsFolderPermissionLevel(DelegateFolderPermissionLevel value) {
        this.delegateFolderPermissions.get("ContactsFolderPermissionLevel").setPermissionLevel(value);
    }

    public DelegateFolderPermissionLevel getNotesFolderPermissionLevel() {
        return this.delegateFolderPermissions.get("NotesFolderPermissionLevel").getPermissionLevel();
    }

    public void setNotesFolderPermissionLevel(DelegateFolderPermissionLevel value) {
        this.delegateFolderPermissions.get("NotesFolderPermissionLevel").setPermissionLevel(value);
    }

    public DelegateFolderPermissionLevel getJournalFolderPermissionLevel() {
        return this.delegateFolderPermissions.get("JournalFolderPermissionLevel").getPermissionLevel();
    }

    public void setJournalFolderPermissionLevel(DelegateFolderPermissionLevel value) {
        this.delegateFolderPermissions.get("JournalFolderPermissionLevel").setPermissionLevel(value);
    }

    protected void reset() {
        for (DelegateFolderPermission delegateFolderPermission : this.delegateFolderPermissions.values()) {
            delegateFolderPermission.reset();
        }
    }

    @Override
    public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        DelegateFolderPermission delegateFolderPermission = null;
        if (this.delegateFolderPermissions.containsKey(reader.getLocalName())) {
            delegateFolderPermission = this.delegateFolderPermissions.get(reader.getLocalName());
            delegateFolderPermission.initialize(reader.readElementValue(DelegateFolderPermissionLevel.class));
        }
        return delegateFolderPermission != null;
    }

    @Override
    public void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        this.writePermissionToXml(writer, "CalendarFolderPermissionLevel");
        this.writePermissionToXml(writer, "TasksFolderPermissionLevel");
        this.writePermissionToXml(writer, "InboxFolderPermissionLevel");
        this.writePermissionToXml(writer, "ContactsFolderPermissionLevel");
        this.writePermissionToXml(writer, "NotesFolderPermissionLevel");
        this.writePermissionToXml(writer, "JournalFolderPermissionLevel");
    }

    private void writePermissionToXml(EwsServiceXmlWriter writer, String xmlElementName) throws ServiceXmlSerializationException, XMLStreamException {
        DelegateFolderPermissionLevel delegateFolderPermissionLevel = this.delegateFolderPermissions.get(xmlElementName).getPermissionLevel();
        if (delegateFolderPermissionLevel != DelegateFolderPermissionLevel.Custom) {
            writer.writeElementValue(XmlNamespace.Types, xmlElementName, (Object)delegateFolderPermissionLevel);
        }
    }

    protected void validateAddDelegate() throws ServiceValidationException {
        for (DelegateFolderPermission delegateFolderPermission : this.delegateFolderPermissions.values()) {
            if (delegateFolderPermission.getPermissionLevel() != DelegateFolderPermissionLevel.Custom) continue;
            throw new ServiceValidationException("This operation can't be performed because one or more folder permission levels were set to Custom.");
        }
    }

    protected void validateUpdateDelegate() throws ServiceValidationException {
        for (DelegateFolderPermission delegateFolderPermission : this.delegateFolderPermissions.values()) {
            if (delegateFolderPermission.getPermissionLevel() != DelegateFolderPermissionLevel.Custom || delegateFolderPermission.isExistingPermissionLevelCustom) continue;
            throw new ServiceValidationException("This operation can't be performed because one or more folder permission levels were set to Custom.");
        }
    }

    private static class DelegateFolderPermission {
        private DelegateFolderPermissionLevel permissionLevel = DelegateFolderPermissionLevel.None;
        private boolean isExistingPermissionLevelCustom;

        private DelegateFolderPermission() {
        }

        protected void initialize(DelegateFolderPermissionLevel permissionLevel) {
            this.setPermissionLevel(permissionLevel);
            this.setIsExistingPermissionLevelCustom(permissionLevel == DelegateFolderPermissionLevel.Custom);
        }

        protected void reset() {
            this.initialize(DelegateFolderPermissionLevel.None);
        }

        protected DelegateFolderPermissionLevel getPermissionLevel() {
            return this.permissionLevel;
        }

        protected void setPermissionLevel(DelegateFolderPermissionLevel value) {
            this.permissionLevel = value;
        }

        protected boolean getIsExistingPermissionLevelCustom() {
            return this.isExistingPermissionLevelCustom;
        }

        private void setIsExistingPermissionLevelCustom(Boolean value) {
            this.isExistingPermissionLevelCustom = value;
        }
    }
}

