/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex.time;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.property.time.DayOfTheWeek;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.property.complex.time.AbsoluteMonthTransition;
import microsoft.exchange.webservices.data.property.complex.time.TimeZoneDefinition;
import microsoft.exchange.webservices.data.property.complex.time.TimeZonePeriod;

class RelativeDayOfMonthTransition
extends AbsoluteMonthTransition {
    private DayOfTheWeek dayOfTheWeek;
    private int weekIndex;

    @Override
    protected String getXmlElementName() {
        return "RecurringDayTransition";
    }

    @Override
    public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (super.tryReadElementFromXml(reader)) {
            return true;
        }
        if (reader.getLocalName().equals("DayOfWeek")) {
            this.dayOfTheWeek = reader.readElementValue(DayOfTheWeek.class);
            return true;
        }
        if (reader.getLocalName().equals("Occurrence")) {
            this.weekIndex = reader.readElementValue(Integer.class);
            return true;
        }
        return false;
    }

    @Override
    public void writeElementsToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException, XMLStreamException {
        super.writeElementsToXml(writer);
        writer.writeElementValue(XmlNamespace.Types, "DayOfWeek", (Object)this.dayOfTheWeek);
        writer.writeElementValue(XmlNamespace.Types, "Occurrence", this.weekIndex);
    }

    protected RelativeDayOfMonthTransition(TimeZoneDefinition timeZoneDefinition) {
        super(timeZoneDefinition);
    }

    protected RelativeDayOfMonthTransition(TimeZoneDefinition timeZoneDefinition, TimeZonePeriod targetPeriod) {
        super(timeZoneDefinition, targetPeriod);
    }

    protected DayOfTheWeek getDayOfTheWeek() {
        return this.dayOfTheWeek;
    }

    protected int getWeekIndex() {
        return this.weekIndex;
    }
}

