/*
 * Decompiled with CFR 0.152.
 */
package com.svenruppert.dependencies.core.basepattern.builder;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class NestedBuilder<T, V> {
    protected T parent;

    public T done() {
        Class<?> parentClass = this.parent.getClass();
        try {
            V build = this.build();
            String methodname = "with" + build.getClass().getSimpleName();
            Method method = parentClass.getDeclaredMethod(methodname, build.getClass());
            boolean accessible = method.canAccess(this.parent);
            method.setAccessible(true);
            method.invoke(this.parent, build);
            method.setAccessible(accessible);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return this.parent;
    }

    public abstract V build();

    public <P extends NestedBuilder<T, V>> P withParentBuilder(T parent) {
        this.parent = parent;
        return (P)this;
    }
}

