/*
 * Decompiled with CFR 0.152.
 */
package com.svenruppert.dependencies.core.fs;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class DirectoryUtils {
    public boolean deleteIndexDirectory(String directoryName) {
        Path indexDirectory = Paths.get(directoryName, new String[0]);
        return this.delete(indexDirectory);
    }

    public boolean deleteIndexDirectory(Path directoryPath) {
        return this.delete(directoryPath);
    }

    private boolean delete(Path indexDirectory) {
        if (Files.exists(indexDirectory, new LinkOption[0])) {
            try {
                Files.walkFileTree(indexDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }
        return false;
    }
}

