/*
 * Decompiled with CFR 0.152.
 */
package com.svenruppert.dependencies.core.logger;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface HasLogger {
    public static final Map<Class<?>, Logger> LOGGER_CACHE = new ConcurrentHashMap();

    public static Logger staticLogger() {
        Class<?> callerClass = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass();
        return LOGGER_CACHE.computeIfAbsent(callerClass, LoggerFactory::getLogger);
    }

    default public Logger logger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    default public Logger logger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz);
    }
}

