/*
 * Decompiled with CFR 0.152.
 */
package com.svenruppert.dependencies.core.reflections;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class NewInstances {
    private NewInstances() {
    }

    public static <T> List<T> createInstances(Set<Class<? extends T>> classes) {
        if (classes == null) {
            return Collections.emptyList();
        }
        return classes.stream().map(c -> {
            try {
                return Optional.of(c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                return Optional.empty();
            }
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public static <T> Optional<T> createInstance(Class<? extends T> clazz) {
        if (clazz == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }
}

