/*
 * Decompiled with CFR 0.152.
 */
package com.svenruppert.dependencies.core.serviceprovider;

import com.svenruppert.dependencies.core.logger.HasLogger;
import java.util.Iterator;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public interface ServiceProvider<T>
extends HasLogger {
    default public Function<Class<T>, Optional<T>> loadServiceFkt() {
        return service -> {
            Iterator iterator = ServiceLoader.load(service).iterator();
            Iterable iterable = () -> iterator;
            Set set = StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toSet());
            if (set.isEmpty()) {
                String msg = "no implementation found for interface " + service.getName();
                this.logger((Class<?>)service).warn(msg);
                this.logger().warn("no implementation found for interface " + service.getName());
                return Optional.empty();
            }
            if (set.size() > 1) {
                String msg = "to many implementations found for interface " + service.getName();
                this.logger((Class<?>)service).warn(msg);
                this.logger().warn("to many implementations found for interface " + service.getName());
                return Optional.empty();
            }
            return Optional.of(set.iterator().next());
        };
    }

    public Class<T> serviceInterface();

    default public Optional<T> load() {
        return this.loadServiceFkt().apply(this.serviceInterface());
    }
}

